/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.util.AgitarProperties;
import com.agitar.licensechecker.Crypt;
import com.agitar.licensechecker.InvalidLicenseException;
import com.agitar.licensechecker.LicenseLogger;
import com.agitar.licensechecker.MachineName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ApplicationInfo {
    private static final String DEFAULT_BASE_PREFERENCE_NODE = "com/agitar/agitarone/licensekey";
    private static final String PREFERENCE_PASS = "pass";
    private static final String PREFERENCE_DURATION = "dur";
    private static final String PREFERENCE_KEY = "key";
    private String basePreferenceNodeName;
    protected Preferences pref;
    private boolean useMachineSpecificPreference;
    protected String productKey = null;
    protected String customerId = null;
    protected String emailAddress = null;
    private String encPass = null;
    private String licenseString = null;
    protected boolean floating;
    protected long duration = -1L;
    protected Long sessionId;
    private Long sessionIdOverride;
    long quotaCap = -1L;
    private static boolean telemetryEnabled = false;
    public static final int DEFAULT_CO_DURATION = 1296000;
    public static final int DEFAULT_FLOAT_DURATION = 0;
    public static final int DEFAULT_FLOAT_DURATION_WITHLOCALEATURE = 86400;
    public static final int DEFAULT_FLOAT_DURATION_WITHNOLOCALEATURE = 86400;
    public static final long DEFAULT_ACTIVATION_DURATION = 630720000L;
    public static final int UNSET_DURATION = -1;

    protected ApplicationInfo() {
    }

    protected ApplicationInfo(String customerId, String productKey, String emailAddress, boolean floating, String basePreferenceNode, boolean machineSpecific) throws InvalidLicenseException {
        this.checkNotNullOrEmpty(basePreferenceNode, false, "Preference Node");
        this.checkNotNullOrEmpty(customerId, false, "License ID");
        this.checkNotNullOrEmpty(productKey, floating, "Product Key");
        this.checkNotNullOrEmpty(emailAddress, false, "Email Address");
        if (basePreferenceNode.endsWith("/")) {
            throw new IllegalArgumentException("Base preferences node for licensing preferences cannot end in '/'");
        }
        this.basePreferenceNodeName = basePreferenceNode;
        this.useMachineSpecificPreference = machineSpecific;
        this.setProductKey(productKey);
        this.customerId = customerId.trim();
        this.emailAddress = emailAddress.trim();
        this.floating = floating;
        this.sessionId = this.makeSessionId();
        this.duration = floating ? 0L : 1296000L;
        LicenseLogger.fine("Application info created from code: " + this.toString());
    }

    protected Long makeSessionId() {
        String username = System.getProperty("user.name");
        String homedir = System.getProperty("user.home");
        int sessionHash = (username + homedir).hashCode();
        if (sessionHash < 0) {
            sessionHash *= -1;
        }
        return new Long(sessionHash);
    }

    public long getSessionId() {
        if (this.sessionIdOverride != null) {
            return this.sessionIdOverride;
        }
        return this.sessionId;
    }

    private ApplicationInfo(String basePreferenceNode, boolean machineSpecific) throws InvalidLicenseException {
        this.checkNotNullOrEmpty(basePreferenceNode, false, "Preference Node");
        this.basePreferenceNodeName = basePreferenceNode;
        this.useMachineSpecificPreference = machineSpecific;
        this.initPref();
        this.sessionId = this.makeSessionId();
        this.parse(this.pref.get(PREFERENCE_PASS, null));
        String durationString = this.pref.get(PREFERENCE_DURATION, null);
        if (durationString != null) {
            this.duration = Long.parseLong(durationString);
        }
        this.licenseString = this.pref.get(PREFERENCE_KEY, null);
        LicenseLogger.fine("Application info created from persisted state: " + this.toString());
    }

    public static ApplicationInfo getSavedInfo() throws InvalidLicenseException {
        return ApplicationInfo.getSavedInfo(DEFAULT_BASE_PREFERENCE_NODE);
    }

    public static ApplicationInfo getNewInfo(String customerId, String productKey, String emailAddress, boolean floating) throws InvalidLicenseException {
        return ApplicationInfo.getNewInfo(customerId, productKey, emailAddress, floating, DEFAULT_BASE_PREFERENCE_NODE, true);
    }

    static ApplicationInfo getNewInfo(String customerId, String productKey, String emailAddress, boolean floating, String basePreferenceNode, boolean machineSpecific) throws InvalidLicenseException {
        return new ApplicationInfo(customerId, productKey, emailAddress, floating, basePreferenceNode, machineSpecific);
    }

    static ApplicationInfo getSavedInfo(String basePreferenceNode) throws InvalidLicenseException {
        ApplicationInfo machineSpecificInfo = ApplicationInfo.getSavedInfo(basePreferenceNode, true);
        if (machineSpecificInfo.isValid()) {
            return machineSpecificInfo;
        }
        ApplicationInfo globalInfo = new ApplicationInfo(basePreferenceNode, false);
        if (globalInfo.isFloating()) {
            return globalInfo;
        }
        if (globalInfo.isValid()) {
            machineSpecificInfo = ApplicationInfo.getNewInfo(globalInfo.getCustomerId(), globalInfo.getProductKey(), globalInfo.getEmailAddress(), globalInfo.isFloating(), basePreferenceNode, true);
            machineSpecificInfo.setLicenseString(globalInfo.getLicenseString());
            machineSpecificInfo.setDuration(globalInfo.getDuration());
            machineSpecificInfo.save();
            globalInfo.deleteInfo();
        }
        return machineSpecificInfo;
    }

    static ApplicationInfo getSavedInfo(String basePreferenceNode, boolean machineSpecific) throws InvalidLicenseException {
        return new ApplicationInfo(basePreferenceNode, machineSpecific);
    }

    protected void checkNotNullOrEmpty(String str, boolean except, String fieldName) throws InvalidLicenseException {
        if (!(except || str != null && str.length() != 0)) {
            throw new InvalidLicenseException(fieldName + " cannot be empty!");
        }
    }

    protected void initPref() {
        this.pref = Preferences.userRoot().node(this.getActualPreferenceNode());
    }

    protected String getDefaultPreferenceNode() {
        return this.basePreferenceNodeName;
    }

    protected String getActualPreferenceNode() {
        if (this.floating || !this.useMachineSpecificPreference) {
            return this.getDefaultPreferenceNode();
        }
        String hostName = MachineName.getHostName();
        if (hostName == null) {
            LicenseLogger.log(AgitarLevel.SEVERE, "cannot get host name; defaulting to non-machine specific pref key");
            return this.getDefaultPreferenceNode();
        }
        return this.getDefaultPreferenceNode() + "/" + hostName;
    }

    private void parse(String str) throws InvalidLicenseException {
        if (str == null) {
            return;
        }
        this.encPass = str;
        String[] s = (str = Crypt.decrypt(str)).split("\\^");
        int n = s.length;
        if (n < 3 || n > 5) {
            this.deleteInfo();
            return;
        }
        this.customerId = s[0];
        this.setProductKey(s[1].trim());
        this.emailAddress = s[2];
        if (n > 3) {
            if (n > 4) {
                this.floating = new Boolean(s[3]);
                this.duration = new Long(s[4]);
            } else {
                this.duration = new Long(s[3]);
            }
        } else {
            this.duration = 1296000L;
            this.floating = false;
        }
    }

    private String getPass() {
        if (this.encPass == null) {
            this.encPass = !this.floating ? this.customerId + '^' + (this.productKey == null ? " " : this.productKey) + '^' + this.emailAddress : this.customerId + '^' + (this.productKey == null ? " " : this.productKey) + '^' + this.emailAddress + '^' + this.floating + '^' + this.duration;
            this.encPass = Crypt.encrypt(this.encPass);
        }
        return this.encPass;
    }

    public void save() {
        try {
            boolean flush = false;
            if (this.pref == null) {
                this.initPref();
            }
            if (this.isValid()) {
                this.pref.put(PREFERENCE_PASS, this.getPass());
                this.pref.put(PREFERENCE_DURATION, "" + this.duration);
                flush = true;
            }
            if (this.licenseString != null) {
                this.pref.put(PREFERENCE_KEY, this.licenseString);
                flush = true;
            }
            if (flush) {
                this.pref.flush();
                LicenseLogger.fine("registry successfully flushed to disk");
            }
        }
        catch (BackingStoreException e) {
            LicenseLogger.log(AgitarLevel.SEVERE, "could not save application info", e);
            throw new IllegalStateException("could not save application info");
        }
    }

    public void deleteInfo() throws InvalidLicenseException {
        try {
            if (this.pref == null) {
                this.initPref();
            }
            this.pref.remove(PREFERENCE_KEY);
            this.pref.remove(PREFERENCE_PASS);
            this.pref.remove(PREFERENCE_DURATION);
            this.pref.flush();
        }
        catch (BackingStoreException e) {
            throw new InvalidLicenseException("error deleting user preference", e);
        }
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    public boolean isValid() {
        return this.customerId != null;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getProductKey() {
        return this.productKey;
    }

    private void setProductKey(String productKey) {
        this.productKey = productKey == null ? "" : productKey.toLowerCase().trim();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) throws InvalidLicenseException {
        if (duration < 0L) {
            throw new InvalidLicenseException("Duration must be greater than 0.");
        }
        this.duration = duration;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public long getDurationInHours() {
        return this.duration / 3600L;
    }

    public String toString() {
        return "productKey[" + this.productKey + "], customerId[" + this.customerId + "], emailAddress[" + this.emailAddress + "], floating[" + this.floating + "], node[" + this.getActualPreferenceNode() + "]";
    }

    public long getCheckoutDuration() {
        if (this.getDuration() == -1L) {
            throw new IllegalStateException("duration not set yet");
        }
        if (this.getDuration() == 0L) {
            return 86400L;
        }
        return this.getDuration();
    }

    public boolean equals(ApplicationInfo toCompare) {
        return this.nullFriendlyEquals(this.emailAddress, toCompare.getEmailAddress()) && this.nullFriendlyEquals(this.customerId, toCompare.getCustomerId()) && this.floating == toCompare.isFloating() && this.nullFriendlyEquals(this.productKey, toCompare.getProductKey());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected boolean nullFriendlyEquals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public void setSessionIdOverrides(Long override) {
        this.sessionIdOverride = override;
    }

    public long getQuotaCap() {
        return this.quotaCap;
    }

    public void setQuotaCap(long quotaCap) {
        this.quotaCap = quotaCap;
    }

    public static ApplicationInfo commandLineInput() {
        return ApplicationInfo.commandLineInput(System.in);
    }

    static ApplicationInfo commandLineInput(InputStream commandLineInput) {
        System.out.println("=== Agitar Product Registration ===");
        BufferedReader br = new BufferedReader(new InputStreamReader(commandLineInput));
        try {
            Boolean floating = Boolean.TRUE;
            System.out.print("License ID     : ");
            String cId = br.readLine();
            String pKey = "";
            System.out.print("User ID   : ");
            String email = br.readLine();
            System.out.println("Registering ...");
            if (email == null || email.length() == 0) {
                email = AgitarProperties.USER_NAME;
            }
            return ApplicationInfo.getNewInfo(cId, pKey, email, floating);
        }
        catch (IOException x) {
            System.err.println("Error receiving input: Please use Agitar client to register.");
            return null;
        }
        catch (InvalidLicenseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
}

