/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.licensechecker.ApplicationInfo;
import com.agitar.licensechecker.InvalidLicenseException;
import com.agitar.licensechecker.LicenseLogger;
import com.agitar.licensechecker.LicenseServerUrl;
import com.agitar.licensechecker.LicensedFeature;
import com.agitar.licensechecker.Licenser;
import com.agitar.licensechecker.LicenserFactory;
import com.agitar.licensechecker.MachineName;
import com.agitar.licensechecker.ProxyInfo;
import com.agitar.licensechecker.RunnableSucceedsOrNot;
import com.agitar.licensechecker.Timer;
import java.net.SocketException;
import java.util.logging.Level;

public abstract class AbstractLicenseChecker {
    protected LicenserFactory licenserFactory;
    protected LicenseServerUrl serverUrl;
    protected MachineName machineName;
    protected boolean useHashedMachineID = false;

    public abstract void checkLicense(LicensedFeature var1, ApplicationInfo var2) throws InvalidLicenseException, SocketException;

    protected abstract void cleanLicenserChecker(ApplicationInfo var1);

    public abstract Licenser getLicenser(ApplicationInfo var1);

    protected abstract void restoreStateDuringCheckin(ApplicationInfo var1, Licenser var2) throws InvalidLicenseException;

    protected ProxyInfo enableProxyIfNeeded() {
        ProxyInfo pInfo = new ProxyInfo();
        if (pInfo.isValid()) {
            pInfo.setProxy();
        }
        return pInfo;
    }

    protected void handleFailedCheckout(Licenser licenser, ProxyInfo pInfo) throws SocketException, InvalidLicenseException {
        int statusCode = licenser.getStatus();
        LicenseLogger.warning("checkout failed with status code " + statusCode);
        if (statusCode == 29) {
            if (pInfo != null && pInfo.isValid() && pInfo.isEnable()) {
                pInfo.logProxyAttempt();
            } else {
                throw new SocketException("Cannot connect to the license server. Please check your server settings or network connectivity and retry.");
            }
        }
        throw new InvalidLicenseException("", licenser);
    }

    protected void manageQuota(ApplicationInfo info, Licenser licenser) {
        info.setQuotaCap(licenser.getQuotaCap());
        licenser.upQuotaUseLevel(-1);
    }

    public synchronized void checkin(ApplicationInfo info) throws InvalidLicenseException {
        boolean success;
        try {
            success = this.timedCheckin(info);
            this.cleanLicenserChecker(info);
        }
        catch (InterruptedException e) {
            success = false;
        }
        LicenseLogger.finer("attempted to check in old license during registration. success? " + success);
    }

    protected synchronized boolean timedCheckout(final Licenser licenser, final long time) throws InterruptedException {
        RunnableSucceedsOrNot r = new RunnableSucceedsOrNot(){

            public void run() {
                this.setResult(licenser.checkout(time));
            }
        };
        return new Timer().time(r, "checkout");
    }

    protected synchronized boolean timedCheckin(final ApplicationInfo info) throws InterruptedException {
        RunnableSucceedsOrNot r = new RunnableSucceedsOrNot(){

            public void run() {
                this.setResult(AbstractLicenseChecker.this.ilsCheckin(info));
            }
        };
        return new Timer().time(r, "checkin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ilsCheckin(ApplicationInfo info) {
        Licenser licenser = this.getLicenser(info);
        ProxyInfo pInfo = this.enableProxyIfNeeded();
        try {
            this.restoreStateDuringCheckin(info, licenser);
            if (licenser.checkin()) {
                boolean bl = true;
                return bl;
            }
            LicenseLogger.warning("Failed to return license: " + licenser.getMsg());
            if (licenser.getStatus() == 29 && pInfo.isValid() && pInfo.isEnable()) {
                pInfo.logProxyAttempt();
            }
        }
        catch (Exception x) {
            LicenseLogger.log(Level.WARNING, "Failed to return license: " + licenser.getMsg(), x);
        }
        finally {
            if (pInfo.isValid()) {
                pInfo.unsetProxy();
            }
        }
        return false;
    }

    protected Licenser getLicenser(String customerId, String productKey, boolean isFloating, long sessionId) {
        return this.licenserFactory.getLicenser(this.getServerUrl().getUrl(), this.getMachineFingerprint(), customerId, productKey, isFloating, sessionId);
    }

    public String getMachineFingerprint() {
        return this.useHashedMachineID ? this.getMachineName().getActivationID() : this.getMachineName().getMachineFingerprint();
    }

    LicenseServerUrl getServerUrl() {
        if (this.serverUrl != null) {
            return this.serverUrl;
        }
        return new LicenseServerUrl();
    }

    protected MachineName getMachineName() {
        return this.machineName;
    }

    public void setLicenseServerUrl(LicenseServerUrl newURL) {
        this.serverUrl = newURL;
    }
}

