/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.license.quota;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.license.quota.QuotaRuntimeException;
import com.agitar.license.quota.QuotaStore;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;

public class QuotaStoreFromFile
implements QuotaStore {
    private final Logger logger = AgitarLogger.getDiagnosticLogger((String)"license.quota");
    private HashSet fileSet = new HashSet();
    private String filePath;
    private File raFile;
    private boolean isOpen = false;

    public QuotaStoreFromFile(String file) {
        this.filePath = file;
    }

    QuotaStoreFromFile(File file) {
        this.filePath = file.getAbsolutePath();
        this.raFile = file;
    }

    public synchronized void add(String encryptedName) {
        this.fileSet.add(encryptedName);
        try {
            this.save();
        }
        catch (RuntimeException ex) {
            this.fileSet.remove(encryptedName);
            throw ex;
        }
    }

    public synchronized void remove(String encryptedName) {
        this.fileSet.remove(encryptedName);
        try {
            this.save();
        }
        catch (RuntimeException ex) {
            this.fileSet.add(encryptedName);
            throw ex;
        }
    }

    public synchronized boolean contains(String encryptedName) {
        return this.fileSet.contains(encryptedName);
    }

    public synchronized int size() {
        return this.fileSet.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void open() {
        block12: {
            if (!this.isOpen) {
                this.raFile = new File(this.filePath);
                if (!this.raFile.exists()) {
                    this.logger.warning("Quota storage file not found.  Creating: " + this.filePath);
                    try {
                        this.raFile.createNewFile();
                    }
                    catch (IOException e) {
                        throw new QuotaRuntimeException("Fail to create: " + this.filePath, e);
                    }
                }
                LineNumberReader br = null;
                try {
                    try {
                        br = new LineNumberReader(new FileReader(this.raFile));
                        String line = null;
                        while ((line = ((BufferedReader)br).readLine()) != null) {
                            this.fileSet.add(line);
                        }
                        Object var4_5 = null;
                        if (br == null) break block12;
                    }
                    catch (IOException iox) {
                        throw new QuotaRuntimeException("Could not open quota storage", iox);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (br == null) throw throwable;
                    try {
                        br.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new QuotaRuntimeException("Could not open quota storage", e);
                    }
                }
                try {}
                catch (IOException e) {
                    throw new QuotaRuntimeException("Could not open quota storage", e);
                }
                br.close();
            }
        }
        this.isOpen = true;
    }

    public synchronized void close() {
        this.fileSet.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void save() {
        if (this.raFile == null) {
            throw new QuotaRuntimeException("Quota storage not opened.");
        }
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new FileWriter(this.raFile));
                Iterator iter = this.fileSet.iterator();
                while (iter.hasNext()) {
                    String element = (String)iter.next();
                    bw.write(element.toCharArray());
                    bw.newLine();
                }
                bw.close();
            }
            catch (IOException iox) {
                throw new QuotaRuntimeException("Could not save to quota storage.", iox);
            }
            Object var5_5 = null;
            if (bw == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bw == null) throw throwable;
            try {
                bw.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new QuotaRuntimeException("Could not save to quota storage.", e);
            }
        }
        try {}
        catch (IOException e) {
            throw new QuotaRuntimeException("Could not save to quota storage.", e);
        }
        bw.close();
    }

    public String getFilePath() {
        return this.filePath;
    }
}

