/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.license.quota;

import com.agitar.license.quota.EncryptedHash;
import com.agitar.license.quota.QuotaPool;
import com.agitar.license.quota.QuotaStore;

public class CustomerQuotaPool
implements QuotaPool {
    String id;
    QuotaStore store;
    private long accountedUsage;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CustomerQuotaPool(String poolid, long size, QuotaStore store1) {
        if (!$assertionsDisabled && poolid == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && store1 == null) {
            throw new AssertionError();
        }
        this.id = poolid;
        this.store = store1;
        this.store.open();
    }

    public int accountClass(String className) {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        String encryptedName = this.encryptClassName(className);
        if (this.isEncrytedClassAccounted(encryptedName)) {
            return 1;
        }
        this.store.add(encryptedName);
        return 0;
    }

    String encryptClassName(String className) {
        return EncryptedHash.generate(className);
    }

    public boolean isClassAccounted(String className) {
        String encryptedName = this.encryptClassName(className);
        return this.isEncrytedClassAccounted(encryptedName);
    }

    private boolean isEncrytedClassAccounted(String encryptedName) {
        return this.store.contains(encryptedName);
    }

    public int removeClass(String className) {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        String encryptedName = this.encryptClassName(className);
        this.store.remove(encryptedName);
        return 0;
    }

    public int getQuotaCount() {
        return this.store.size();
    }

    public long getAccountedUsage() {
        return this.accountedUsage;
    }

    public String getId() {
        return this.id;
    }

    public QuotaStore getStore() {
        return this.store;
    }

    public void close() {
        this.store.close();
    }

    static {
        $assertionsDisabled = !CustomerQuotaPool.class.desiredAssertionStatus();
    }
}

