/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.license.admin;

import com.agitar.common.util.StringUtility;
import com.agitar.common.util.XMLUtility;
import com.agitar.common.util.XmlDocument;
import com.agitar.licensechecker.InvalidLicenseException;
import com.agitar.licensechecker.LicenseLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class LicenserKeyParser {
    private static final int MAX_DOMAINS = 100;
    public static final char ILS_OPTIONS_DELIMITER = ';';
    public static final char ILS_OPTIONS_VALUE_DELIMITER = '=';
    public static final String ILS_OPTIONS_KEY_LOCAL_AGITATION = "local-agitation";
    public static final String ILS_OPTIONS_KEY_LOCAL_GENERATION = "local-generation";
    public static final String ILS_OPTIONS_KEY_REMOTE_AGITATION = "remote-agitation";
    public static final String ILS_OPTIONS_KEY_REMOTE_GENERATION = "remote-generation";
    public static final String ILS_OPTIONS_KEY_QUOTA = "quota";
    public static final String ILS_OPTIONS_KEY_NAME = "name";
    public static final String ILS_OPTIONS_KEY_OPTIONS = "options";
    public static final String ILS_OPTIONS_KEY_AG_PFX = "AG:domain-";
    protected String xmlKey;
    private DomainInfo[] domains = new DomainInfo[0];
    private String options;
    private String key;
    private String productName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LicenserKeyParser(String key) throws InvalidLicenseException {
        this.xmlKey = key;
        try {
            this.parseLicenseKey(this.xmlKey);
        }
        catch (Exception e) {
            throw new InvalidLicenseException("Can't parse licenseKey" + key, e);
        }
        this.validateKey();
    }

    private void parseLicenseKey(String key2) throws IOException, ParserConfigurationException, SAXException {
        XmlDocument doc = new XmlDocument(key2);
        Element[] elements = XMLUtility.getElementsByTagName((Element)doc.getDocumentRoot(), (String)"key");
        if (!$assertionsDisabled && elements.length <= 0) {
            throw new AssertionError();
        }
        Element keyNode = elements[0];
        this.options = keyNode.getAttribute(ILS_OPTIONS_KEY_OPTIONS);
        this.key = keyNode.getFirstChild().getNodeValue();
        this.productName = keyNode.getAttribute("product");
    }

    public String getOptions() {
        return this.options;
    }

    public String getLicenseKey() {
        return this.key;
    }

    public String getProductName() {
        return this.productName;
    }

    public String toString() {
        return this.key;
    }

    public DomainInfo[] getDomains() {
        return this.domains;
    }

    void validateKey() throws InvalidLicenseException {
        this.domains = this.parseDomains(this.getOptions());
    }

    private boolean getFeatureOption(String featureOption) throws InvalidLicenseException {
        boolean option = false;
        String[] opts = StringUtility.split((String)featureOption, (String)",");
        if (opts.length > 0) {
            try {
                option = Integer.parseInt(opts[0]) > 0;
            }
            catch (NumberFormatException ne) {
                LicenseLogger.severe("Invalid option: " + opts[0] + " . Agitation or Generation option is an integer 0 or 1.");
                throw new InvalidLicenseException("Invalid option: " + opts[0] + " . Agitation or Generation option is 0 or 1.");
            }
        }
        return option;
    }

    DomainInfo[] parseDomains(String bigString) throws InvalidLicenseException {
        Integer domainIdx;
        String[] opts = StringUtility.split((String)bigString, (char)';');
        TreeMap<Integer, DomainInfo> domains = new TreeMap<Integer, DomainInfo>();
        for (int i = 0; i < opts.length; ++i) {
            String[] keyval = StringUtility.split((String)opts[i], (char)'=');
            String key = keyval[0];
            String val = keyval[1];
            if (!key.startsWith(ILS_OPTIONS_KEY_AG_PFX)) continue;
            String[] tokens = StringUtility.split((String)key, (char)'-');
            if (tokens.length != 3) {
                throw new InvalidLicenseException("Invalid option: " + key);
            }
            String option = tokens[1];
            domainIdx = new Integer(tokens[2]);
            if (domainIdx < 0 || domainIdx > 100) {
                throw new InvalidLicenseException("Domain index does not fall into range 0 to 100");
            }
            DomainInfo dInfo = (DomainInfo)domains.get(domainIdx);
            if (dInfo == null) {
                dInfo = new DomainInfo(domainIdx);
                domains.put(domainIdx, dInfo);
            }
            dInfo.put(option, val);
        }
        ArrayList<DomainInfo> domainList = new ArrayList<DomainInfo>();
        Collection values = domains.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            DomainInfo serverDomain = (DomainInfo)iter.next();
            if (serverDomain != null && serverDomain.get(ILS_OPTIONS_KEY_NAME) == null) {
                throw new InvalidLicenseException("Domain has no name " + serverDomain.toString());
            }
            String clientName = serverDomain.getProperty(ILS_OPTIONS_KEY_NAME);
            String serverName = "SERVER-" + clientName;
            serverDomain.setProperty(ILS_OPTIONS_KEY_NAME, serverName);
            serverDomain.setProperty(ILS_OPTIONS_KEY_OPTIONS, this.options);
            domainIdx = new Integer(domains.size());
            DomainInfo clientDomain = new DomainInfo(domainIdx);
            clientDomain.setProperty(ILS_OPTIONS_KEY_NAME, clientName);
            clientDomain.setProperty(ILS_OPTIONS_KEY_OPTIONS, this.options);
            domainList.add(clientDomain);
            domainList.add(serverDomain);
        }
        return domainList.toArray(new DomainInfo[0]);
    }

    static {
        $assertionsDisabled = !LicenserKeyParser.class.desiredAssertionStatus();
    }

    public static class DomainInfo
    extends Properties
    implements Comparable {
        Integer idx;

        public DomainInfo(Integer idx) {
            this.idx = idx;
        }

        public int compareTo(Object o) {
            DomainInfo target = (DomainInfo)o;
            return this.idx.compareTo(target.idx);
        }
    }
}

