/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.license.admin;

import com.agitar.common.util.XmlWriter;
import com.agitar.license.admin.LicenserKeyParser;
import com.agitar.licensechecker.InvalidLicenseException;
import java.io.File;
import java.io.IOException;

public class LicenserIlsAdmXmlWriter {
    private File file;

    public LicenserIlsAdmXmlWriter(File file) throws InvalidLicenseException {
        this.file = file;
    }

    public void toXml(LicenserKeyParser parser) throws IOException {
        XmlWriter xml = new XmlWriter(this.file);
        xml.startElement("ilsdata");
        xml.startElement("product");
        xml.writeAttribute("name", parser.getProductName());
        xml.writeAttribute("title", parser.getProductName());
        xml.writeAttribute("key", parser.getLicenseKey());
        LicenserKeyParser.DomainInfo[] domains = parser.getDomains();
        for (int i = 0; i < domains.length; ++i) {
            LicenserKeyParser.DomainInfo domain = domains[i];
            xml.startElement("domain");
            this.writeProperty(xml, domain, "name");
            this.writeProperty(xml, domain, "quota");
            this.writeProperty(xml, domain, "options");
            xml.writeAttribute("model", "NUSER");
            xml.endElement("domain");
        }
        this.writeAdminPassword(xml);
        xml.endElement("product");
        xml.endElement("ilsdata");
        xml.close();
    }

    private void writeAdminPassword(XmlWriter xml) throws IOException {
        xml.startElement("domain");
        xml.writeAttribute("name", "system");
        xml.writeAttribute("model", "IUSER");
        xml.writeAttribute("auth-level", "4");
        xml.startElement("user");
        xml.writeAttribute("name", "admin");
        xml.writeAttribute("passwd", "agoneq406admin");
        xml.endElement("user");
        xml.endElement("domain");
    }

    private void writeProperty(XmlWriter xml, LicenserKeyParser.DomainInfo domain, String key) throws IOException {
        String value = domain.getProperty(key);
        if (value != null) {
            xml.writeAttribute(key, value);
        }
    }
}

