/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.license.admin;

import com.agitar.license.admin.AdminApplicationInfo;
import com.agitar.license.admin.AdminLicenseChecker;
import com.agitar.license.admin.LicenseDomain;
import com.agitar.license.admin.LicenseProduct;
import com.agitar.licensechecker.InvalidLicenseException;
import com.agitar.licensechecker.Licenser;
import com.vs.ils.admin.IlsAdminPublicAPI;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.Product;
import com.vs.ils.ilsdb.User;
import com.vs.wdo.rtl.WdoBaseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LicenserAdmin {
    AdminLicenseChecker licensechecker;
    AdminApplicationInfo info;

    public LicenserAdmin(AdminLicenseChecker ss) {
        this.licensechecker = ss;
    }

    public void startSession() throws InvalidLicenseException {
        this.startSession("system", "system", "sysadmin", "agoneq406sysadmin");
    }

    public void endSession() throws InvalidLicenseException {
        if (this.info != null) {
            this.licensechecker.checkin(this.info);
        }
    }

    void startSession(String product, String domain, String userName, String userPassword) throws InvalidLicenseException {
        this.info = this.licensechecker.checkLicense(product, domain, userName, userPassword);
    }

    public void updateDomain(String productName, LicenseDomain newDomain) throws InvalidLicenseException {
        IlsAdminPublicAPI.Result res = this.addOrUpdateDomain(true, true, false, productName, newDomain.getName(), false, -1L, -1L, -1L, -1L, newDomain.getQuotaLimit(), newDomain.getQuotaGrace(), newDomain.getQuotaWarningThreshold(), false, false, -1, -1, -1, newDomain.isEnabled(), newDomain.getOptions(), "", false, false, false);
        if (res.getStatusCode() > 0) {
            throw new InvalidLicenseException("Failed to update domain: " + res.getStatusCode() + ", " + res.getStatusMsg());
        }
    }

    public void updateProduct(LicenseProduct newProduct) throws InvalidLicenseException {
        IlsAdminPublicAPI.Result res = this.addOrUpdateProduct(false, true, false, newProduct.getName(), newProduct.getName(), newProduct.getLicenseKey(), true, "", -1, -1, -1);
        res = this.addOrUpdateProduct(false, true, true, newProduct.getName(), newProduct.getName(), newProduct.getLicenseKey(), true, "", -1, -1, -1);
        if (res.getStatusCode() > 0) {
            throw new InvalidLicenseException("Failed to update product: " + res.getStatusCode() + ", " + res.getStatusMsg());
        }
    }

    IlsAdminPublicAPI.Result addOrUpdateProduct(boolean doAudit, boolean updateIfExists, boolean requireExistence, String name, String title, String licenseKey, boolean enabled, String notes, int propExpiration, int propQuota, int propOptions) throws InvalidLicenseException {
        Licenser ils = this.licensechecker.getLicenser(this.info);
        if (ils == null) {
            throw new InvalidLicenseException("Licenser admin session has not been started.  Call startSession.");
        }
        return IlsAdminPublicAPI.addOrUpdateProduct((String)"default", (String)ils.getAuthToken(), (boolean)doAudit, (boolean)updateIfExists, (boolean)requireExistence, (String)name, (String)title, (String)licenseKey, (boolean)enabled, (String)notes, (int)propExpiration, (int)propQuota, (int)propOptions);
    }

    IlsAdminPublicAPI.Result addOrUpdateDomain(boolean doAudit, boolean updateIfExists, boolean requireExistence, String productName, String name, boolean isNamedUser, long userLimit, long minDuration, long maxDuration, long startUseCount, long quotaLimit, long quotaGrace, long quotaWarningThreshold, boolean isTimeLimited, boolean timeLimitIsAbsolute, int timeLimitExpireDays, int timeLimitExpireGrace, int timeLimitExpireWarningThreshold, boolean enabled, String options, String notes, boolean propExpiration, boolean propQuota, boolean propOptions) throws InvalidLicenseException {
        Licenser ils = this.licensechecker.getLicenser(this.info);
        if (ils == null) {
            throw new InvalidLicenseException("Licenser admin session has not been started.  Call startSession.");
        }
        return IlsAdminPublicAPI.addOrUpdateDomain((String)"default", (String)ils.getAuthToken(), (boolean)doAudit, (boolean)updateIfExists, (boolean)requireExistence, (String)productName, (String)name, (boolean)isNamedUser, (long)userLimit, (long)minDuration, (long)maxDuration, (long)startUseCount, (long)quotaLimit, (long)quotaGrace, (long)quotaWarningThreshold, (boolean)isTimeLimited, (boolean)timeLimitIsAbsolute, (int)timeLimitExpireDays, (int)timeLimitExpireGrace, (int)timeLimitExpireWarningThreshold, (boolean)enabled, (String)options, (String)notes, (boolean)propExpiration, (boolean)propQuota, (boolean)propOptions);
    }

    public List getDomainsInProduct(String productName) throws InvalidLicenseException {
        ArrayList<LicenseDomain> domains = new ArrayList<LicenseDomain>();
        IlsAdminPublicAPI.Result res = this.findProduct(false, productName);
        Product product = (Product)res.getResultData();
        try {
            Vector vec = product.getDomainListScrollByName(10, "%", "%", "%", "NUSER");
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                Domain element = (Domain)iter.next();
                LicenseDomain domain = LicenseDomain.createFromIls(element);
                domains.add(domain);
            }
        }
        catch (WdoBaseException e) {
            throw new InvalidLicenseException("Can't get domains from product " + productName, (Exception)((Object)e));
        }
        return domains;
    }

    public List getDomainsInProductForServerDisplay(String productName) throws InvalidLicenseException {
        List domains = this.getDomainsInProduct(productName);
        ArrayList<LicenseDomain> results = new ArrayList<LicenseDomain>();
        Iterator iter = domains.iterator();
        while (iter.hasNext()) {
            LicenseDomain domain = (LicenseDomain)iter.next();
            if (domain.getName().equals("default-nuser") || !domain.getName().startsWith("SERVER-")) continue;
            domain.setName(domain.getName().substring(7));
            results.add(domain);
        }
        return results;
    }

    public List getDomainsInProductForServer(String productName) throws InvalidLicenseException {
        List domains = this.getDomainsInProduct(productName);
        ArrayList<LicenseDomain> results = new ArrayList<LicenseDomain>();
        Iterator iter = domains.iterator();
        while (iter.hasNext()) {
            LicenseDomain domain = (LicenseDomain)iter.next();
            if (domain.getName().equals("default-nuser") || !domain.getName().startsWith("SERVER-")) continue;
            results.add(domain);
        }
        return results;
    }

    public LicenseProduct getProduct(String name) throws InvalidLicenseException {
        IlsAdminPublicAPI.Result res = this.findProduct(false, name);
        Product product = (Product)res.getResultData();
        if (res.getStatusCode() > 0) {
            throw new InvalidLicenseException("failed ot find product.  error: " + res.getStatusCode());
        }
        try {
            if (product == null) {
                return null;
            }
            return LicenseProduct.createFromIls(product);
        }
        catch (WdoBaseException e) {
            throw new InvalidLicenseException("Can't get  product " + name, (Exception)((Object)e));
        }
    }

    public LicenseDomain getDomain(String productName, String domainName) throws InvalidLicenseException {
        IlsAdminPublicAPI.Result res = this.findDomain(false, productName, domainName);
        Domain domain = (Domain)res.getResultData();
        if (res.getStatusCode() > 0) {
            throw new InvalidLicenseException("Failed to find domain: " + res.getStatusCode() + ", " + res.getStatusMsg());
        }
        try {
            if (domain == null) {
                return null;
            }
            return LicenseDomain.createFromIls(domain);
        }
        catch (WdoBaseException e) {
            throw new InvalidLicenseException("Can't get  domain " + domainName, (Exception)((Object)e));
        }
    }

    private IlsAdminPublicAPI.Result findProduct(boolean doAudit, String name) throws InvalidLicenseException {
        Licenser ils = this.licensechecker.getLicenser(this.info);
        if (ils == null) {
            throw new InvalidLicenseException("Licenser admin session has not been started.  Call startSession.");
        }
        return IlsAdminPublicAPI.findProduct((String)"default", (String)ils.getAuthToken(), (boolean)doAudit, (String)name);
    }

    private IlsAdminPublicAPI.Result findDomain(boolean doAudit, String productName, String domainName) throws InvalidLicenseException {
        Licenser ils = this.licensechecker.getLicenser(this.info);
        if (ils == null) {
            throw new InvalidLicenseException("Licenser admin session has not been started.  Call startSession.");
        }
        return IlsAdminPublicAPI.findDomain((String)"default", (String)ils.getAuthToken(), (boolean)doAudit, (String)productName, (String)domainName);
    }

    public void updateUser(String productName, String domainName, String name, String passwd) throws InvalidLicenseException {
        Licenser ils = this.licensechecker.getLicenser(this.info);
        if (ils == null) {
            throw new InvalidLicenseException("Licenser admin session has not been started.  Call startSession.");
        }
        IlsAdminPublicAPI.Result res = IlsAdminPublicAPI.addOrUpdateUser((String)"default", (String)ils.getAuthToken(), (boolean)false, (boolean)true, (boolean)true, (String)productName, (String)domainName, (String)name, (String)passwd, null, null, (boolean)false, (long)-1L, (long)-1L, (long)-1L, (long)-1L, (boolean)true, (boolean)true, (int)-1, (int)-1, (int)-1, (boolean)true, null, null);
        if (res.getStatusCode() > 0) {
            throw new InvalidLicenseException("Failed to delete product: " + res.getStatusCode() + ", " + res.getStatusMsg());
        }
    }

    User findUser(String productName, String domainName, String userName) throws InvalidLicenseException {
        Licenser ils = this.licensechecker.getLicenser(this.info);
        if (ils == null) {
            throw new InvalidLicenseException("Licenser admin session has not been started.  Call startSession.");
        }
        IlsAdminPublicAPI.Result res = IlsAdminPublicAPI.findUser((String)"default", (String)ils.getAuthToken(), (boolean)false, (String)productName, (String)domainName, (String)userName);
        if (res.getStatusCode() > 0) {
            throw new InvalidLicenseException("Failed to delete product: " + res.getStatusCode() + ", " + res.getStatusMsg());
        }
        return (User)res.getResultData();
    }

    void deleteProduct(String productName) throws InvalidLicenseException {
        Licenser ils = this.licensechecker.getLicenser(this.info);
        if (ils == null) {
            throw new InvalidLicenseException("Licenser admin session has not been started.  Call startSession.");
        }
        IlsAdminPublicAPI.Result res = IlsAdminPublicAPI.dropMatchingProducts((String)"default", (String)ils.getAuthToken(), (boolean)false, (String)productName);
        if (res.getStatusCode() > 0) {
            throw new InvalidLicenseException("Failed to delete product: " + res.getStatusCode() + ", " + res.getStatusMsg());
        }
    }

    public void deleteDomain(String productName, String domainName) throws InvalidLicenseException {
        Licenser ils = this.licensechecker.getLicenser(this.info);
        if (ils == null) {
            throw new InvalidLicenseException("Licenser admin session has not been started.  Call startSession.");
        }
        IlsAdminPublicAPI.Result res = IlsAdminPublicAPI.dropMatchingDomains((String)"default", (String)ils.getAuthToken(), (boolean)false, (String)productName, (String)domainName);
        if (res.getStatusCode() > 0) {
            throw new InvalidLicenseException("Failed to delete domain: " + res.getStatusCode() + ", " + res.getStatusMsg());
        }
    }
}

