/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.license.admin;

import com.agitar.license.admin.AdminLicenseChecker;
import com.agitar.license.admin.LicenseDomain;
import com.agitar.license.admin.LicenseProduct;
import com.agitar.license.admin.LicenserAdmin;
import com.agitar.license.admin.LicenserKeyParser;
import com.agitar.licensechecker.InvalidLicenseException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class LicenseInstaller {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installOrUpdate(String xmlKey) throws IOException, InterruptedException, InvalidLicenseException {
        LicenserKeyParser key = new LicenserKeyParser(xmlKey);
        LicenserAdmin admin = new LicenserAdmin(new AdminLicenseChecker());
        try {
            admin.startSession();
            LicenseProduct product = this.convertKeyToLicenseProduct(key);
            admin.updateProduct(product);
            admin.updateUser("AgitarOne", "system", "admin", "agoneq406admin");
            LicenserKeyParser.DomainInfo[] domains = key.getDomains();
            for (int i = 0; i < domains.length; ++i) {
                LicenseDomain domain = this.convertKeyToLicenseDomain(domains[i]);
                admin.updateDomain(key.getProductName(), domain);
            }
            List existing = admin.getDomainsInProduct(key.getProductName());
            Iterator iter = existing.iterator();
            while (iter.hasNext()) {
                LicenseDomain curr = (LicenseDomain)iter.next();
                boolean delete = true;
                if (curr.getName().startsWith("default")) {
                    delete = false;
                } else {
                    for (int i = 0; i < domains.length; ++i) {
                        if (!curr.getName().equals(domains[i].getProperty("name"))) continue;
                        delete = false;
                        break;
                    }
                }
                if (!delete) continue;
                admin.deleteDomain(key.getProductName(), curr.getName());
            }
        }
        finally {
            admin.endSession();
        }
    }

    private LicenseDomain convertKeyToLicenseDomain(LicenserKeyParser.DomainInfo info) {
        LicenseDomain domain = new LicenseDomain();
        domain.setEnabled(true);
        domain.setName(info.getProperty("name"));
        String quotaStr = info.getProperty("quota");
        if (quotaStr != null) {
            domain.setQuotaLimit(new Long(quotaStr));
        }
        return domain;
    }

    private LicenseProduct convertKeyToLicenseProduct(LicenserKeyParser key2) {
        LicenseProduct product = new LicenseProduct();
        product.setLicenseKey(key2.getLicenseKey());
        product.setName(key2.getProductName());
        product.setTitle(key2.getProductName());
        return product;
    }
}

