/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.license.admin;

import com.agitar.license.admin.AdminApplicationInfo;
import com.agitar.licensechecker.ApplicationInfo;
import com.agitar.licensechecker.IlsLicenserFactory;
import com.agitar.licensechecker.InvalidLicenseException;
import com.agitar.licensechecker.LicenseLogger;
import com.agitar.licensechecker.Licenser;
import com.agitar.licensechecker.LicenserFactory;
import com.agitar.licensechecker.OnlineLicenseChecker;
import com.agitar.licensechecker.OnlineLicenseServerUrl;
import com.agitar.licensechecker.ProxyInfo;
import java.net.MalformedURLException;
import java.net.SocketException;

public class AdminLicenseChecker
extends OnlineLicenseChecker {
    String serverUrlStr = "inprocess:";

    public AdminLicenseChecker() {
        this("");
    }

    public AdminLicenseChecker(String serverUrl) {
        this(new IlsLicenserFactory(), serverUrl);
    }

    protected AdminLicenseChecker(LicenserFactory licenserGenerator, String url) {
        if (licenserGenerator == null) {
            throw new IllegalArgumentException("licenserfactory cannot be null");
        }
        this.machineName = null;
        this.licenserFactory = licenserGenerator;
        try {
            this.serverUrl = new OnlineLicenseServerUrl(url);
            this.serverUrlStr = this.serverUrl.getUrl();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public AdminApplicationInfo checkLicense(String productName, String domainName, String userName, String userPassword) throws InvalidLicenseException {
        AdminApplicationInfo info = (AdminApplicationInfo)AdminApplicationInfo.getNewInfo(productName, domainName, userName, userPassword);
        try {
            this.checkout(info, false);
        }
        catch (Throwable x) {
            throw new InvalidLicenseException(x.getMessage());
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void checkout(ApplicationInfo info, boolean fingerChanged) throws InvalidLicenseException, SocketException {
        if (!info.isValid()) {
            throw new IllegalArgumentException("cannot checkout on invalid info");
        }
        Licenser licenser = this.getLicenser(info);
        ProxyInfo pInfo = this.enableProxyIfNeeded();
        try {
            boolean checkoutSuccess;
            LicenseLogger.fine("checking out with " + info.toString() + ")");
            try {
                checkoutSuccess = this.timedCheckout(licenser, 300L);
            }
            catch (InterruptedException e) {
                throw new SocketException("Network timeout while checking license.");
            }
            if (!checkoutSuccess && licenser.getStatus() == 29) {
                this.handleFailedCheckout(licenser, pInfo);
            }
            if (!checkoutSuccess) {
                this.handleFailedCheckout(licenser, pInfo);
            } else {
                ((AdminApplicationInfo)info).setAuthToken(licenser.getAuthToken());
            }
        }
        finally {
            if (pInfo.isValid()) {
                pInfo.unsetProxy();
            }
        }
    }

    public Licenser getLicenser(ApplicationInfo info) {
        if (info == null || !info.isValid()) {
            throw new IllegalArgumentException("admin licenser info cannot be null or invalid");
        }
        Licenser licenser = (Licenser)this.infoToLicenser.get(info);
        if (licenser == null) {
            AdminApplicationInfo ainfo = (AdminApplicationInfo)info;
            licenser = this.getLicenser(ainfo.getCustomerId(), ainfo.getUserName(), ainfo.getSessionId(), ainfo.getProductName(), ainfo.getUserPassword(), null);
            this.infoToLicenser.put(info, licenser);
        }
        return licenser;
    }

    protected Licenser getLicenser(String customerId, String productKey, long sessionId, String product, String productPwd, String publicKey) {
        return this.licenserFactory.getLicenser(this.serverUrlStr, null, customerId, productKey, true, sessionId, product, productPwd, publicKey);
    }
}

