/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.license.admin;

import com.agitar.licensechecker.ApplicationInfo;
import com.agitar.licensechecker.InvalidLicenseException;
import com.agitar.licensechecker.LicenseLogger;
import java.io.InputStream;

public class AdminApplicationInfo
extends ApplicationInfo {
    String productName;
    String userName;
    String userPassword;
    String authToken;

    protected AdminApplicationInfo(String productName, String domainName, String userName, String userPassword) throws InvalidLicenseException {
        this.checkNotNullOrEmpty(productName, false, "Product Name");
        this.checkNotNullOrEmpty(userName, false, "User Name");
        this.checkNotNullOrEmpty(userPassword, false, "User Password");
        this.productName = productName;
        this.customerId = domainName;
        this.userName = userName;
        this.userPassword = userPassword;
        this.sessionId = this.makeSessionId();
        this.duration = 0L;
        LicenseLogger.fine("Admin application info created from code: " + this.toString());
    }

    protected Long makeSessionId() {
        return new Long(System.currentTimeMillis());
    }

    public static ApplicationInfo getSavedInfo() throws InvalidLicenseException {
        throw new UnsupportedOperationException("Unsupported in ApplicationInfoOnServer");
    }

    static ApplicationInfo getNewInfo(String customerId, String productKey, String emailAddress, boolean floating, String basePreferenceNode, boolean machineSpecific) throws InvalidLicenseException {
        throw new UnsupportedOperationException("Unsupported in ApplicationInfoOnServer");
    }

    public static ApplicationInfo getNewInfo(String productName, String domainName, String userName, String userPassword) throws InvalidLicenseException {
        return new AdminApplicationInfo(productName, domainName, userName, userPassword);
    }

    static ApplicationInfo getSavedInfo(String basePreferenceNode) throws InvalidLicenseException {
        throw new UnsupportedOperationException("Unsupported in ApplicationInfoOnServer");
    }

    static ApplicationInfo getSavedInfo(String basePreferenceNode, boolean machineSpecific) throws InvalidLicenseException {
        throw new UnsupportedOperationException("Unsupported in ApplicationInfoOnServer");
    }

    public void save() {
        throw new UnsupportedOperationException("Unsupported in ApplicationInfoOnServer");
    }

    public void deleteInfo() throws InvalidLicenseException {
        throw new UnsupportedOperationException("Unsupported in ApplicationInfoOnServer");
    }

    public String toString() {
        return "productName[" + this.productName + "], domainName[" + this.customerId + "], userName[" + this.userName + "]";
    }

    public boolean equals(ApplicationInfo toCompare) {
        return this.nullFriendlyEquals(this.emailAddress, toCompare.getEmailAddress()) && this.nullFriendlyEquals(this.customerId, toCompare.getCustomerId()) && this.floating == toCompare.isFloating() && this.getSessionId() == toCompare.getSessionId();
    }

    public static ApplicationInfo commandLineInput() {
        throw new UnsupportedOperationException("Unsupported in ApplicationInfoOnServer");
    }

    static ApplicationInfo commandLineInput(InputStream commandLineInput) {
        throw new UnsupportedOperationException("Unsupported in ApplicationInfoOnServer");
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public boolean isValid() {
        return this.productName != null;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }
}

