/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.license;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.IOUtility;
import com.agitar.common.util.StringUtility;
import com.agitar.license.AgitarLicense;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;

public abstract class LicenseIO {
    public static final String AGITAR_LICENSE_FILE = "com.agitar.license";
    private static String KEY_NAME = "/key.bin";
    private static final int LOOP = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecretKey getKey() throws IOException, ClassNotFoundException {
        SecretKey secretKey;
        ObjectInputStream ois = null;
        try {
            SecretKey key;
            ois = new ObjectInputStream(LicenseIO.class.getResourceAsStream(KEY_NAME));
            secretKey = key = (SecretKey)ois.readObject();
        }
        catch (Throwable throwable) {
            IOUtility.close(ois, (boolean)true);
            throw throwable;
        }
        IOUtility.close((InputStream)ois, (boolean)true);
        return secretKey;
    }

    public static void main(String[] args) throws Throwable {
        File file = new File("/tmp/com.agitar.license");
        long start = System.currentTimeMillis();
        AgitarLicense license = LicenseIO.read(new FileInputStream(file));
        System.out.println(System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            license.addUser();
            LicenseIO.write(license, new BufferedOutputStream(new FileOutputStream(file)));
        }
        System.out.println(System.currentTimeMillis() - start);
    }

    public static AgitarLicense read(InputStream inputStream) throws Throwable {
        AgitarLicense agitarLicense;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(inputStream));
            SealedObject so = (SealedObject)ois.readObject();
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, LicenseIO.getKey());
            agitarLicense = (AgitarLicense)so.getObject(cipher);
        }
        catch (Throwable exc) {
            try {
                AgitarLogger.getDiagnosticLogger().severe("Can't read license." + StringUtility.nl + StringUtility.trace((Throwable)exc));
                throw exc;
            }
            catch (Throwable throwable) {
                IOUtility.close(ois, (boolean)true);
                throw throwable;
            }
        }
        IOUtility.close((InputStream)ois, (boolean)true);
        return agitarLicense;
    }

    public static void write(AgitarLicense license, OutputStream os) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, LicenseIO.getKey());
        SealedObject so = new SealedObject((Serializable)((Object)license), cipher);
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(os));
        oos.writeObject(so);
        oos.close();
    }

    private LicenseIO() {
    }
}

