/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.license;

import com.agitar.common.util.StringUtility;
import com.agitar.lib.NoObfuscation;
import com.agitar.license.AgitarLicense;
import java.io.Serializable;

public class AgitarLicenseImpl
implements AgitarLicense,
Serializable,
NoObfuscation {
    private static final long serialVersionUID = 607500L;
    private final String version = "1.0";
    private final int classLimit;
    int classUsed;
    private final boolean isAgitationEnabled;
    private final boolean isClientSideEnabled;
    private final boolean isTestGenerationEnabled;
    int numberOfUsers;
    private final String serverDomainName;
    private final long timeLimit;
    private final int userLimit;
    private final String companyName;
    private final String projectName;
    static final /* synthetic */ boolean $assertionsDisabled;

    private AgitarLicenseImpl(String companyName, String projectName, String serverDomainName, int classLimit, int userLimit, long timeLimit, boolean isAgitationEnabled, boolean isClientSideEnabled, boolean isTestGenerationEnabled) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty((String)serverDomainName)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && StringUtility.nullOrEmpty((String)companyName)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && StringUtility.nullOrEmpty((String)projectName)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && classLimit <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && userLimit <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && timeLimit <= 0L) {
            throw new AssertionError();
        }
        this.companyName = companyName;
        this.projectName = projectName;
        this.classLimit = classLimit;
        this.userLimit = userLimit;
        this.timeLimit = timeLimit;
        this.serverDomainName = serverDomainName;
        this.isAgitationEnabled = isAgitationEnabled;
        this.isTestGenerationEnabled = isTestGenerationEnabled;
        this.isClientSideEnabled = isClientSideEnabled;
    }

    public synchronized void addClassUsed() {
        ++this.classUsed;
    }

    public synchronized void addUser() {
        ++this.numberOfUsers;
    }

    public int getClassesUsed() {
        return this.classUsed;
    }

    public int getClassLimit() {
        return this.classLimit;
    }

    public int getDaysLeft() {
        return (int)((this.getTimeLimit() - System.currentTimeMillis()) / 86400L);
    }

    public int getNumberOfUsers() {
        return this.numberOfUsers;
    }

    public String getServerDomainName() {
        return this.serverDomainName;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public int getUserLimit() {
        return this.userLimit;
    }

    public boolean isAgitationEnabled() {
        return this.isAgitationEnabled;
    }

    public boolean isClientSideEnabled() {
        return this.isClientSideEnabled;
    }

    public boolean isTestGenerationEnabled() {
        return this.isTestGenerationEnabled;
    }

    public synchronized void removeUser() {
        --this.numberOfUsers;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    static {
        $assertionsDisabled = !AgitarLicenseImpl.class.desiredAssertionStatus();
    }
}

