/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.mockejb.jms.MockProducer;
import org.mockejb.jms.MockTopic;

class TopicPublisherImpl
extends MockProducer
implements TopicPublisher {
    public TopicPublisherImpl(MockTopic topic) {
        super(topic);
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    public void publish(Message msg) throws JMSException {
        this.send(msg);
    }

    public void publish(Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(msg, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message msg) throws JMSException {
        this.publish(topic, msg, this.getDeliveryMode(), this.getPriority(), 0L);
    }

    public void publish(Topic topic, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination(true);
        if (topic instanceof MockTopic) {
            MockProducer.sendMessage((MockTopic)topic, msg, deliveryMode, priority, timeToLive);
        }
        throw new InvalidDestinationException("Invalid topic specified!");
    }
}

