/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.mockejb.BMPFinderHandler;
import org.mockejb.CMPFindByPrimaryKeyHandler;
import org.mockejb.EjbExceptionHandler;
import org.mockejb.EntityBeanDescriptor;
import org.mockejb.EntityBeanHome;
import org.mockejb.EntityDatabase;
import org.mockejb.EntityDatabaseImpl;
import org.mockejb.MDBDescriptor;
import org.mockejb.MDBHome;
import org.mockejb.MDBHomeIface;
import org.mockejb.MockEjbObject;
import org.mockejb.MockEjbSystemException;
import org.mockejb.MockUser;
import org.mockejb.SessionBeanDescriptor;
import org.mockejb.SessionBeanHome;
import org.mockejb.interceptor.AspectSystem;
import org.mockejb.interceptor.AspectSystemFactory;
import org.mockejb.jms.MockQueue;
import org.mockejb.jms.MockTopic;
import org.mockejb.jms.QueueConnectionFactoryImpl;
import org.mockejb.jms.TopicConnectionFactoryImpl;

public class MockContainer {
    private Context context;
    private EntityDatabase entityDatabase;
    private static ThreadLocal threadContext = new ThreadLocal();

    public static MockUser getUser() {
        MockUser user = (MockUser)threadContext.get();
        if (user == null) {
            user = MockUser.ANONYMOUS_USER;
        }
        return user;
    }

    public void login(MockUser user) {
        threadContext.set(user);
    }

    public MockContainer(Context context) {
        this.context = context;
        threadContext.set(MockUser.ANONYMOUS_USER);
        this.setupDefaultInterceptors();
    }

    protected void setupDefaultInterceptors() {
        this.loadEntityDatabase();
        AspectSystem aspectSystem = AspectSystemFactory.getAspectSystem();
        aspectSystem.clear();
        aspectSystem.addFirst(new BMPFinderHandler(this.entityDatabase));
        aspectSystem.addFirst(new CMPFindByPrimaryKeyHandler(this.entityDatabase));
        aspectSystem.addFirst(new EjbExceptionHandler());
    }

    public void deploy(SessionBeanDescriptor descriptor) throws NamingException {
        SessionBeanHome home = new SessionBeanHome(descriptor);
        this.context.rebind(descriptor.getJndiName(), home.createProxy());
    }

    public void deploy(EntityBeanDescriptor descriptor) throws NamingException {
        EntityBeanHome home = new EntityBeanHome(descriptor, this.entityDatabase);
        this.context.rebind(descriptor.getJndiName(), home.createProxy());
    }

    public void deploy(MDBDescriptor descriptor) throws NamingException, JMSException {
        TopicSubscriber consumer;
        TopicConnection connection;
        if (descriptor.isTopic()) {
            TopicConnection topicConnection;
            TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.createJMSObject(descriptor.getConnectionFactoryJndiName(), descriptor.isAlreadyBound(), new TopicConnectionFactoryImpl());
            Topic topic = (Topic)this.createJMSObject(descriptor.getDestinationJndiName(), descriptor.isAlreadyBound(), new MockTopic(descriptor.getDestinationJndiName()));
            connection = topicConnection = topicConnectionFactory.createTopicConnection();
            TopicSession topicSession = topicConnection.createTopicSession(false, 1);
            consumer = topicSession.createSubscriber(topic);
        } else {
            QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)this.createJMSObject(descriptor.getConnectionFactoryJndiName(), descriptor.isAlreadyBound(), new QueueConnectionFactoryImpl());
            Queue queue = (Queue)this.createJMSObject(descriptor.getDestinationJndiName(), descriptor.isAlreadyBound(), new MockQueue(descriptor.getDestinationJndiName()));
            QueueConnection queueConnection = queueConnectionFactory.createQueueConnection();
            connection = queueConnection;
            QueueSession queueSession = queueConnection.createQueueSession(false, 1);
            consumer = queueSession.createReceiver(queue);
        }
        MDBHome home = new MDBHome(descriptor);
        MDBHomeIface mdbHome = (MDBHomeIface)home.createProxy();
        MessageListener messageListener = mdbHome.create();
        consumer.setMessageListener(messageListener);
        connection.start();
    }

    public EntityDatabase getEntityDatabase() {
        return this.entityDatabase;
    }

    private Object createJMSObject(String jndiName, boolean isAlreadyBound, Object defaultImpl) throws NamingException {
        Object obj = defaultImpl;
        if (isAlreadyBound) {
            obj = this.context.lookup(jndiName);
        } else {
            this.context.rebind(jndiName, defaultImpl);
        }
        return obj;
    }

    public MessageListener createMessageBean(MockEjbObject ejbObject) {
        MDBHomeIface home = (MDBHomeIface)ejbObject.getHomeImpl();
        return home.create();
    }

    public static boolean isSystemException(Throwable throwable) {
        return throwable instanceof RuntimeException || throwable instanceof RemoteException || throwable instanceof SystemException || throwable instanceof NotSupportedException || throwable instanceof InvalidTransactionException || throwable instanceof InvocationTargetException;
    }

    protected void loadEntityDatabase() {
        String entityDatabaseClassName = System.getProperty("mockejb.entity.database");
        if (entityDatabaseClassName != null) {
            try {
                Class<?> entityDatabaseClass = Class.forName(entityDatabaseClassName, true, this.getClass().getClassLoader());
                this.entityDatabase = (EntityDatabase)entityDatabaseClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new MockEjbSystemException(cnfe);
            }
            catch (InstantiationException ie) {
                throw new MockEjbSystemException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new MockEjbSystemException(iae);
            }
        } else {
            this.entityDatabase = new EntityDatabaseImpl();
        }
    }
}

