/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.api;

import com.agitar.eclipse.api.runner.IRunner;
import com.agitar.eclipse.core.AgUIException;
import com.agitar.eclipse.core.util.JavaElementUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class APIPlugin
extends AbstractUIPlugin {
    public static final String RUNNER_EXTENSION_POINT = "runner";
    public static final String JUNIT_HOME = "JUNIT_HOME";
    public static final String JUNIT3_TESTCASE = "junit.framework.TestCase";
    public static final String PLUGIN_ID = "com.agitar.eclipse.api";
    private static APIPlugin plugin;

    public static APIPlugin getDefault() {
        if (plugin == null) {
            plugin = new APIPlugin();
        }
        return plugin;
    }

    private APIPlugin() {
    }

    public static void addAgitarTestLib(IJavaProject project) throws Exception {
        boolean needsJUnit = true;
        try {
            if (project.findType(JUNIT3_TESTCASE) != null) {
                needsJUnit = false;
            }
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        if (needsJUnit) {
            APIPlugin.addJUnitToBuildPath(project, JUNIT_HOME);
        }
        Path agitatorLibVar = new Path("AGITAR_TEST_LIB");
        IClasspathEntry entry1 = JavaCore.newVariableEntry((IPath)agitatorLibVar, null, null);
        APIPlugin.setOrgAgitarMockVariable(project);
        if (JavaCore.getClasspathVariable((String)"AGITAR_TEST_LIB") != null) {
            JavaElementUtils.addToClasspath((IJavaProject)project, (IClasspathEntry)entry1);
        }
    }

    private static void setOrgAgitarMockVariable(IJavaProject project) throws JavaModelException, InvocationTargetException, InterruptedException {
        if (APIPlugin.isJavaEE5Compatible(project)) {
            APIPlugin.addVariable(project, "AGITAR_MOCK_OBJECTS5");
            APIPlugin.removeFromClasspath(project, "AGITAR_MOCK_OBJECTS");
        } else {
            APIPlugin.addVariable(project, "AGITAR_MOCK_OBJECTS");
            APIPlugin.removeFromClasspath(project, "AGITAR_MOCK_OBJECTS5");
        }
    }

    private static boolean isJavaEE5Compatible(IJavaProject project) {
        return "1.5".equals(project.getOptions(true).get("org.eclipse.jdt.core.compiler.compliance"));
    }

    private static void addVariable(IJavaProject project, String varName) throws JavaModelException, InvocationTargetException, InterruptedException {
        Path agitarMockObjectsVar = new Path(varName);
        IClasspathEntry entry = JavaCore.newVariableEntry((IPath)agitarMockObjectsVar, null, null);
        if (JavaCore.getClasspathVariable((String)varName) != null) {
            JavaElementUtils.addToClasspath((IJavaProject)project, (IClasspathEntry)entry);
        }
    }

    public static void removeFromClasspath(IJavaProject project, String varName) throws JavaModelException, InvocationTargetException, InterruptedException {
        Path agitarMockObjectsVar = new Path(varName);
        IClasspathEntry varEntry = JavaCore.newVariableEntry((IPath)agitarMockObjectsVar, null, null);
        IClasspathEntry[] oldEntries = project.getRawClasspath();
        ArrayList<IClasspathEntry> oldEntriesList = new ArrayList<IClasspathEntry>();
        for (int i = 0; i < oldEntries.length; ++i) {
            IClasspathEntry entry = oldEntries[i];
            if (entry.equals(varEntry)) continue;
            oldEntriesList.add(entry);
        }
        IClasspathEntry[] newEntries = oldEntriesList.toArray(new IClasspathEntry[0]);
        project.setRawClasspath(newEntries, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void addJUnitToBuildPath(IJavaProject project, String jUnitHome) throws JavaModelException {
        IClasspathEntry entry;
        IProject junitProject = ResourcesPlugin.getWorkspace().getRoot().getProject("org.junit");
        if (junitProject.exists()) {
            entry = JavaCore.newProjectEntry((IPath)junitProject.getFullPath());
        } else {
            Path junitHome = new Path(jUnitHome);
            Path sourceHome = new Path("ECLIPSE_HOME");
            entry = JavaCore.newVariableEntry((IPath)junitHome.append("junit.jar"), (IPath)sourceHome.append("plugins/org.eclipse.jdt.source_3.1.1/src/org.junit_3.8.1/junitsrc.zip"), null);
        }
        APIPlugin.addToClasspath(project, entry);
    }

    private static void addToClasspath(IJavaProject project, IClasspathEntry entry) throws JavaModelException {
        IClasspathEntry[] oldEntries = project.getRawClasspath();
        for (int i = 0; i < oldEntries.length; ++i) {
            if (!oldEntries[i].equals(entry)) continue;
            return;
        }
        int nEntries = oldEntries.length;
        IClasspathEntry[] newEntries = new IClasspathEntry[nEntries + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, nEntries);
        newEntries[nEntries] = entry;
        project.setRawClasspath(newEntries, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IRunner getRunner() throws AgUIException, CoreException {
        return APIPlugin.getRunner(null);
    }

    public static IRunner getRunner(String id) throws AgUIException, CoreException {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, RUNNER_EXTENSION_POINT);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            IConfigurationElement selectedRunner = null;
            int priority = -1;
            for (int i = 0; i < elements.length; ++i) {
                IConfigurationElement element = elements[i];
                if (!element.getName().equals(RUNNER_EXTENSION_POINT)) continue;
                String priorityAttr = element.getAttribute("priority");
                if (id == null) {
                    int value;
                    if (priorityAttr == null) continue;
                    try {
                        value = Integer.parseInt(priorityAttr);
                    }
                    catch (NumberFormatException x) {
                        value = 0;
                    }
                    if (value <= priority) continue;
                    selectedRunner = element;
                    priority = value;
                    continue;
                }
                if (!id.equals(element.getAttribute("id"))) continue;
                selectedRunner = element;
                break;
            }
            if (selectedRunner != null) {
                return (IRunner)selectedRunner.createExecutableExtension("runnerClass");
            }
        }
        throw new AgUIException("Please install the Agitar Test Runner to run these tests.");
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workBench = APIPlugin.getDefault().getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = APIPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }
}

