/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockMessage;
import com.mockrunner.util.common.ArrayUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Stack;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;

public class MockStreamMessage
extends MockMessage
implements StreamMessage {
    private Stack data = new Stack();

    public boolean readBoolean() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object object = this.readObject();
        if (null == object) {
            return Boolean.valueOf(null);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to boolean");
    }

    public byte readByte() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object object = this.readObject();
        if (null == object) {
            return Byte.valueOf(null);
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof String) {
            return Byte.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to byte");
    }

    public short readShort() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object object = this.readObject();
        if (null == object) {
            return Short.valueOf(null);
        }
        if (object instanceof Byte || object instanceof Short) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            return Short.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to short");
    }

    public char readChar() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object object = this.readObject();
        if (null == object) {
            throw new NullPointerException();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to char");
    }

    public int readInt() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object object = this.readObject();
        if (null == object) {
            return Integer.valueOf(null);
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to int");
    }

    public long readLong() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object object = this.readObject();
        if (null == object) {
            return Long.valueOf(null);
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            return Long.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to long");
    }

    public float readFloat() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object object = this.readObject();
        if (null == object) {
            return Float.valueOf(null).floatValue();
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof String) {
            return Float.valueOf((String)object).floatValue();
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to float");
    }

    public double readDouble() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object object = this.readObject();
        if (null == object) {
            return Double.valueOf(null);
        }
        if (object instanceof Float || object instanceof Double) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to double");
    }

    public String readString() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object object = this.readObject();
        if (null == object) {
            return null;
        }
        if (object instanceof byte[]) {
            throw new MessageFormatException(object.getClass().getName() + " cannot be converted to String");
        }
        return object.toString();
    }

    public int readBytes(byte[] byArray) throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        if (null == byArray) {
            return -1;
        }
        if (0 == byArray.length) {
            return 0;
        }
        Object object = this.readObject();
        if (null == object) {
            throw new NullPointerException();
        }
        if (!(object instanceof byte[])) {
            throw new MessageFormatException(object.getClass().getName() + " cannot be converted to byte[]");
        }
        int n = Math.min(byArray.length, ((byte[])object).length);
        System.arraycopy(object, 0, byArray, 0, n);
        return n;
    }

    public Object readObject() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        return this.data.pop();
    }

    public void writeBoolean(boolean bl) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Boolean(bl));
    }

    public void writeByte(byte by) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Byte(by));
    }

    public void writeShort(short s) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Short(s));
    }

    public void writeChar(char c) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Character(c));
    }

    public void writeInt(int n) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Integer(n));
    }

    public void writeLong(long l) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Long(l));
    }

    public void writeFloat(float f) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Float(f));
    }

    public void writeDouble(double d) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Double(d));
    }

    public void writeString(String string) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(string);
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(byArray);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        if (null == byArray) {
            this.writeObject(null);
            return;
        }
        this.writeObject(ArrayUtil.truncateArray(byArray, n, n2));
    }

    public void writeObject(Object object) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        if (null == object) {
            this.data.push(object);
            return;
        }
        if (object instanceof String || object instanceof Number || object instanceof Character || object instanceof Boolean) {
            this.data.push(object);
            return;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])((byte[])object).clone();
            this.data.push(byArray);
            return;
        }
        throw new MessageFormatException(object.getClass() + " not a valid type");
    }

    public void reset() throws JMSException {
        this.setReadOnly(true);
        Collections.reverse(this.data);
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.data = new Stack();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof MockStreamMessage)) {
            return false;
        }
        MockStreamMessage mockStreamMessage = (MockStreamMessage)object;
        if (this.data.size() != mockStreamMessage.data.size()) {
            return false;
        }
        Vector vector = mockStreamMessage.data;
        if (this.isInWriteMode() != mockStreamMessage.isInWriteMode()) {
            vector = new Vector(vector);
            Collections.reverse(vector);
        }
        for (int i = 0; i < this.data.size(); ++i) {
            Object e = this.data.get(i);
            Object e2 = vector.get(i);
            if (null == e) {
                if (null == e2) continue;
                return false;
            }
            if (e instanceof byte[]) {
                if (null == e2) {
                    return false;
                }
                if (!(e2 instanceof byte[])) {
                    return false;
                }
                if (Arrays.equals((byte[])e, (byte[])e2)) continue;
                return false;
            }
            if (e.equals(e2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            Object e = this.data.get(i);
            if (e instanceof byte[]) {
                for (int j = 0; j < ((byte[])e).length; ++j) {
                    n += 31 * ((byte[])e)[j];
                }
                continue;
            }
            if (e == null) continue;
            n += 31 * e.hashCode();
        }
        return n;
    }

    public Object clone() {
        MockStreamMessage mockStreamMessage = (MockStreamMessage)super.clone();
        mockStreamMessage.data = new Stack();
        for (int i = 0; i < this.data.size(); ++i) {
            Object e = this.data.get(i);
            if (e instanceof byte[]) {
                mockStreamMessage.data.add(((byte[])e).clone());
                continue;
            }
            mockStreamMessage.data.add(e);
        }
        return mockStreamMessage;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.data.toString();
    }
}

