/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.jdbc.SQLUtil;
import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockRef;
import com.mockrunner.mock.jdbc.MockResultSetMetaData;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.util.common.CaseAwareMap;
import com.mockrunner.util.common.CollectionUtil;
import com.mockrunner.util.common.StreamUtil;
import com.mockrunner.util.common.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MockResultSet
implements ResultSet,
Cloneable {
    private Statement statement;
    private String id;
    private Map columnMap;
    private Map columnMapCopy;
    private Map insertRow;
    private List columnNameList;
    private List updatedRows;
    private List deletedRows;
    private List insertedRows;
    private int cursor;
    private boolean isCursorInInsertRow;
    private boolean wasNull;
    private String cursorName;
    private int fetchSize = 0;
    private int fetchDirection = 1000;
    private int resultSetType = 1004;
    private int resultSetConcurrency = 1007;
    private boolean isDatabaseView;
    private ResultSetMetaData resultSetMetaData;
    private boolean closed;
    private boolean columnsCaseSensitive;

    public MockResultSet(String string) {
        this(string, "");
    }

    public MockResultSet(String string, String string2) {
        this.init();
        this.cursorName = string2;
        this.id = string;
        this.columnsCaseSensitive = false;
    }

    private void init() {
        this.columnMap = this.createCaseAwareMap();
        this.columnNameList = new ArrayList();
        this.updatedRows = new ArrayList();
        this.deletedRows = new ArrayList();
        this.insertedRows = new ArrayList();
        this.cursor = -1;
        this.wasNull = false;
        this.closed = false;
        this.isCursorInInsertRow = false;
        this.isDatabaseView = false;
        this.resultSetMetaData = null;
        this.copyColumnMap();
        this.adjustInsertRow();
    }

    public void setColumnsCaseSensitive(boolean bl) {
        this.columnsCaseSensitive = bl;
        this.init();
    }

    public Object clone() {
        try {
            MockResultSet mockResultSet = (MockResultSet)super.clone();
            mockResultSet.columnNameList = new ArrayList(this.columnNameList);
            mockResultSet.updatedRows = new ArrayList(this.updatedRows);
            mockResultSet.deletedRows = new ArrayList(this.deletedRows);
            mockResultSet.insertedRows = new ArrayList(this.insertedRows);
            mockResultSet.insertRow = this.copyColumnDataMap(this.insertRow);
            mockResultSet.columnMap = this.copyColumnDataMap(this.columnMap);
            mockResultSet.columnMapCopy = this.copyColumnDataMap(this.columnMapCopy);
            return mockResultSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NestedApplicationException(cloneNotSupportedException);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setResultSetMetaData(ResultSetMetaData resultSetMetaData) {
        this.resultSetMetaData = resultSetMetaData;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
        try {
            this.fetchDirection = statement.getFetchDirection();
            this.resultSetType = statement.getResultSetType();
            this.resultSetConcurrency = statement.getResultSetConcurrency();
            this.fetchSize = statement.getFetchSize();
            this.cursorName = ((MockStatement)statement).getCursorName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setCursorName(String string) {
        this.cursorName = string;
    }

    public void setResultSetType(int n) {
        this.resultSetType = n;
    }

    public void setResultSetConcurrency(int n) {
        this.resultSetConcurrency = n;
    }

    public void setDatabaseView(boolean bl) {
        this.isDatabaseView = bl;
    }

    public void addRow(Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        this.addRow(list);
    }

    public void addRow(List list) {
        int n;
        int n2 = list.size() - this.columnNameList.size();
        for (n = 0; n < n2; ++n) {
            this.addColumn();
        }
        this.adjustColumns();
        for (n = 0; n < list.size(); ++n) {
            Object e = list.get(n);
            String string = (String)this.columnNameList.get(n);
            List list2 = (List)this.columnMap.get(string);
            list2.add(e);
        }
        this.adjustColumns();
        this.copyColumnMap();
        this.adjustFlags();
    }

    public void addColumn() {
        this.addColumn(this.determineValidColumnName());
    }

    public void addColumn(String string) {
        this.addColumn(string, new ArrayList());
    }

    public void addColumn(Object[] objectArray) {
        this.addColumn(this.determineValidColumnName(), objectArray);
    }

    public void addColumn(List list) {
        this.addColumn(this.determineValidColumnName(), list);
    }

    public void addColumn(String string, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        this.addColumn(string, list);
    }

    public void addColumn(String string, List list) {
        ArrayList arrayList = new ArrayList(list);
        this.columnMap.put(string, arrayList);
        this.columnNameList.add(string);
        this.adjustColumns();
        this.adjustInsertRow();
        this.copyColumnMap();
        this.adjustFlags();
    }

    public int getRowCount() {
        if (this.columnMapCopy.size() == 0) {
            return 0;
        }
        List list = (List)this.columnMapCopy.values().iterator().next();
        return list.size();
    }

    public int getColumnCount() {
        return this.columnMapCopy.size();
    }

    public boolean rowInserted(int n) {
        if (n < 1) {
            return false;
        }
        return (Boolean)this.insertedRows.get(n - 1);
    }

    public boolean rowDeleted(int n) {
        if (n < 1) {
            return false;
        }
        return (Boolean)this.deletedRows.get(n - 1);
    }

    public boolean rowUpdated(int n) {
        if (n < 1) {
            return false;
        }
        return (Boolean)this.updatedRows.get(n - 1);
    }

    public boolean isRowEqual(int n, List list) {
        List list2 = this.getRow(n);
        if (null == list2) {
            return false;
        }
        if (list2.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list2.size(); ++i) {
            Object object = list2.get(i);
            Object object2 = list.get(i);
            if (!object.getClass().isAssignableFrom(object2.getClass()) && !object2.getClass().isAssignableFrom(object.getClass())) {
                object = object.toString();
                object2 = object2.toString();
            }
            if (ParameterUtil.compareParameter(object, object2)) continue;
            return false;
        }
        return true;
    }

    public boolean isColumnEqual(int n, List list) {
        List list2 = this.getColumn(n);
        if (null == list2) {
            return false;
        }
        if (list2.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list2.size(); ++i) {
            Object object = list2.get(i);
            Object object2 = list.get(i);
            if (!object.getClass().isAssignableFrom(object2.getClass()) && !object2.getClass().isAssignableFrom(object.getClass())) {
                object = object.toString();
                object2 = object2.toString();
            }
            if (ParameterUtil.compareParameter(object, object2)) continue;
            return false;
        }
        return true;
    }

    public boolean isColumnEqual(String string, List list) {
        List list2 = this.getColumn(string);
        if (null == list2) {
            return false;
        }
        if (list2.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list2.size(); ++i) {
            Object object = list2.get(i);
            Object object2 = list.get(i);
            if (!object.getClass().isAssignableFrom(object2.getClass()) && !object2.getClass().isAssignableFrom(object.getClass())) {
                object = object.toString();
                object2 = object2.toString();
            }
            if (ParameterUtil.compareParameter(object, object2)) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(MockResultSet mockResultSet) {
        if (null == mockResultSet) {
            return false;
        }
        Map map = this.isDatabaseView ? this.columnMap : this.columnMapCopy;
        Map map2 = mockResultSet.isDatabaseView ? mockResultSet.columnMap : mockResultSet.columnMapCopy;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)map.get(string);
            List list2 = (List)map2.get(string);
            if (null == list2) {
                return false;
            }
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                Object object2 = list2.get(i);
                if (!object.getClass().isAssignableFrom(object2.getClass()) && !object2.getClass().isAssignableFrom(object.getClass())) {
                    object = object.toString();
                    object2 = object2.toString();
                }
                if (ParameterUtil.compareParameter(object, object2)) continue;
                return false;
            }
        }
        return true;
    }

    public List getRow(int n) {
        if (n > this.getRowCount()) {
            return null;
        }
        if (n < 1) {
            return null;
        }
        int n2 = n - 1;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.columnNameList.size(); ++i) {
            String string = (String)this.columnNameList.get(i);
            List list = this.isDatabaseView ? (List)this.columnMap.get(string) : (List)this.columnMapCopy.get(string);
            arrayList.add(list.get(n2));
        }
        return arrayList;
    }

    public List getColumn(int n) {
        if (n > this.getColumnCount()) {
            return null;
        }
        if (n < 1) {
            return null;
        }
        int n2 = n - 1;
        String string = (String)this.columnNameList.get(n2);
        return this.getColumn(string);
    }

    public List getColumn(String string) {
        ArrayList arrayList = new ArrayList();
        List list = this.isDatabaseView ? (List)this.columnMap.get(string) : (List)this.columnMapCopy.get(string);
        if (null == list) {
            return null;
        }
        arrayList.addAll(list);
        return arrayList;
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public Object getObject(int n) throws SQLException {
        this.checkColumnBounds(n);
        if (!this.isCurrentRowValid()) {
            this.wasNull = true;
            return null;
        }
        String string = (String)this.columnNameList.get(n - 1);
        return this.getObject(string);
    }

    public Object getObject(String string) throws SQLException {
        this.checkColumnName(string);
        if (!this.isCurrentRowValid()) {
            this.wasNull = true;
            return null;
        }
        if (this.rowDeleted()) {
            throw new SQLException("row was deleted");
        }
        List list = this.isDatabaseView ? (List)this.columnMap.get(string) : (List)this.columnMapCopy.get(string);
        Object e = list.get(this.cursor);
        this.wasNull = null == e;
        return e;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(string);
    }

    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            return object.toString();
        }
        return null;
    }

    public String getString(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            return object.toString();
        }
        return null;
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return new Boolean(object.toString());
        }
        return false;
    }

    public boolean getBoolean(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return new Boolean(object.toString());
        }
        return false;
    }

    public byte getByte(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).byteValue();
            }
            return new Byte(object.toString());
        }
        return 0;
    }

    public byte getByte(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).byteValue();
            }
            return new Byte(object.toString());
        }
        return 0;
    }

    public short getShort(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).shortValue();
            }
            return new Short(object.toString());
        }
        return 0;
    }

    public short getShort(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).shortValue();
            }
            return new Short(object.toString());
        }
        return 0;
    }

    public int getInt(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            return new Integer(object.toString());
        }
        return 0;
    }

    public int getInt(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            return new Integer(object.toString());
        }
        return 0;
    }

    public long getLong(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            return new Long(object.toString());
        }
        return 0L;
    }

    public long getLong(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            return new Long(object.toString());
        }
        return 0L;
    }

    public float getFloat(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).floatValue();
            }
            return new Float(object.toString()).floatValue();
        }
        return 0.0f;
    }

    public float getFloat(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).floatValue();
            }
            return new Float(object.toString()).floatValue();
        }
        return 0.0f;
    }

    public double getDouble(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return new Double(object.toString());
        }
        return 0.0;
    }

    public double getDouble(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return new Double(object.toString());
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (null != bigDecimal) {
            return bigDecimal.setScale(n2);
        }
        return null;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(string);
        if (null != bigDecimal) {
            return bigDecimal.setScale(n);
        }
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).doubleValue());
            }
            return new BigDecimal(object.toString());
        }
        return null;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).doubleValue());
            }
            return new BigDecimal(object.toString());
        }
        return null;
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            return object.toString().getBytes();
        }
        return null;
    }

    public byte[] getBytes(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            return object.toString().getBytes();
        }
        return null;
    }

    public Date getDate(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Date) {
                return (Date)object;
            }
            return Date.valueOf(object.toString());
        }
        return null;
    }

    public Date getDate(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Date) {
                return (Date)object;
            }
            return Date.valueOf(object.toString());
        }
        return null;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(string);
    }

    public Time getTime(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Time) {
                return (Time)object;
            }
            return Time.valueOf(object.toString());
        }
        return null;
    }

    public Time getTime(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Time) {
                return (Time)object;
            }
            return Time.valueOf(object.toString());
        }
        return null;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(string);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Timestamp) {
                return (Timestamp)object;
            }
            return Timestamp.valueOf(object.toString());
        }
        return null;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Timestamp) {
                return (Timestamp)object;
            }
            return Timestamp.valueOf(object.toString());
        }
        return null;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(string);
    }

    public URL getURL(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof URL) {
                return (URL)object;
            }
            try {
                return new URL(object.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public URL getURL(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof URL) {
                return (URL)object;
            }
            try {
                return new URL(object.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public Blob getBlob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Blob) {
                return (Blob)object;
            }
            return new MockBlob(this.getBytes(n));
        }
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Blob) {
                return (Blob)object;
            }
            return new MockBlob(this.getBytes(string));
        }
        return null;
    }

    public Clob getClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Clob) {
                return (Clob)object;
            }
            return new MockClob(this.getString(n));
        }
        return null;
    }

    public Clob getClob(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Clob) {
                return (Clob)object;
            }
            return new MockClob(this.getString(string));
        }
        return null;
    }

    public Array getArray(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Array) {
                return (Array)object;
            }
            return new MockArray(object);
        }
        return null;
    }

    public Array getArray(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Array) {
                return (Array)object;
            }
            return new MockArray(object);
        }
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Ref) {
                return (Ref)object;
            }
            return new MockRef(object);
        }
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Ref) {
                return (Ref)object;
            }
            return new MockRef(object);
        }
        return null;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getBinaryStream(string);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            return new ByteArrayInputStream(this.getBytes(n));
        }
        return null;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            return new ByteArrayInputStream(this.getBytes(string));
        }
        return null;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            try {
                return new ByteArrayInputStream(this.getString(n).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            try {
                return new ByteArrayInputStream(this.getString(string).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Reader) {
                return (Reader)object;
            }
            return new StringReader(this.getString(n));
        }
        return null;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Reader) {
                return (Reader)object;
            }
            return new StringReader(this.getString(string));
        }
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (null != this.resultSetMetaData) {
            return this.resultSetMetaData;
        }
        MockResultSetMetaData mockResultSetMetaData = new MockResultSetMetaData();
        mockResultSetMetaData.setColumnCount(this.getColumnCount());
        for (int i = 0; i < this.columnNameList.size(); ++i) {
            mockResultSetMetaData.setColumnName(i + 1, (String)this.columnNameList.get(i));
        }
        return mockResultSetMetaData;
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.getRowCount() != 0 && this.cursor == -1;
    }

    public boolean isAfterLast() throws SQLException {
        return this.cursor >= this.getRowCount();
    }

    public boolean isFirst() throws SQLException {
        return this.cursor == 0;
    }

    public boolean isLast() throws SQLException {
        return this.cursor != -1 && this.cursor == this.getRowCount() - 1;
    }

    public void beforeFirst() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        this.cursor = -1;
    }

    public void afterLast() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return;
        }
        this.cursor = this.getRowCount();
    }

    public boolean next() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        if (this.getRowCount() == 0) {
            return false;
        }
        ++this.cursor;
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    public boolean first() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        this.cursor = 0;
        return true;
    }

    public boolean last() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        this.cursor = this.getRowCount() - 1;
        return true;
    }

    public boolean absolute(int n) throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        if (n > 0) {
            this.cursor = n - 1;
        }
        if (n < 0) {
            this.cursor = this.getRowCount() + n;
        }
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    public boolean relative(int n) throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        this.cursor += n;
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    public int getRow() throws SQLException {
        return this.cursor + 1;
    }

    public boolean previous() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        --this.cursor;
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkFetchDirectionArguments(n);
        if (this.fetchDirection == n) {
            return;
        }
        if (this.fetchDirection == 1002 || n == 1002) {
            this.fetchDirection = n;
            return;
        }
        this.fetchDirection = n;
        Iterator iterator = this.columnMapCopy.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Collections.reverse(list);
        }
        if (-1 != this.cursor) {
            this.cursor = this.getRowCount() - this.cursor - 1;
        }
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return this.resultSetType;
    }

    public int getConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int findColumn(String string) throws SQLException {
        for (int i = 0; i < this.columnNameList.size(); ++i) {
            if (!string.equals(this.columnNameList.get(i))) continue;
            return i + 1;
        }
        throw new SQLException("No column with name " + string + " found");
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.checkColumnBounds(n);
        this.checkRowBounds();
        if (this.rowDeleted()) {
            throw new SQLException("row was deleted");
        }
        String string = (String)this.columnNameList.get(n - 1);
        this.updateObject(string, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(string, object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.checkColumnName(string);
        this.checkRowBounds();
        this.checkResultSetConcurrency();
        if (this.rowDeleted()) {
            throw new SQLException("row was deleted");
        }
        if (this.isCursorInInsertRow) {
            List list = (List)this.insertRow.get(string);
            list.set(0, object);
        } else {
            List list = (List)this.columnMapCopy.get(string);
            list.set(this.cursor, object);
        }
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateObject(string, (Object)string2);
    }

    public void updateNull(int n) throws SQLException {
        this.updateObject(n, null);
    }

    public void updateNull(String string) throws SQLException {
        this.updateObject(string, null);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)new Boolean(bl));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateObject(string, (Object)new Boolean(bl));
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Byte(by));
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateObject(string, (Object)new Byte(by));
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Short(s));
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateObject(string, (Object)new Short(s));
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateObject(string, (Object)new Integer(n));
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateObject(string, (Object)new Long(l));
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateObject(string, (Object)new Float(f));
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateObject(string, (Object)new Double(d));
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(string, (Object)bigDecimal);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateObject(string, (Object)byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateObject(string, (Object)date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateObject(string, (Object)time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateObject(string, (Object)timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(n, inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(string, inputStream, n);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream, n2);
        this.updateObject(n, (Object)new ByteArrayInputStream(byArray));
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream, n);
        this.updateObject(string, (Object)new ByteArrayInputStream(byArray));
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        String string = StreamUtil.getReaderAsString(reader, n2);
        this.updateObject(n, (Object)new StringReader(string));
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        String string2 = StreamUtil.getReaderAsString(reader, n);
        this.updateObject(string, (Object)new StringReader(string2));
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.updateObject(n, (Object)ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateObject(string, (Object)ref);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateObject(n, (Object)blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateObject(string, (Object)blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateObject(n, (Object)clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateObject(string, (Object)clob);
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.updateObject(n, (Object)array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateObject(string, (Object)array);
    }

    public boolean rowUpdated() throws SQLException {
        this.checkRowBounds();
        return (Boolean)this.updatedRows.get(this.cursor);
    }

    public boolean rowInserted() throws SQLException {
        this.checkRowBounds();
        return (Boolean)this.insertedRows.get(this.cursor);
    }

    public boolean rowDeleted() throws SQLException {
        this.checkRowBounds();
        return (Boolean)this.deletedRows.get(this.cursor);
    }

    public void insertRow() throws SQLException {
        if (!this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.insertRow(this.cursor);
    }

    public void updateRow() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        if (this.rowDeleted()) {
            throw new SQLException("row was deleted");
        }
        this.checkRowBounds();
        this.updateRow(this.cursor, true);
        this.updatedRows.set(this.cursor, new Boolean(true));
    }

    public void deleteRow() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkRowBounds();
        this.deleteRow(this.cursor);
        this.deletedRows.set(this.cursor, new Boolean(true));
    }

    public void refreshRow() throws SQLException {
        this.cancelRowUpdates();
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        if (this.rowDeleted()) {
            throw new SQLException("row was deleted");
        }
        this.checkRowBounds();
        this.updateRow(this.cursor, false);
        this.updatedRows.set(this.cursor, new Boolean(false));
    }

    public void moveToInsertRow() throws SQLException {
        this.isCursorInInsertRow = true;
    }

    public void moveToCurrentRow() throws SQLException {
        this.isCursorInInsertRow = false;
    }

    private void checkColumnName(String string) throws SQLException {
        if (!this.columnMap.containsKey(string)) {
            throw new SQLException("No column " + string);
        }
    }

    private void checkColumnBounds(int n) throws SQLException {
        if (n - 1 >= this.columnNameList.size()) {
            throw new SQLException("Index " + n + " out of bounds");
        }
    }

    private void checkRowBounds() throws SQLException {
        if (!this.isCurrentRowValid()) {
            throw new SQLException("Current row invalid");
        }
    }

    private boolean isCurrentRowValid() {
        return this.cursor < this.getRowCount() && -1 != this.cursor;
    }

    private void checkResultSetType() throws SQLException {
        if (this.resultSetType == 1003) {
            throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
        }
    }

    private void checkResultSetConcurrency() throws SQLException {
        if (this.resultSetConcurrency == 1007) {
            throw new SQLException("ResultSet is CONCUR_READ_ONLY");
        }
    }

    private void checkFetchDirectionArguments(int n) throws SQLException {
        SQLUtil.checkFetchDirection(n);
        if (this.resultSetType == 1003 && n != 1000) {
            throw new SQLException("resultSetType is TYPE_FORWARD_ONLY, only FETCH_FORWARD allowed");
        }
    }

    private void insertRow(int n) {
        Iterator iterator = this.columnMapCopy.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)this.columnMapCopy.get(string);
            List list2 = (List)this.columnMap.get(string);
            List list3 = (List)this.insertRow.get(string);
            list.add(n, list3.get(0));
            list2.add(n, list3.get(0));
        }
        this.updatedRows.add(n, new Boolean(false));
        this.deletedRows.add(n, new Boolean(false));
        this.insertedRows.add(n, new Boolean(true));
    }

    private void deleteRow(int n) {
        Iterator iterator = this.columnMapCopy.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)this.columnMapCopy.get(string);
            List list2 = (List)this.columnMap.get(string);
            list.set(n, null);
            list2.set(n, null);
        }
    }

    private void updateRow(int n, boolean bl) {
        Iterator iterator = this.columnMapCopy.keySet().iterator();
        while (iterator.hasNext()) {
            List list;
            List list2;
            String string = (String)iterator.next();
            if (bl) {
                list2 = (List)this.columnMapCopy.get(string);
                list = (List)this.columnMap.get(string);
            } else {
                list2 = (List)this.columnMap.get(string);
                list = (List)this.columnMapCopy.get(string);
            }
            list.set(n, list2.get(n));
        }
    }

    private void adjustCursor() {
        if (this.cursor < 0) {
            this.cursor = -1;
        }
        if (this.cursor >= this.getRowCount()) {
            this.cursor = this.getRowCount();
        }
    }

    private void adjustColumns() {
        List list;
        int n = 0;
        Iterator iterator = this.columnMap.values().iterator();
        while (iterator.hasNext()) {
            list = (List)iterator.next();
            n = Math.max(n, list.size());
        }
        iterator = this.columnMap.values().iterator();
        while (iterator.hasNext()) {
            list = (List)iterator.next();
            CollectionUtil.fillList(list, n);
        }
    }

    private void adjustFlags() {
        int n;
        for (n = this.updatedRows.size(); n < this.getRowCount(); ++n) {
            this.updatedRows.add(new Boolean(false));
        }
        for (n = this.deletedRows.size(); n < this.getRowCount(); ++n) {
            this.deletedRows.add(new Boolean(false));
        }
        for (n = this.insertedRows.size(); n < this.getRowCount(); ++n) {
            this.insertedRows.add(new Boolean(false));
        }
    }

    private void adjustInsertRow() {
        this.insertRow = this.createCaseAwareMap();
        Iterator iterator = this.columnMap.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(null);
            this.insertRow.put((String)iterator.next(), arrayList);
        }
    }

    private void copyColumnMap() {
        this.columnMapCopy = this.copyColumnDataMap(this.columnMap);
    }

    private String determineValidColumnName() {
        String string = "Column";
        int n = this.columnNameList.size() + 1;
        while (this.columnMap.containsKey(string + n)) {
            ++n;
        }
        return string + n;
    }

    private Map copyColumnDataMap(Map map) {
        Map map2 = this.createCaseAwareMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string = (String)iterator.next();
            List list = (List)map.get(string);
            for (int i = 0; i < list.size(); ++i) {
                Object object = ParameterUtil.copyParameter(list.get(i));
                arrayList.add(object);
            }
            map2.put(string, arrayList);
        }
        return map2;
    }

    private Map createCaseAwareMap() {
        return new CaseAwareMap(this.columnsCaseSensitive);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ResultSet " + this.id + ":\n");
        stringBuffer.append("Number of rows: " + this.getRowCount() + "\n");
        stringBuffer.append("Number of columns: " + this.getColumnCount() + "\n");
        stringBuffer.append("Column names:\n");
        StringUtil.appendObjectsAsString(stringBuffer, this.columnNameList);
        stringBuffer.append("Data:\n");
        for (int i = 1; i <= this.getRowCount(); ++i) {
            stringBuffer.append("Row number " + i + ":\n");
            StringUtil.appendObjectsAsString(stringBuffer, this.getRow(i));
        }
        return stringBuffer.toString();
    }
}

