/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.AbstractResultSetHandler;
import com.mockrunner.jdbc.ParameterSets;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.jdbc.SQLStatementMatcher;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.ArrayUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractParameterResultSetHandler
extends AbstractResultSetHandler {
    private boolean exactMatchParameter = false;
    private Map resultSetsForStatement = new HashMap();
    private Map updateCountForStatement = new HashMap();
    private Map throwsSQLException = new HashMap();
    private Map generatedKeysForStatement = new HashMap();
    private Map executedStatementParameters = new HashMap();

    public void addParameterMapForExecutedStatement(String string, Map map) {
        if (null != map) {
            if (null == this.executedStatementParameters.get(string)) {
                this.executedStatementParameters.put(string, new ParameterSets(string));
            }
            ParameterSets parameterSets = (ParameterSets)this.executedStatementParameters.get(string);
            parameterSets.addParameterSet(map);
        }
    }

    public ParameterSets getParametersForExecutedStatement(String string) {
        return (ParameterSets)this.executedStatementParameters.get(string);
    }

    public Map getExecutedStatementParameterMap() {
        return Collections.unmodifiableMap(this.executedStatementParameters);
    }

    public Map getExecutedStatementParameter() {
        return this.getExecutedStatementParameterMap();
    }

    public void setExactMatchParameter(boolean bl) {
        this.exactMatchParameter = bl;
    }

    public Integer getUpdateCount(String string, Map map) {
        Integer[] integerArray = this.getUpdateCounts(string, map);
        if (null != integerArray && integerArray.length > 0) {
            return integerArray[0];
        }
        return null;
    }

    public Integer[] getUpdateCounts(String string, Map map) {
        ParameterWrapper parameterWrapper = this.getMatchingParameterWrapper(string, map, this.updateCountForStatement);
        if (null != parameterWrapper) {
            if (parameterWrapper instanceof MockUpdateCountWrapper) {
                return new Integer[]{((MockUpdateCountWrapper)parameterWrapper).getUpdateCount()};
            }
            if (parameterWrapper instanceof MockUpdateCountArrayWrapper) {
                return ((MockUpdateCountArrayWrapper)parameterWrapper).getUpdateCount();
            }
        }
        return null;
    }

    public boolean hasMultipleUpdateCounts(String string, Map map) {
        ParameterWrapper parameterWrapper = this.getMatchingParameterWrapper(string, map, this.updateCountForStatement);
        return parameterWrapper instanceof MockUpdateCountArrayWrapper;
    }

    public MockResultSet getResultSet(String string, Map map) {
        MockResultSet[] mockResultSetArray = this.getResultSets(string, map);
        if (null != mockResultSetArray && mockResultSetArray.length > 0) {
            return mockResultSetArray[0];
        }
        return null;
    }

    public MockResultSet[] getResultSets(String string, Map map) {
        ParameterWrapper parameterWrapper = this.getMatchingParameterWrapper(string, map, this.resultSetsForStatement);
        if (null != parameterWrapper) {
            if (parameterWrapper instanceof MockResultSetWrapper) {
                return new MockResultSet[]{((MockResultSetWrapper)parameterWrapper).getResultSet()};
            }
            if (parameterWrapper instanceof MockResultSetArrayWrapper) {
                return ((MockResultSetArrayWrapper)parameterWrapper).getResultSets();
            }
        }
        return null;
    }

    public boolean hasMultipleResultSets(String string, Map map) {
        ParameterWrapper parameterWrapper = this.getMatchingParameterWrapper(string, map, this.resultSetsForStatement);
        return parameterWrapper instanceof MockResultSetArrayWrapper;
    }

    public boolean getThrowsSQLException(String string, Map map) {
        return this.getSQLException(string, map) != null;
    }

    public SQLException getSQLException(String string, Map map) {
        MockSQLExceptionWrapper mockSQLExceptionWrapper = (MockSQLExceptionWrapper)this.getMatchingParameterWrapper(string, map, this.throwsSQLException);
        if (null != mockSQLExceptionWrapper) {
            return mockSQLExceptionWrapper.getException();
        }
        return null;
    }

    public MockResultSet getGeneratedKeys(String string, Map map) {
        MockResultSetWrapper mockResultSetWrapper = (MockResultSetWrapper)this.getMatchingParameterWrapper(string, map, this.generatedKeysForStatement);
        if (null != mockResultSetWrapper) {
            return mockResultSetWrapper.getResultSet();
        }
        return null;
    }

    protected ParameterWrapper getMatchingParameterWrapper(String string, Map map, Map map2) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(map2, string, true, true);
        for (int i = 0; i < list.size(); ++i) {
            ParameterWrapper parameterWrapper = (ParameterWrapper)list.get(i);
            if (!this.doParameterMatch(parameterWrapper.getParamters(), map)) continue;
            return parameterWrapper;
        }
        return null;
    }

    private boolean doParameterMatch(Map map, Map map2) {
        if (this.exactMatchParameter) {
            if (map2.size() != map.size()) {
                return false;
            }
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!map2.containsKey(k)) {
                    return false;
                }
                Object v = map.get(k);
                if (ParameterUtil.compareParameter(map2.get(k), v)) continue;
                return false;
            }
            return true;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!map2.containsKey(k)) {
                return false;
            }
            Object v = map2.get(k);
            if (ParameterUtil.compareParameter(v, map.get(k))) continue;
            return false;
        }
        return true;
    }

    public void clearResultSets() {
        super.clearResultSets();
        this.resultSetsForStatement.clear();
    }

    public void clearUpdateCounts() {
        super.clearUpdateCounts();
        this.updateCountForStatement.clear();
    }

    public void clearThrowsSQLException() {
        super.clearThrowsSQLException();
        this.throwsSQLException.clear();
    }

    public void clearGeneratedKeys() {
        super.clearGeneratedKeys();
        this.generatedKeysForStatement.clear();
    }

    public void prepareResultSet(String string, MockResultSet mockResultSet, Object[] objectArray) {
        this.prepareResultSet(string, mockResultSet, Arrays.asList(objectArray));
    }

    public void prepareResultSets(String string, MockResultSet[] mockResultSetArray, Object[] objectArray) {
        this.prepareResultSets(string, mockResultSetArray, Arrays.asList(objectArray));
    }

    public void prepareResultSet(String string, MockResultSet mockResultSet, List list) {
        Map map = this.createParameterMap(list);
        this.prepareResultSet(string, mockResultSet, map);
    }

    public void prepareResultSets(String string, MockResultSet[] mockResultSetArray, List list) {
        Map map = this.createParameterMap(list);
        this.prepareResultSets(string, mockResultSetArray, map);
    }

    public void prepareResultSet(String string, MockResultSet mockResultSet, Map map) {
        List list = this.getListFromMapForSQLStatement(string, this.resultSetsForStatement);
        list.add(new MockResultSetWrapper(mockResultSet, new HashMap(map)));
    }

    public void prepareResultSets(String string, MockResultSet[] mockResultSetArray, Map map) {
        List list = this.getListFromMapForSQLStatement(string, this.resultSetsForStatement);
        list.add(new MockResultSetArrayWrapper((MockResultSet[])mockResultSetArray.clone(), new HashMap(map)));
    }

    public void prepareThrowsSQLException(String string, Object[] objectArray) {
        SQLException sQLException = new SQLException("Statement " + string + " was specified to throw an exception");
        this.prepareThrowsSQLException(string, sQLException, objectArray);
    }

    public void prepareThrowsSQLException(String string, List list) {
        SQLException sQLException = new SQLException("Statement " + string + " was specified to throw an exception");
        this.prepareThrowsSQLException(string, sQLException, list);
    }

    public void prepareThrowsSQLException(String string, Map map) {
        SQLException sQLException = new SQLException("Statement " + string + " was specified to throw an exception");
        this.prepareThrowsSQLException(string, sQLException, map);
    }

    public void prepareThrowsSQLException(String string, SQLException sQLException, Object[] objectArray) {
        this.prepareThrowsSQLException(string, sQLException, Arrays.asList(objectArray));
    }

    public void prepareThrowsSQLException(String string, SQLException sQLException, List list) {
        Map map = this.createParameterMap(list);
        this.prepareThrowsSQLException(string, sQLException, map);
    }

    public void prepareThrowsSQLException(String string, SQLException sQLException, Map map) {
        List list = this.getListFromMapForSQLStatement(string, this.throwsSQLException);
        list.add(new MockSQLExceptionWrapper(sQLException, new HashMap(map)));
    }

    public void prepareUpdateCount(String string, int n, Object[] objectArray) {
        this.prepareUpdateCount(string, n, Arrays.asList(objectArray));
    }

    public void prepareUpdateCounts(String string, int[] nArray, Object[] objectArray) {
        this.prepareUpdateCounts(string, nArray, Arrays.asList(objectArray));
    }

    public void prepareUpdateCount(String string, int n, List list) {
        Map map = this.createParameterMap(list);
        this.prepareUpdateCount(string, n, map);
    }

    public void prepareUpdateCounts(String string, int[] nArray, List list) {
        Map map = this.createParameterMap(list);
        this.prepareUpdateCounts(string, nArray, map);
    }

    public void prepareUpdateCount(String string, int n, Map map) {
        List list = this.getListFromMapForSQLStatement(string, this.updateCountForStatement);
        list.add(new MockUpdateCountWrapper(n, new HashMap(map)));
    }

    public void prepareUpdateCounts(String string, int[] nArray, Map map) {
        List list = this.getListFromMapForSQLStatement(string, this.updateCountForStatement);
        list.add(new MockUpdateCountArrayWrapper((int[])nArray.clone(), new HashMap(map)));
    }

    public void prepareGeneratedKeys(String string, MockResultSet mockResultSet, Object[] objectArray) {
        this.prepareGeneratedKeys(string, mockResultSet, Arrays.asList(objectArray));
    }

    public void prepareGeneratedKeys(String string, MockResultSet mockResultSet, List list) {
        Map map = this.createParameterMap(list);
        this.prepareGeneratedKeys(string, mockResultSet, map);
    }

    public void prepareGeneratedKeys(String string, MockResultSet mockResultSet, Map map) {
        List list = this.getListFromMapForSQLStatement(string, this.generatedKeysForStatement);
        list.add(new MockResultSetWrapper(mockResultSet, new HashMap(map)));
    }

    private List getListFromMapForSQLStatement(String string, Map map) {
        ArrayList arrayList = (ArrayList)map.get(string);
        if (null == arrayList) {
            arrayList = new ArrayList();
            map.put(string, arrayList);
        }
        return arrayList;
    }

    private Map createParameterMap(List list) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(new Integer(i + 1), list.get(i));
        }
        return hashMap;
    }

    private class MockUpdateCountArrayWrapper
    extends ParameterWrapper {
        private Integer[] updateCounts;

        public MockUpdateCountArrayWrapper(int[] nArray, Map map) {
            super(map);
            this.updateCounts = (Integer[])ArrayUtil.convertToObjectArray(nArray);
        }

        public Integer[] getUpdateCount() {
            return this.updateCounts;
        }
    }

    private class MockUpdateCountWrapper
    extends ParameterWrapper {
        private Integer updateCount;

        public MockUpdateCountWrapper(int n, Map map) {
            super(map);
            this.updateCount = new Integer(n);
        }

        public Integer getUpdateCount() {
            return this.updateCount;
        }
    }

    private class MockResultSetArrayWrapper
    extends ParameterWrapper {
        private MockResultSet[] resultSets;

        public MockResultSetArrayWrapper(MockResultSet[] mockResultSetArray, Map map) {
            super(map);
            this.resultSets = mockResultSetArray;
        }

        public MockResultSet[] getResultSets() {
            return this.resultSets;
        }
    }

    private class MockResultSetWrapper
    extends ParameterWrapper {
        private MockResultSet resultSet;

        public MockResultSetWrapper(MockResultSet mockResultSet, Map map) {
            super(map);
            this.resultSet = mockResultSet;
        }

        public MockResultSet getResultSet() {
            return this.resultSet;
        }
    }

    private class MockSQLExceptionWrapper
    extends ParameterWrapper {
        private SQLException exception;

        public MockSQLExceptionWrapper(SQLException sQLException, Map map) {
            super(map);
            this.exception = sQLException;
        }

        public SQLException getException() {
            return this.exception;
        }
    }

    protected class ParameterWrapper {
        private Map parameters;

        public ParameterWrapper(Map map) {
            this.parameters = map;
        }

        public Map getParamters() {
            return this.parameters;
        }
    }
}

