/*
 * Decompiled with CFR 0.152.
 */
package com.vs.wdo.rtl;

import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoTransaction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class WdoSeq {
    private String serviceName = "default";
    private String name = "default";
    private int incr = 1;
    private int cache = 1;
    private long seqStart = 1L;
    private long chunkStart = 1L;
    private long curr = 1L;
    private static Long loadLock = new Long(1L);
    private PreparedStatement reloadPs = null;
    private PreparedStatement reload2Ps = null;
    private static HashMap seqMap = new HashMap();

    private WdoSeq(String string, String string2) {
        this.serviceName = string;
        this.name = string2;
    }

    public static long GetNextSequence(String string) throws WdoBaseException {
        return WdoSeq.GetNextSequence("default", string);
    }

    public static long GetNextSequence(String string, String string2) throws WdoBaseException {
        WdoSeq wdoSeq;
        long l = -1L;
        String string3 = string + ":" + string2;
        while ((wdoSeq = (WdoSeq)seqMap.get(string3)) == null) {
            wdoSeq = WdoSeq.LoadSequence(string, string2);
            seqMap.put(string3, wdoSeq);
        }
        if (wdoSeq.curr > Long.MAX_VALUE - (long)wdoSeq.incr) {
            WdoBaseException.ThrowProxyWdoException(12, "Sequence '" + string2 + "' has reached its limit of " + Long.MAX_VALUE + ".  Please export your database schema for this component, then purge and reset it.");
        }
        if ((l = wdoSeq.curr + (long)wdoSeq.incr) >= wdoSeq.chunkStart + (long)wdoSeq.cache) {
            wdoSeq.reload();
            if (l < wdoSeq.chunkStart) {
                l = wdoSeq.chunkStart;
            } else if (l > wdoSeq.chunkStart) {
                wdoSeq.curr = l;
            }
        } else {
            wdoSeq.curr = l;
        }
        return l;
    }

    public static long GetCurrSequence(String string) throws WdoBaseException {
        return WdoSeq.GetCurrSequence("default", string);
    }

    public static long GetCurrSequence(String string, String string2) throws WdoBaseException {
        String string3 = string + ":" + string2;
        WdoSeq wdoSeq = (WdoSeq)seqMap.get(string3);
        if (wdoSeq == null) {
            WdoBaseException.ThrowProxyWdoException(5, "Getting currval from uninitialized sequence '" + string2 + "'");
        }
        return wdoSeq.curr;
    }

    private static WdoSeq LoadSequence(String string, String string2) throws WdoBaseException {
        WdoSeq wdoSeq = new WdoSeq(string, string2);
        wdoSeq.reload();
        return wdoSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void reload() throws WdoBaseException {
        block26: {
            Long l = loadLock;
            synchronized (l) {
                int n;
                WdoTransaction wdoTransaction = null;
                ResultSet resultSet = null;
                Connection connection = null;
                wdoTransaction = WdoTransaction.GetTransactionObject(this.serviceName);
                connection = wdoTransaction.getConnection(true, true);
                if (this.reloadPs == null) {
                    this.reloadPs = connection.prepareStatement("select startValue, chunkStart, incr, cache from t_seq_" + this.name.substring(0, this.name.indexOf(".")) + " where name = '" + this.name.substring(this.name.indexOf(".") + 1) + "'");
                }
                if (!(resultSet = this.reloadPs.executeQuery()).next()) {
                    WdoBaseException.ThrowProxyWdoException(5, "Can't find sequence '" + this.name + "'");
                }
                this.seqStart = resultSet.getLong(1);
                this.chunkStart = resultSet.getLong(2);
                this.incr = resultSet.getInt(3);
                this.cache = resultSet.getInt(4);
                if (this.reload2Ps == null) {
                    this.reload2Ps = connection.prepareStatement("update t_seq_" + this.name.substring(0, this.name.indexOf(".")) + " set chunkStart = chunkStart + cache where name = '" + this.name.substring(this.name.indexOf(".") + 1) + "'");
                }
                if ((n = this.reload2Ps.executeUpdate()) != 1) {
                    WdoBaseException.ThrowProxyWdoException(5, "What!  Row disappeared whilst locked inside a transaction!!");
                }
                connection.commit();
                wdoTransaction.connectionPool.releaseConnection(connection);
                connection = null;
                this.curr = this.seqStart == this.chunkStart ? this.chunkStart - (long)this.incr : this.chunkStart;
                Object var7_7 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (connection != null) {
                        connection.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (wdoTransaction != null) {
                    WdoTransaction.ReturnTransactionObject(wdoTransaction);
                }
                break block26;
                {
                    catch (SQLException sQLException) {
                        WdoBaseException.ThrowJdbcDbException(sQLException);
                        Object var7_8 = null;
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (connection != null) {
                                connection.rollback();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (wdoTransaction != null) {
                            WdoTransaction.ReturnTransactionObject(wdoTransaction);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            connection.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (wdoTransaction != null) {
                        WdoTransaction.ReturnTransactionObject(wdoTransaction);
                    }
                    throw throwable;
                }
            }
        }
    }
}

