/*
 * Decompiled with CFR 0.152.
 */
package com.vs.wdo.rtl;

import com.vs.wdo.rtl.WdoCancelException;
import com.vs.wdo.rtl.WdoDbProgException;
import com.vs.wdo.rtl.WdoDuplicateObjectException;
import com.vs.wdo.rtl.WdoFatalInternalException;
import com.vs.wdo.rtl.WdoInternalException;
import com.vs.wdo.rtl.WdoLicenseException;
import com.vs.wdo.rtl.WdoObjectChangedOrDeletedException;
import com.vs.wdo.rtl.WdoOperationException;
import com.vs.wdo.rtl.WdoRetryException;
import com.vs.wdo.rtl.WdoSchemaException;
import com.vs.wdo.rtl.WdoSystem;
import com.vs.wdo.rtl.WdoTransaction;
import com.vs.wdo.rtl.WdoUsageException;
import com.vs.wdo.rtl.WdoUserException;
import com.vs.wdo.rtl.WdoYouLoseException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Date;

public class WdoBaseException
extends Exception {
    protected String fullErrorMessageText;
    public static final int WDO_EXCEPT_CANCEL = 1;
    public static final int WDO_EXCEPT_UNDEFINED_ATTRIBUTE = 2;
    public static final int WDO_EXCEPT_DUPLICATE = 3;
    public static final int WDO_EXCEPT_FATAL_INTERNAL = 4;
    public static final int WDO_EXCEPT_INTERNAL = 5;
    public static final int WDO_EXCEPT_CHANGED_OR_DELETED = 6;
    public static final int WDO_EXCEPT_OPERATION = 7;
    public static final int WDO_EXCEPT_RETRY = 8;
    public static final int WDO_EXCEPT_SCHEMA = 9;
    public static final int WDO_EXCEPT_USAGE = 10;
    public static final int WDO_EXCEPT_YOU_LOSE = 11;
    public static final int WDO_EXCEPT_USER = 12;
    public static final int WDO_EXCEPT_LICENSE = 13;
    private static String _$1768 = "wdoerrbackup.log";
    private static int _$1785;
    private static int _$1791;
    private static boolean _$1799;
    private static boolean _$1809;

    private static int _$1821() {
        if (!_$1799) {
            try {
                String string = WdoSystem.getProperty("default.trace_exc");
                if (string != null) {
                    _$1785 = Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            _$1799 = true;
        }
        return _$1785;
    }

    private static int _$1911() {
        if (!_$1809) {
            try {
                String string = WdoSystem.getProperty("default.trace_console");
                if (string != null) {
                    _$1791 = Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            _$1809 = true;
        }
        return _$1791;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected WdoBaseException() {
    }

    public static void ThrowJdbcDbException(SQLException sQLException) throws WdoBaseException {
        WdoBaseException.ThrowJdbcDbException(sQLException, sQLException.getMessage());
    }

    public static void ThrowJdbcDbException(SQLException sQLException, String string) throws WdoBaseException {
        WdoBaseException wdoBaseException = null;
        String string2 = sQLException.getMessage();
        String string3 = sQLException.getSQLState();
        boolean bl = false;
        wdoBaseException = WdoBaseException.MapJdbcOracleException(sQLException, string);
        if (wdoBaseException == null) {
            wdoBaseException = string3.equals("42501") || string3.equals("23000") ? new WdoDuplicateObjectException() : new WdoOperationException();
            wdoBaseException.fullErrorMessageText = string2;
        }
        if (WdoBaseException._$1821() > 0) {
            WdoBaseException.logError(wdoBaseException, string2, WdoBaseException._$1821() > 1, false);
        }
        throw wdoBaseException;
    }

    public static WdoBaseException MapJdbcOracleException(SQLException sQLException, String string) throws WdoBaseException {
        int n;
        WdoBaseException wdoBaseException = null;
        String string2 = sQLException.getMessage();
        String string3 = sQLException.getSQLState();
        int n2 = 0;
        if (!string2.startsWith("ORA-") && !string2.startsWith("PLS")) {
            return null;
        }
        if (string2.startsWith("ORA-") && (n = (string2 = string2.substring(4)).indexOf(":")) > 0) {
            String string4 = string2.substring(0, n);
            n2 = Integer.parseInt(string4);
            if ((n = (string2 = string2.substring(n + 2)).indexOf("ORA-")) > 0) {
                string2 = string2.substring(0, n);
            }
        }
        switch (n2) {
            case 0: {
                wdoBaseException = new WdoInternalException();
                break;
            }
            case 1: {
                wdoBaseException = new WdoDuplicateObjectException();
                break;
            }
            case 54: {
                wdoBaseException = new WdoYouLoseException();
                break;
            }
            case 1017: {
                wdoBaseException = new WdoUserException();
                break;
            }
            case 60: 
            case 284: 
            case 1012: 
            case 1014: 
            case 1033: 
            case 1034: 
            case 1089: 
            case 1090: 
            case 1094: 
            case 1156: 
            case 3113: 
            case 3114: 
            case 12223: 
            case 12225: 
            case 12226: 
            case 12229: 
            case 12230: 
            case 12500: 
            case 12509: 
            case 12510: 
            case 12511: 
            case 12512: 
            case 12531: 
            case 12537: 
            case 12541: 
            case 12543: 
            case 12547: 
            case 12549: 
            case 12552: 
            case 12566: 
            case 12569: 
            case 12570: 
            case 12571: 
            case 12583: 
            case 12592: {
                wdoBaseException = new WdoRetryException();
                break;
            }
            case 600: {
                wdoBaseException = new WdoFatalInternalException();
                break;
            }
            case 1013: {
                wdoBaseException = new WdoCancelException();
                break;
            }
            case 17003: 
            case 17004: 
            case 17005: 
            case 17006: 
            case 17012: 
            case 17026: 
            case 17036: 
            case 17041: 
            case 17046: 
            case 17048: 
            case 17049: {
                wdoBaseException = new WdoDbProgException();
                break;
            }
            case 20052: {
                wdoBaseException = new WdoUsageException();
                break;
            }
            case 20053: {
                wdoBaseException = new WdoDuplicateObjectException();
                break;
            }
            case 20054: {
                wdoBaseException = new WdoObjectChangedOrDeletedException();
                break;
            }
            case 20055: {
                wdoBaseException = new WdoUserException();
                break;
            }
            case 20056: {
                wdoBaseException = new WdoInternalException();
                break;
            }
            default: {
                if (n2 >= 900 && n2 <= 1474) {
                    wdoBaseException = new WdoDbProgException();
                    string3 = sQLException.getMessage();
                    break;
                }
                if (n2 >= 900 && n2 <= 2039 || n2 >= 2140 && n2 <= 2350 || n2 >= 4040 && n2 <= 4099 || n2 >= 6500 && n2 <= 6580 || n2 == 36 || n2 == 73 || n2 == 97) {
                    wdoBaseException = new WdoOperationException();
                    break;
                }
                wdoBaseException = new WdoInternalException();
                string3 = sQLException.getMessage();
            }
        }
        wdoBaseException.fullErrorMessageText = string2;
        return wdoBaseException;
    }

    public static void ThrowProxyWdoException(int n) throws WdoBaseException {
        String string;
        switch (n) {
            case 1: {
                string = "DB Exception - Cancel";
                break;
            }
            case 3: {
                string = "DB Exception - Duplicate Object";
                break;
            }
            case 4: {
                string = "DB Exception - Fatal Internal";
                break;
            }
            case 5: {
                string = "DB Exception - Internal";
                break;
            }
            case 6: {
                string = "DB Exception - Object Changed Or Deleted";
                break;
            }
            case 7: {
                string = "DB Exception - Operation";
                break;
            }
            case 8: {
                string = "DB Exception - Retry";
                break;
            }
            case 9: {
                string = "DB Exception - Schema";
                break;
            }
            case 10: {
                string = "DB Exception - Usage";
                break;
            }
            case 11: {
                string = "DB Exception - You Lose";
                break;
            }
            case 12: {
                string = "DB Exception - User";
                break;
            }
            case 13: {
                string = "DB Exception - License";
                break;
            }
            default: {
                string = "DB Exception - Generic";
            }
        }
        WdoBaseException.ThrowProxyWdoException(n, string);
    }

    public static void ThrowProxyWdoException(int n, String string) throws WdoBaseException {
        WdoBaseException wdoBaseException;
        switch (n) {
            case 1: {
                wdoBaseException = new WdoCancelException();
                break;
            }
            case 3: {
                wdoBaseException = new WdoDuplicateObjectException();
                break;
            }
            case 4: {
                wdoBaseException = new WdoFatalInternalException();
                break;
            }
            case 5: {
                wdoBaseException = new WdoInternalException();
                break;
            }
            case 6: {
                wdoBaseException = new WdoObjectChangedOrDeletedException();
                break;
            }
            case 7: {
                wdoBaseException = new WdoOperationException();
                break;
            }
            case 8: {
                wdoBaseException = new WdoRetryException();
                break;
            }
            case 9: {
                wdoBaseException = new WdoSchemaException();
                break;
            }
            case 10: {
                wdoBaseException = new WdoUsageException();
                break;
            }
            case 11: {
                wdoBaseException = new WdoYouLoseException();
                break;
            }
            case 12: {
                wdoBaseException = new WdoUserException();
                break;
            }
            case 13: {
                wdoBaseException = new WdoLicenseException();
                break;
            }
            default: {
                wdoBaseException = new WdoBaseException();
            }
        }
        wdoBaseException.fullErrorMessageText = string;
        if (WdoBaseException._$1821() > 0) {
            WdoBaseException.logError(wdoBaseException, wdoBaseException.fullErrorMessageText, WdoBaseException._$1821() > 1, false);
        }
        throw wdoBaseException;
    }

    public String getMessage() {
        return this.fullErrorMessageText;
    }

    public static void logError(WdoBaseException wdoBaseException, String string) {
        WdoBaseException.logError(wdoBaseException, string, true, false);
    }

    public static synchronized void logError(WdoBaseException wdoBaseException, String string, boolean bl, boolean bl2) {
        FileOutputStream fileOutputStream = null;
        Throwable throwable = wdoBaseException;
        try {
            if (throwable == null) {
                throwable = new Throwable();
            }
            Date date = new Date();
            String string2 = WdoSystem.wdoAdminHomeDir == null ? "." : WdoSystem.wdoAdminHomeDir;
            fileOutputStream = new FileOutputStream(String.valueOf(string2) + System.getProperty("file.separator") + "wdoerr.log", true);
            PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
            if (bl) {
                throwable.printStackTrace(printWriter);
                if (WdoBaseException._$1911() > 0) {
                    throwable.printStackTrace(System.out);
                }
            }
            String string3 = "WdoBaseException Log\r\n";
            string3 = String.valueOf(string3) + date + "\r\n";
            string3 = String.valueOf(string3) + string + "\r\n\r\n";
            if (bl2) {
                string3 = String.valueOf(string3) + "Transaction Dump\r\n";
                string3 = String.valueOf(string3) + WdoTransaction.getStatus();
                string3 = String.valueOf(string3) + "\r\n\r\n";
            }
            if (WdoBaseException._$1911() > 0) {
                System.out.println(string3);
            }
            fileOutputStream.write(string3.getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                fileOutputStream = new FileOutputStream(_$1768, true);
                Date date = new Date();
                String string4 = "Failed to write to file wdoerr.log " + date + " " + "Reason: " + iOException.getMessage() + "\r\n";
                if (WdoBaseException._$1911() > 0) {
                    System.out.println(string4);
                }
                fileOutputStream.write(string4.getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
    }
}

