/*
 * Decompiled with CFR 0.152.
 */
package com.vs.wdo.rtl;

import com.vs.ezlicrun.EzLicExceptionBase;
import com.vs.ezlicrun.EzLicExceptionExpired;
import com.vs.ezlicrun.EzLicenseInfo;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoSystem;
import java.util.Date;

class LicensePars {
    long cpu;
    String hostName;
    boolean restricted;
    EzLicenseInfo licInfo;
    int warnings;

    LicensePars() {
    }

    public void checkLicense(String string, String string2, int n) throws WdoBaseException {
        this.licInfo = new EzLicenseInfo();
        try {
            this.warnings = this.licInfo.checkLicenseKey(string, null, null, 5, 0L, 0L, 0, 0L, string2, (long)(n == 0 ? 1000 : n));
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            this.setupRestrictedMode(ezLicExceptionBase instanceof EzLicExceptionExpired ? "Expired license" : "Invalid license key", true);
        }
        this.hostName = string2;
    }

    void setupRestrictedMode(String string, boolean bl) {
        String string2 = String.valueOf(string) + (string != null ? ". " : "") + "setting to restricted mode.";
        if (WdoSystem.CheckDebug(5)) {
            System.out.println("Wdo LicensePars: setting up restricted mode.  Reason: '" + string + "'.");
        }
        if (bl && string != null) {
            System.out.println(string2);
        }
        if (string != null) {
            WdoBaseException.logError(null, string2, false, false);
        }
        this.restricted = true;
    }

    void checkExpiration(boolean bl, boolean bl2, String string) throws WdoBaseException {
        long l;
        long l2;
        if (this.licInfo == null || this.licInfo.getExpirationDate() == null) {
            return;
        }
        Date date = new Date();
        if (date.after(this.licInfo.getExpirationDate())) {
            WdoBaseException.ThrowProxyWdoException(13, String.valueOf(bl2 ? "Runtime" : "Development") + " license for " + (bl2 ? "Host " : "User ") + string + " expired on " + this.licInfo.getExpirationDate().toString() + ".\nToday is " + date.toString() + ".\nPlease contact your eXoDy sales representative to " + "renew your license.");
        } else if (bl && (l2 = (l = this.licInfo.getExpirationDate().getTime() - date.getTime()) / (long)86400000) < (long)15) {
            String string2 = String.valueOf(bl2 ? "Runtime" : "Development") + " license alert for " + (bl2 ? "Host " : "User ") + string + ": You have " + Long.toString(l2) + " day" + (l2 == (long)1 ? "" : "s") + " before your license expires. " + "Please contact your eXoDy sales representative to " + "renew your license.";
            System.out.println(string2);
            WdoBaseException.logError(null, string2, false, false);
        }
    }
}

