/*
 * Decompiled with CFR 0.152.
 */
package com.vs.wdo.rtl;

import com.vs.wdo.rtl.HashMapEntry;
import com.vs.wdo.rtl.HashMapEnumerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;

class HashMap
extends Dictionary
implements Cloneable,
Serializable {
    private transient HashMapEntry[] _$1546;
    private transient int _$1552;
    private int _$1558;
    private float _$1568;
    private static final long _$1579 = 1421746759512286392L;

    public HashMap(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this._$1568 = f;
        this._$1546 = new HashMapEntry[n];
        this._$1558 = (int)((float)n * f);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this._$1552;
    }

    public boolean isEmpty() {
        return this._$1552 == 0;
    }

    public Enumeration keys() {
        return new HashMapEnumerator(this._$1546, true);
    }

    public Enumeration elements() {
        return new HashMapEnumerator(this._$1546, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        HashMapEntry[] hashMapEntryArray = this._$1546;
        int n = hashMapEntryArray.length;
        while (n-- > 0) {
            HashMapEntry hashMapEntry = hashMapEntryArray[n];
            while (hashMapEntry != null) {
                if (hashMapEntry.value.equals(object)) {
                    return true;
                }
                hashMapEntry = hashMapEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        HashMapEntry[] hashMapEntryArray = this._$1546;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashMapEntryArray.length;
        HashMapEntry hashMapEntry = hashMapEntryArray[n2];
        while (hashMapEntry != null) {
            if (hashMapEntry.hash == n && hashMapEntry.key.equals(object)) {
                return true;
            }
            hashMapEntry = hashMapEntry.next;
        }
        return false;
    }

    public Object get(Object object) {
        HashMapEntry[] hashMapEntryArray = this._$1546;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashMapEntryArray.length;
        HashMapEntry hashMapEntry = hashMapEntryArray[n2];
        while (hashMapEntry != null) {
            if (hashMapEntry.hash == n && hashMapEntry.key.equals(object)) {
                return hashMapEntry.value;
            }
            hashMapEntry = hashMapEntry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this._$1546.length;
        HashMapEntry[] hashMapEntryArray = this._$1546;
        int n2 = n * 2 + 1;
        HashMapEntry[] hashMapEntryArray2 = new HashMapEntry[n2];
        this._$1558 = (int)((float)n2 * this._$1568);
        this._$1546 = hashMapEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            HashMapEntry hashMapEntry = hashMapEntryArray[n3];
            while (hashMapEntry != null) {
                HashMapEntry hashMapEntry2 = hashMapEntry;
                hashMapEntry = hashMapEntry.next;
                int n4 = (hashMapEntry2.hash & Integer.MAX_VALUE) % n2;
                hashMapEntry2.next = hashMapEntryArray2[n4];
                hashMapEntryArray2[n4] = hashMapEntry2;
            }
        }
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        HashMapEntry[] hashMapEntryArray = this._$1546;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashMapEntryArray.length;
        HashMapEntry hashMapEntry = hashMapEntryArray[n2];
        while (hashMapEntry != null) {
            if (hashMapEntry.hash == n && hashMapEntry.key.equals(object)) {
                Object object3 = hashMapEntry.value;
                hashMapEntry.value = object2;
                return object3;
            }
            hashMapEntry = hashMapEntry.next;
        }
        if (this._$1552 >= this._$1558) {
            this.rehash();
            return this.put(object, object2);
        }
        hashMapEntry = new HashMapEntry();
        hashMapEntry.hash = n;
        hashMapEntry.key = object;
        hashMapEntry.value = object2;
        hashMapEntry.next = hashMapEntryArray[n2];
        hashMapEntryArray[n2] = hashMapEntry;
        ++this._$1552;
        return null;
    }

    public Object remove(Object object) {
        HashMapEntry[] hashMapEntryArray = this._$1546;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashMapEntryArray.length;
        HashMapEntry hashMapEntry = hashMapEntryArray[n2];
        HashMapEntry hashMapEntry2 = null;
        while (hashMapEntry != null) {
            if (hashMapEntry.hash == n && hashMapEntry.key.equals(object)) {
                if (hashMapEntry2 != null) {
                    hashMapEntry2.next = hashMapEntry.next;
                } else {
                    hashMapEntryArray[n2] = hashMapEntry.next;
                }
                --this._$1552;
                return hashMapEntry.value;
            }
            hashMapEntry2 = hashMapEntry;
            hashMapEntry = hashMapEntry.next;
        }
        return null;
    }

    public void clear() {
        HashMapEntry[] hashMapEntryArray = this._$1546;
        int n = hashMapEntryArray.length;
        while (--n >= 0) {
            hashMapEntryArray[n] = null;
        }
        this._$1552 = 0;
    }

    public Object clone() {
        try {
            HashMap hashMap = (HashMap)super.clone();
            hashMap._$1546 = new HashMapEntry[this._$1546.length];
            int n = this._$1546.length;
            while (n-- > 0) {
                HashMapEntry hashMapEntry = hashMap._$1546[n] = this._$1546[n] != null ? (HashMapEntry)this._$1546[n].clone() : null;
            }
            HashMap hashMap2 = hashMap;
            return hashMap2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 <= n) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(String.valueOf(string) + "=" + string2);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void _$1964(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._$1546.length);
        objectOutputStream.writeInt(this._$1552);
        int n = this._$1546.length - 1;
        while (n >= 0) {
            HashMapEntry hashMapEntry = this._$1546[n];
            while (hashMapEntry != null) {
                objectOutputStream.writeObject(hashMapEntry.key);
                objectOutputStream.writeObject(hashMapEntry.value);
                hashMapEntry = hashMapEntry.next;
            }
            --n;
        }
    }

    private void _$2037(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this._$1568) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this._$1546 = new HashMapEntry[n3];
        this._$1552 = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }
}

