/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ezlicrun;

import com.vs.ezlicrun.EzLicExceptionAuthent;
import com.vs.ezlicrun.EzLicExceptionConfig;
import com.vs.ezlicrun.EzLicExceptionExceededLimits;
import com.vs.ezlicrun.EzLicExceptionExpired;
import com.vs.ezlicrun.EzLicExceptionInternal;
import com.vs.ezlicrun.EzLicExceptionInvalidCustomKey;
import com.vs.ezlicrun.EzLicExceptionInvalidHostUserNet;
import com.vs.ezlicrun.EzLicExceptionMalformedKey;
import com.vs.ezlicrun.EzLicExceptionOS;
import com.vs.ezlicrun.EzLicExceptionUnimplemented;
import com.vs.ezlicrun.EzLicExceptionUnlicensedOption;
import com.vs.ezlicrun.EzLicExceptionUsage;
import com.vs.ezlicrun.EzLicenseInfo;
import java.io.PrintWriter;
import java.io.Serializable;

public class EzLicExceptionBase
extends Exception
implements Serializable {
    public static final int EZLIC_EXC_BASE = 0;
    public static final int EZLIC_EXC_MALFORMED_KEY = 1;
    public static final int EZLIC_EXC_EXPIRED = 2;
    public static final int EZLIC_EXC_EXCEEDED_LIMITS = 3;
    public static final int EZLIC_EXC_INVALID_HOST_USER_NET = 4;
    public static final int EZLIC_EXC_INVALID_CUSTOM_KEY = 5;
    public static final int EZLIC_EXC_UNIMPLEMENTED = 6;
    public static final int EZLIC_EXC_GEN = 7;
    public static final int EZLIC_EXC_VENDOR = 8;
    public static final int EZLIC_EXC_INTERNAL = 9;
    public static final int EZLIC_EXC_OS = 10;
    public static final int EZLIC_EXC_CONFIG = 11;
    public static final int EZLIC_EXC_UNLICENSED_OPTION = 12;
    public static final int EZLIC_EXC_USAGE = 13;
    public static final int EZLIC_EXC_AUTHENT = 14;
    public static final int EZLIC_WARN_EXPIRING = 1;
    public static final int EZLIC_WARN_QUOTA = 2;
    public static final int EZLIC_WARN_EXPIRED = 4;
    public static final int EZLIC_WARN_QUOTA_EXCEEDED = 8;
    public static final int EZLIC_WARN_QUOTA_GRACE_TRUNC = 16;
    public static final int EZLIC_WARN_EXP_GRACE_TRUNC = 32;
    private String _$3691;
    private int _$3703;

    public String getMessage() {
        return this._$3691;
    }

    public int getMessageCode() {
        return this._$3703;
    }

    public void setMessage(String string) {
        this._$3691 = string;
    }

    public void setMessageCode(int n) {
        this._$3703 = n;
    }

    public static void throwLicenseException(int n, String string) throws EzLicExceptionBase {
        String string2 = "";
        switch (n) {
            case 1: {
                string2 = "Invalid license key.";
                break;
            }
            case 2: {
                string2 = "License has expired.";
                break;
            }
            case 3: {
                string2 = "Licensed limit has been exceeded.";
                break;
            }
            case 4: {
                string2 = "Invalid host / user / network name.";
                break;
            }
            case 5: {
                string2 = "Invalid custom key.";
                break;
            }
            case 6: {
                string2 = "Unimplemented license management feature.";
                break;
            }
            case 7: {
                string2 = "Error during key generation.";
                break;
            }
            case 8: {
                string2 = "Vendor key parse error.";
                break;
            }
            case 9: {
                string2 = "Internal exception condition.";
                break;
            }
            case 10: {
                string2 = "Operating system error condition.";
                break;
            }
            case 11: {
                string2 = "Invalid EasyLicenser configuration condition.";
                break;
            }
            case 12: {
                string2 = "You are not licensed to use this option.\nPlease contact your sales representative to purchase\nthe option and obtain a new license key.";
                break;
            }
            case 13: {
                string2 = "API usage error.  Please check your parameters and call sequence.";
                break;
            }
            case 14: {
                string2 = "Authentication error.  Please check your product name and application password.";
                break;
            }
            default: {
                string2 = "Unrecognized exception code: " + String.valueOf(n);
                n = 9;
            }
        }
        if (string != null) {
            string2 = String.valueOf(string2) + " " + string;
        }
        EzLicExceptionBase.throwLicenseException(string2, n);
    }

    public static void throwLicenseException(String string, int n) throws EzLicExceptionBase {
        EzLicExceptionBase ezLicExceptionBase;
        if (EzLicenseInfo.checkDebug(1)) {
            new Throwable().printStackTrace();
        }
        switch (n) {
            case 1: {
                ezLicExceptionBase = new EzLicExceptionMalformedKey();
                break;
            }
            case 2: {
                ezLicExceptionBase = new EzLicExceptionExpired();
                break;
            }
            case 12: {
                ezLicExceptionBase = new EzLicExceptionUnlicensedOption();
                break;
            }
            case 3: {
                ezLicExceptionBase = new EzLicExceptionExceededLimits();
                break;
            }
            case 4: {
                ezLicExceptionBase = new EzLicExceptionInvalidHostUserNet();
                break;
            }
            case 5: {
                ezLicExceptionBase = new EzLicExceptionInvalidCustomKey();
                break;
            }
            case 6: {
                ezLicExceptionBase = new EzLicExceptionUnimplemented();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                ezLicExceptionBase = new EzLicExceptionInternal();
                PrintWriter printWriter = new PrintWriter(System.out, true);
                ezLicExceptionBase.printStackTrace(printWriter);
                break;
            }
            case 10: {
                ezLicExceptionBase = new EzLicExceptionOS();
                break;
            }
            case 11: {
                ezLicExceptionBase = new EzLicExceptionConfig();
                break;
            }
            case 13: {
                ezLicExceptionBase = new EzLicExceptionUsage();
                break;
            }
            case 14: {
                ezLicExceptionBase = new EzLicExceptionAuthent();
                break;
            }
            default: {
                try {
                    ezLicExceptionBase = (EzLicExceptionBase)Class.forName(string).newInstance();
                    break;
                }
                catch (Exception exception) {
                    ezLicExceptionBase = new EzLicExceptionInternal();
                    n = 9;
                    string = ": Exception: [" + exception.getClass().getName() + "],  Message: [" + string + "]";
                }
            }
        }
        ezLicExceptionBase.setMessage(string);
        ezLicExceptionBase.setMessageCode(n);
        throw ezLicExceptionBase;
    }
}

