/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.result;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.IOUtility;
import com.agitar.common.util.StringUtility;
import com.agitar.common.util.ZipOutput;
import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.CoverageManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipUnzipCoverage {
    private static int total;
    private static final String ACOV_ZIP = "ACOV.ZIP";

    public static void zipCoverage(File coverageDirectory, ZipOutput zip) throws IOException {
        boolean hasFile = false;
        File masterAcov = new File(coverageDirectory, "-master-.acov");
        if (masterAcov.exists()) {
            hasFile = true;
            zip.add("-master-.acov", masterAcov);
        }
        File covZipFile = File.createTempFile("acov", ".zip");
        covZipFile.deleteOnExit();
        ZipOutput covZip = new ZipOutput((OutputStream)new FileOutputStream(covZipFile), 0);
        File[] coverageFiles = IOUtility.getAllFilesWithExtension((File)coverageDirectory, (String)".acov", (boolean)true);
        String coveragePath = coverageDirectory.getAbsolutePath();
        long masterModTime = masterAcov.lastModified();
        for (int i = 0; i < coverageFiles.length; ++i) {
            File acov = coverageFiles[i];
            if (acov.lastModified() < masterModTime || acov.getName().equals("-master-.acov")) continue;
            hasFile = true;
            covZip.add(acov, coveragePath);
        }
        if (hasFile) {
            covZip.close();
            zip.add(ACOV_ZIP, covZipFile);
        }
        covZipFile.delete();
    }

    public static void importCoverage(File coverageDirectory, ZipFile zipSumFile, boolean clearCoverage, boolean deleteMasterAcov) throws IOException {
        ZipEntry entry;
        long currentTime = -1L;
        if (clearCoverage) {
            currentTime = System.currentTimeMillis();
            File masterFile = new File(coverageDirectory, "-master-.acov");
            ZipEntry entry2 = zipSumFile.getEntry("-master-.acov");
            if (entry2 == null || deleteMasterAcov) {
                masterFile.delete();
            } else {
                IOUtility.writeFile((InputStream)zipSumFile.getInputStream(entry2), (File)masterFile);
                masterFile.setLastModified(currentTime);
            }
        }
        if ((entry = zipSumFile.getEntry(ACOV_ZIP)) != null) {
            InputStream inputStream = zipSumFile.getInputStream(entry);
            if (inputStream != null) {
                ZipUnzipCoverage.unzip(inputStream, coverageDirectory, currentTime);
            }
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream inputStream, File coverageDirectory, long time) {
        HashMap covFileMap = new HashMap();
        if (time > 0L) {
            ZipUnzipCoverage.putFilesInMap(coverageDirectory, covFileMap);
        }
        ZipInputStream zis = new ZipInputStream(inputStream);
        total = 0;
        try {
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                String name = entry.getName().substring(1);
                String className = name.substring(0, name.length() - ".acov".length()).replace('/', '.').replace('\\', '.');
                File file = new File(coverageDirectory, name);
                try {
                    if (time > 0L) {
                        ZipUnzipCoverage.writeAcovFiles(covFileMap, zis, file);
                        if (file.exists()) {
                            file.setLastModified(time + 100L);
                        }
                        ++total;
                    } else {
                        ZipUnzipCoverage.mergeCoverage(coverageDirectory, zis, className);
                    }
                }
                catch (IOException e) {
                    ZipUnzipCoverage.getLog().warning(StringUtility.trace((Throwable)e));
                }
                zis.closeEntry();
                entry = zis.getNextEntry();
            }
        }
        catch (Exception e) {
            ZipUnzipCoverage.getLog().warning(StringUtility.trace((Throwable)e));
        }
        finally {
            try {
                zis.close();
            }
            catch (IOException e) {}
            IOUtility.close((InputStream)inputStream, (boolean)true);
        }
        if (time > 0L && covFileMap.size() > 0) {
            Iterator iter = covFileMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ((File)entry.getValue()).delete();
            }
        }
    }

    public static boolean skipAcov(String className, Set primarysourceOutOfDateSet, Set secondarysourceOutOfDateSet) {
        int dollar;
        if (primarysourceOutOfDateSet == null || primarysourceOutOfDateSet.contains(className)) {
            return true;
        }
        return secondarysourceOutOfDateSet != null && (dollar = className.indexOf(36)) > 0 && secondarysourceOutOfDateSet.contains(className.substring(0, dollar + 1));
    }

    private static void mergeCoverage(File coverageDirectory, ZipInputStream zis, String className) {
        ClassCoverage coverage = null;
        try {
            coverage = CoverageManager.getCoverage(className, coverageDirectory, true);
        }
        catch (Throwable e) {
            ZipUnzipCoverage.getLog().warning(StringUtility.trace((Throwable)e));
        }
        try {
            ClassCoverage newCoverage = new ClassCoverage(className, coverageDirectory);
            newCoverage.read(new DataInputStream(new BufferedInputStream(zis)));
            if (coverage == null) {
                newCoverage.write();
            } else {
                coverage.merge(newCoverage);
                coverage.write();
            }
            ++total;
        }
        catch (Throwable e) {
            ZipUnzipCoverage.getLog().warning(StringUtility.trace((Throwable)e));
        }
    }

    private static void writeAcovFiles(Map covFileMap, ZipInputStream zis, File file) throws FileNotFoundException, IOException {
        file.getParentFile().mkdirs();
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
        byte[] bytes = ZipUnzipCoverage.read(zis);
        fos.write(bytes);
        IOUtility.close((OutputStream)fos, (boolean)true);
        covFileMap.remove(file.getAbsolutePath());
    }

    private static void putFilesInMap(File coverageDirectory, Map covFileMap) {
        File[] covFiles = IOUtility.getAllFilesWithExtension((File)coverageDirectory, (String)".acov", (boolean)true);
        for (int i = 0; i < covFiles.length; ++i) {
            File file = covFiles[i];
            if (file.getName().equals("-master-.acov")) continue;
            covFileMap.put(file.getAbsolutePath(), file);
        }
    }

    private static byte[] read(ZipInputStream zis) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
        IOUtility.copy((InputStream)zis, (OutputStream)baos);
        baos.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    private static Logger getLog() {
        return AgitarLogger.getDiagnosticLogger((String)"zipcov");
    }

    public static void main(String[] args) throws ZipException, IOException {
        File covDir = new File(args[0]);
        CoverageManager.setCoverageDir(covDir);
        long start = System.currentTimeMillis();
        ZipFile zipFile = new ZipFile(new File(args[1]));
        ZipUnzipCoverage.importCoverage(covDir, zipFile, true, false);
        System.out.println("total = " + total + " in " + (float)(System.currentTimeMillis() - start) / 1000.0f + "seconds");
    }
}

