/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage.analysis;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.coverage.analysis.AsmMethodData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.analysis.DataflowValue;
import org.objectweb.asm.tree.analysis.Frame;

public class TrackedInstruction {
    private AbstractInsnNode instruction;
    private int index = -1;
    private List operatesOn;
    private AsmMethodData methodData;
    static final /* synthetic */ boolean $assertionsDisabled;

    private TrackedInstruction(AsmMethodData methodData, AbstractInsnNode instruction, int index) {
        this.methodData = methodData;
        this.instruction = instruction;
        this.index = index;
    }

    public static TrackedInstruction get(AsmMethodData methodData, AbstractInsnNode instruction, int index) {
        return new TrackedInstruction(methodData, instruction, index);
    }

    public AbstractInsnNode getInstruction() {
        return this.instruction;
    }

    public int getIndex() {
        return this.index;
    }

    public void addOperatesOn(AbstractInsnNode operatesOn) {
        if (this.operatesOn == null) {
            this.operatesOn = new ArrayList(1);
        }
        this.operatesOn.add(0, operatesOn);
    }

    public List getOperatesOn() {
        this.setOperatesOn();
        if (this.operatesOn == null) {
            this.operatesOn = Collections.EMPTY_LIST;
        }
        return this.operatesOn;
    }

    public void setOperatesOn() {
        if (this.operatesOn != null) {
            return;
        }
        if (this.methodData == null) {
            return;
        }
        Frame[] frames = this.methodData.getFrames();
        if (frames == null) {
            return;
        }
        if (!$assertionsDisabled && this.instruction == null) {
            throw new AssertionError((Object)"instruction must never be null!");
        }
        Frame frame = frames[this.index];
        if (frame == null) {
            return;
        }
        DataflowValue val = null;
        int operCount = this.getOperandsCount(frame);
        for (int i = frame.getStackSize() - 1; i >= 0; --i) {
            Set instrs;
            try {
                val = (DataflowValue)frame.getStack(i);
            }
            catch (Throwable t) {
                AgitarLogger.getDiagnosticLogger().log(Level.INFO, "TrackInstruction--->" + t.getMessage(), t);
            }
            if (val == null || (instrs = val.insns) == null) continue;
            Iterator iter = instrs.iterator();
            while (iter.hasNext()) {
                if (operCount == 0) {
                    return;
                }
                --operCount;
                Object nextInstr = iter.next();
                if (!$assertionsDisabled && !(nextInstr instanceof AbstractInsnNode)) {
                    throw new AssertionError((Object)"Wrong insn type!");
                }
                AbstractInsnNode insnNode = (AbstractInsnNode)nextInstr;
                if (insnNode == null) continue;
                this.addOperatesOn(insnNode);
            }
        }
    }

    private int getOperandsCount(Frame frame) {
        if (!$assertionsDisabled && !(this.instruction instanceof AbstractInsnNode)) {
            throw new AssertionError();
        }
        int opcode = this.instruction.getOpcode();
        return this.getOperandsCount(opcode);
    }

    private int getOperandsCount(int opcode) {
        int ret = 0;
        switch (opcode) {
            case 50: {
                ret = 2;
                break;
            }
            case 83: {
                ret = 3;
                break;
            }
            case 1: {
                ret = 0;
                break;
            }
            case 25: {
                ret = 0;
                break;
            }
            case 189: {
                ret = 1;
                break;
            }
            case 176: {
                ret = 1;
                break;
            }
            case 190: {
                ret = 1;
                break;
            }
            case 58: {
                ret = 1;
                break;
            }
            case 191: {
                ret = 1;
                break;
            }
            case 51: {
                ret = 2;
                break;
            }
            case 84: {
                ret = 3;
                break;
            }
            case 16: {
                ret = 0;
                break;
            }
            case 52: {
                ret = 2;
                break;
            }
            case 85: {
                ret = 3;
                break;
            }
            case 192: {
                ret = 1;
                break;
            }
            case 144: {
                ret = 1;
                break;
            }
            case 142: {
                ret = 1;
                break;
            }
            case 143: {
                ret = 1;
                break;
            }
            case 99: {
                ret = 2;
                break;
            }
            case 49: {
                ret = 2;
                break;
            }
            case 82: {
                ret = 3;
                break;
            }
            case 152: {
                ret = 2;
                break;
            }
            case 151: {
                ret = 2;
                break;
            }
            case 14: {
                ret = 0;
                break;
            }
            case 15: {
                ret = 0;
                break;
            }
            case 111: {
                ret = 2;
                break;
            }
            case 24: {
                ret = 0;
                break;
            }
            case 107: {
                ret = 2;
                break;
            }
            case 119: {
                ret = 1;
                break;
            }
            case 115: {
                ret = 2;
                break;
            }
            case 175: {
                ret = 1;
                break;
            }
            case 57: {
                ret = 1;
                break;
            }
            case 103: {
                ret = 2;
                break;
            }
            case 89: {
                ret = 1;
                break;
            }
            case 92: {
                ret = 2;
                break;
            }
            case 93: {
                ret = 3;
                break;
            }
            case 94: {
                ret = 4;
                break;
            }
            case 90: {
                ret = 2;
                break;
            }
            case 91: {
                ret = 3;
                break;
            }
            case 141: {
                ret = 1;
                break;
            }
            case 139: {
                ret = 1;
                break;
            }
            case 140: {
                ret = 1;
                break;
            }
            case 98: {
                ret = 2;
                break;
            }
            case 48: {
                ret = 2;
                break;
            }
            case 81: {
                ret = 3;
                break;
            }
            case 150: {
                ret = 2;
                break;
            }
            case 149: {
                ret = 2;
                break;
            }
            case 11: {
                ret = 0;
                break;
            }
            case 12: {
                ret = 0;
                break;
            }
            case 13: {
                ret = 0;
                break;
            }
            case 110: {
                ret = 2;
                break;
            }
            case 23: {
                ret = 0;
                break;
            }
            case 106: {
                ret = 2;
                break;
            }
            case 118: {
                ret = 1;
                break;
            }
            case 114: {
                ret = 2;
                break;
            }
            case 174: {
                ret = 1;
                break;
            }
            case 56: {
                ret = 1;
                break;
            }
            case 102: {
                ret = 2;
                break;
            }
            case 180: {
                ret = 1;
                break;
            }
            case 178: {
                ret = 0;
                break;
            }
            case 167: {
                ret = 0;
                break;
            }
            case 145: {
                ret = 1;
                break;
            }
            case 146: {
                ret = 1;
                break;
            }
            case 135: {
                ret = 1;
                break;
            }
            case 134: {
                ret = 1;
                break;
            }
            case 133: {
                ret = 1;
                break;
            }
            case 147: {
                ret = 1;
                break;
            }
            case 96: {
                ret = 2;
                break;
            }
            case 46: {
                ret = 2;
                break;
            }
            case 126: {
                ret = 2;
                break;
            }
            case 79: {
                ret = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                ret = 0;
                break;
            }
            case 108: {
                ret = 2;
                break;
            }
            case 165: 
            case 166: {
                ret = 2;
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                ret = 2;
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                ret = 1;
                break;
            }
            case 199: {
                ret = 1;
                break;
            }
            case 198: {
                ret = 1;
                break;
            }
            case 132: {
                ret = 0;
                break;
            }
            case 21: {
                ret = 0;
                break;
            }
            case 104: {
                ret = 2;
                break;
            }
            case 116: {
                ret = 1;
                break;
            }
            case 193: {
                ret = 1;
                break;
            }
            case 185: {
                ret = 1 + Type.getArgumentTypes((String)((MethodInsnNode)this.instruction).desc).length;
                break;
            }
            case 183: {
                ret = 1 + Type.getArgumentTypes((String)((MethodInsnNode)this.instruction).desc).length;
                break;
            }
            case 184: {
                ret = Type.getArgumentTypes((String)((MethodInsnNode)this.instruction).desc).length;
                break;
            }
            case 182: {
                ret = 1 + Type.getArgumentTypes((String)((MethodInsnNode)this.instruction).desc).length;
                break;
            }
            case 128: {
                ret = 2;
                break;
            }
            case 112: {
                ret = 2;
                break;
            }
            case 172: {
                ret = 1;
                break;
            }
            case 120: {
                ret = 2;
                break;
            }
            case 122: {
                ret = 2;
                break;
            }
            case 54: {
                ret = 1;
                break;
            }
            case 100: {
                ret = 2;
                break;
            }
            case 124: {
                ret = 2;
                break;
            }
            case 130: {
                ret = 2;
                break;
            }
            case 168: {
                ret = 0;
                break;
            }
            case 138: {
                ret = 1;
                break;
            }
            case 137: {
                ret = 1;
                break;
            }
            case 136: {
                ret = 1;
                break;
            }
            case 97: {
                ret = 2;
                break;
            }
            case 47: {
                ret = 2;
                break;
            }
            case 127: {
                ret = 2;
                break;
            }
            case 80: {
                ret = 3;
                break;
            }
            case 148: {
                ret = 2;
                break;
            }
            case 9: 
            case 10: {
                ret = 0;
                break;
            }
            case 18: {
                ret = 0;
                break;
            }
            case 109: {
                ret = 2;
                break;
            }
            case 22: {
                ret = 0;
                break;
            }
            case 105: {
                ret = 2;
                break;
            }
            case 117: {
                ret = 1;
                break;
            }
            case 171: {
                ret = 1;
                break;
            }
            case 129: {
                ret = 2;
                break;
            }
            case 113: {
                ret = 2;
                break;
            }
            case 173: {
                ret = 1;
                break;
            }
            case 121: 
            case 123: {
                ret = 2;
                break;
            }
            case 55: {
                ret = 1;
                break;
            }
            case 101: {
                ret = 2;
                break;
            }
            case 125: {
                ret = 2;
                break;
            }
            case 131: {
                ret = 2;
                break;
            }
            case 194: {
                ret = 1;
                break;
            }
            case 195: {
                ret = 1;
                break;
            }
            case 197: {
                ret = ((MultiANewArrayInsnNode)this.instruction).dims;
                break;
            }
            case 187: {
                ret = 0;
                break;
            }
            case 188: {
                ret = 1;
                break;
            }
            case 0: {
                ret = 0;
                break;
            }
            case 87: {
                ret = 1;
                break;
            }
            case 88: {
                ret = 2;
                break;
            }
            case 181: {
                ret = 2;
                break;
            }
            case 179: {
                ret = 1;
                break;
            }
            case 169: {
                ret = 0;
                break;
            }
            case 177: {
                ret = 0;
                break;
            }
            case 53: {
                ret = 2;
                break;
            }
            case 86: {
                ret = 3;
                break;
            }
            case 17: {
                ret = 0;
                break;
            }
            case 95: {
                ret = 2;
                break;
            }
            case 170: {
                ret = 1;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unexpected opcode!");
                }
                break;
            }
        }
        return ret;
    }

    public boolean isReturn() {
        int opcode = this.instruction.getOpcode();
        return opcode >= 172 && opcode <= 177;
    }

    public AsmMethodData getMethodData() {
        return this.methodData;
    }

    public static String getKey(TrackedInstruction ti) {
        StringBuffer sb = new StringBuffer();
        sb.append(AsmMethodData.getKey(ti.getMethodData()));
        sb.append(":");
        sb.append(ti.index);
        sb.append(":");
        sb.append(ti.getInstruction().getOpcode());
        return sb.toString();
    }

    static {
        $assertionsDisabled = !TrackedInstruction.class.desiredAssertionStatus();
    }
}

