/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage.analysis;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.coverage.analysis.AsmClassData;
import com.agitar.coverage.analysis.AsmMethodData;
import com.agitar.coverage.analysis.AsmReturnModificationAnalysis;
import com.agitar.coverage.analysis.TrackFieldRequest;
import com.agitar.coverage.analysis.TrackLocalInMethodRequest;
import com.agitar.coverage.analysis.TrackMethodReturnsRequest;
import com.agitar.coverage.analysis.TrackRequest;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.DataflowValue;
import org.objectweb.asm.tree.analysis.Frame;

public class TrackRequestExecutor {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void execute(TrackRequest request, Set executed) {
        String key = request.getKey();
        if (executed.contains(key)) {
            request.setTracked(true);
            return;
        }
        executed.add(key);
        if (request.getType() == 3) {
            TrackMethodReturnsRequest specReq = (TrackMethodReturnsRequest)request;
            if (Modifier.isAbstract(specReq.getMethodData().getFlags())) {
                return;
            }
            AsmReturnModificationAnalysis.getReturnModifications(specReq);
        } else if (request.getType() == 1) {
            TrackRequestExecutor.trackLocal((TrackLocalInMethodRequest)request);
        }
        if (request.getType() == 2) {
            TrackRequestExecutor.trackField((TrackFieldRequest)request);
        }
        request.setTracked(true);
    }

    private static void trackField(TrackFieldRequest request) {
        ArrayList<AsmClassData> classesToSearchIn = new ArrayList<AsmClassData>();
        classesToSearchIn.add(request.getFieldData().getOwnerClassData());
        TrackRequestExecutor.addDependentTargets(classesToSearchIn);
        for (int i = 0; i < classesToSearchIn.size(); ++i) {
            AsmClassData cd = (AsmClassData)classesToSearchIn.get(i);
            List methods = cd.getMethodList();
            for (int j = 0; j < methods.size(); ++j) {
                AsmMethodData md = (AsmMethodData)methods.get(j);
                List instructions = md.getInstructionsList();
                for (int k = 0; k < instructions.size(); ++k) {
                    Object nextInstr = instructions.get(k);
                    if (!(nextInstr instanceof FieldInsnNode)) continue;
                    FieldNode fn = request.getFieldData().getFieldNode();
                    if (!fn.name.equals(((FieldInsnNode)nextInstr).name) || !fn.desc.equals(((FieldInsnNode)nextInstr).desc) || !request.getFieldData().getClassNode().name.equals(((FieldInsnNode)nextInstr).owner)) continue;
                    request.addTrackedInstruction(md.trackInstruction((AbstractInsnNode)((FieldInsnNode)nextInstr), k));
                }
            }
        }
    }

    private static void addDependentTargets(List classesToSearchIn) {
    }

    private static void trackLocal(TrackLocalInMethodRequest request) {
        AsmMethodData md = request.getMethodData();
        if (Modifier.isAbstract(md.getFlags())) {
            return;
        }
        MethodNode methodNode = md.getMethodNode();
        if (!$assertionsDisabled && methodNode == null) {
            throw new AssertionError((Object)"method not should not be null!");
        }
        List instructionsList = md.getInstructionsList();
        int insnCount = instructionsList.size();
        for (int i = 0; i < insnCount; ++i) {
            int methodParamsOnStack;
            if (instructionsList.get(i) instanceof VarInsnNode) {
                AbstractInsnNode ain = (AbstractInsnNode)instructionsList.get(i);
                if (((VarInsnNode)ain).var != request.getVarIndex()) continue;
                request.addTrackedInstruction(md.trackInstruction(ain, i));
                continue;
            }
            if (!(instructionsList.get(i) instanceof MethodInsnNode)) continue;
            Frame[] frames = md.getFrames();
            if (!$assertionsDisabled && frames == null) {
                throw new AssertionError((Object)"frames must not be null!");
            }
            Frame frame = frames[i];
            if (!$assertionsDisabled && frame == null) {
                throw new AssertionError((Object)"frame cannot be null!");
            }
            MethodInsnNode methodInsnNode = (MethodInsnNode)instructionsList.get(i);
            DataflowValue val = null;
            int stackSize = frame.getStackSize();
            int paramCount = Type.getArgumentTypes((String)methodInsnNode.desc).length;
            if (!$assertionsDisabled && stackSize < methodParamsOnStack) {
                throw new AssertionError((Object)"Invalid stack state!");
            }
            int i1 = stackSize - 1;
            for (methodParamsOnStack = paramCount + (methodInsnNode.getOpcode() == 184 ? 0 : 1); methodParamsOnStack > 0; --methodParamsOnStack) {
                Set instrs;
                try {
                    val = (DataflowValue)frame.getStack(i1);
                }
                catch (Throwable t) {
                    AgitarLogger.getDiagnosticLogger().log(Level.INFO, "TrackRequestExecutor-->TrackLocal--->" + t.getMessage(), t);
                }
                if (val != null && (instrs = val.insns) != null) {
                    Iterator iter = instrs.iterator();
                    while (iter.hasNext()) {
                        Object nextInstr = iter.next();
                        if (!$assertionsDisabled && !(nextInstr instanceof AbstractInsnNode)) {
                            throw new AssertionError((Object)"Wrong insn type!");
                        }
                        AbstractInsnNode insnNode = (AbstractInsnNode)nextInstr;
                        if (insnNode == null || !(insnNode instanceof VarInsnNode) || ((VarInsnNode)insnNode).var != request.getVarIndex()) continue;
                        request.addTrackedInstruction(md.trackInstruction((AbstractInsnNode)methodInsnNode, i));
                    }
                }
                --i1;
            }
        }
    }

    static {
        $assertionsDisabled = !TrackRequestExecutor.class.desiredAssertionStatus();
    }
}

