/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage.analysis;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.coverage.analysis.AsmClassCache;
import com.agitar.coverage.analysis.AsmClassData;
import com.agitar.coverage.analysis.AsmClassInstrumenterBase;
import com.agitar.coverage.analysis.AsmConstantData;
import com.agitar.coverage.analysis.OrderedTrackedInstructionsList;
import com.agitar.coverage.analysis.TrackLocalInMethodRequest;
import com.agitar.coverage.analysis.TrackMethodReturnsRequest;
import com.agitar.coverage.analysis.TrackRequestExecutor;
import com.agitar.coverage.analysis.TrackedInstruction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.DataflowInterpreter;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;

public class AsmMethodData {
    private final String declaringClassName;
    private final int flags;
    private final String name;
    private final String desc;
    private final String[] exceptions;
    private List returnInstructions;
    private final MethodNode methodNode;
    private final ClassNode ownerClassNode;
    private final Map trackedVariables = new HashMap();
    private final AsmClassData ownerClassData;
    private final List returnsRequests = new ArrayList();
    private final Map trackedInstructionsMap = new HashMap();
    private final List orderedTrackedInstructionsList = new OrderedTrackedInstructionsList();
    private final Map paramsConstants = new HashMap();
    private Map instructionsToIndex = null;
    private int codeSize;
    private Frame[] frames = null;
    private final Set instrumentedInstructionsSet = new HashSet();
    private final List instrumentedInstructionsList = new ArrayList();
    private int nextAvailVar = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AsmMethodData(String declaringClassName, int access, String name, String desc, List exceptions, MethodNode methodNode, ClassNode classNode, AsmClassData ownerClassData) {
        this.declaringClassName = declaringClassName;
        this.flags = access;
        this.name = name;
        this.desc = desc;
        if (exceptions != null) {
            this.exceptions = new String[exceptions.size()];
            for (int i = 0; i < exceptions.size(); ++i) {
                this.exceptions[i] = exceptions.get(i).toString().replace('/', '.');
            }
        } else {
            this.exceptions = new String[0];
        }
        this.methodNode = methodNode;
        this.ownerClassNode = classNode;
        this.ownerClassData = ownerClassData;
    }

    public static String getKey(String declaringClassName, String name, String desc) {
        return declaringClassName + name + ":" + desc;
    }

    public static String getKey(AsmMethodData methodData) {
        return AsmMethodData.getKey(methodData.getDeclaringClassName(), methodData.getName(), methodData.getDesc());
    }

    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String[] getThrowsExceptions() {
        return this.exceptions;
    }

    public List getInstructionsList() {
        return this.methodNode.instructions;
    }

    public List getReturnsRequests() {
        return this.returnsRequests;
    }

    public List getReturnInstructions(Set executed) {
        if (this.returnInstructions == null) {
            TrackMethodReturnsRequest tmrr = new TrackMethodReturnsRequest(this);
            this.returnInstructions = new ArrayList();
            TrackRequestExecutor.execute(tmrr, executed);
            this.returnInstructions = tmrr.getTrackedInstructions();
            if (this.returnInstructions != null) {
                this.returnsRequests.add(tmrr);
            }
        }
        return this.returnInstructions;
    }

    public ClassNode getClassNode() {
        return this.ownerClassNode;
    }

    public MethodNode getMethodNode() {
        return this.methodNode;
    }

    public boolean isVoidReturn() {
        if (!$assertionsDisabled && this.desc == null) {
            throw new AssertionError((Object)"desc must not be null!");
        }
        if (!$assertionsDisabled && this.name == null) {
            throw new AssertionError((Object)"name must not be null!");
        }
        return this.desc.endsWith(")V") && !this.name.equals("<init>");
    }

    public Frame[] getFrames() {
        if (this.frames == null) {
            DataflowInterpreter dfi = new DataflowInterpreter();
            Analyzer analyzer = new Analyzer((Interpreter)dfi);
            try {
                this.frames = analyzer.analyze(this.ownerClassNode, this.methodNode);
            }
            catch (Throwable t) {
                AgitarLogger.getDiagnosticLogger().log(Level.INFO, "AsmReturnInstruction--->" + t.getMessage(), t);
            }
        }
        return this.frames;
    }

    public void trackLocalVariable(int varIndex, Set ts) {
        if (this.trackedVariables.get(new Integer(varIndex)) == null) {
            TrackLocalInMethodRequest tlim = new TrackLocalInMethodRequest(this, varIndex);
            this.trackedVariables.put(new Integer(varIndex), tlim);
            TrackRequestExecutor.execute(tlim, ts);
        }
    }

    public Map getTrackedVariables() {
        return this.trackedVariables;
    }

    public int getInstructionIndex(AbstractInsnNode instruction) {
        if (this.instructionsToIndex == null) {
            this.instructionsToIndex = new HashMap();
            List instructions = this.getInstructionsList();
            for (int i = 0; i < instructions.size(); ++i) {
                this.instructionsToIndex.put(instructions.get(i), new Integer(i));
            }
        }
        Integer integ = (Integer)this.instructionsToIndex.get(instruction);
        if (!$assertionsDisabled && integ == null) {
            throw new AssertionError((Object)"integ should be always found!");
        }
        return integ;
    }

    public AsmClassData getOwnerClassData() {
        return this.ownerClassData;
    }

    public TrackedInstruction trackInstruction(AbstractInsnNode insnNode, int index) {
        TrackedInstruction ti = (TrackedInstruction)this.trackedInstructionsMap.get(new Integer(index));
        if (ti == null) {
            ti = TrackedInstruction.get(this, insnNode, index);
            this.orderedTrackedInstructionsList.add(ti);
            this.trackedInstructionsMap.put(new Integer(index), ti);
        }
        return ti;
    }

    public List getInstrumentInstructionsList() {
        return this.instrumentedInstructionsList;
    }

    public void addInstrumentInstruction(TrackedInstruction ti) {
        String instructionKey = TrackedInstruction.getKey(ti);
        if (!this.instrumentedInstructionsSet.contains(instructionKey)) {
            this.instrumentedInstructionsSet.add(instructionKey);
            this.instrumentedInstructionsList.add(ti);
        }
    }

    public int getNextAvailableVariable(Type type) {
        if (this.nextAvailVar == -1) {
            this.nextAvailVar = this.methodNode != null ? this.methodNode.maxLocals : 0;
        }
        int ret = this.nextAvailVar;
        this.nextAvailVar += AsmClassInstrumenterBase.getComputationalType(type);
        return ret;
    }

    public void getConstantsForParameter(int depth, int paramIndex, String name2, int currentDepth, Set collected, List result, AsmClassCache classCache) {
        new AsmConstantData(this, this.paramsConstants, depth, paramIndex, name2, currentDepth, collected, result, classCache).getConstantsForParameter();
    }

    public int getCodeSize() {
        return this.codeSize;
    }

    public void setCodeSize(int codeSize) {
        this.codeSize = codeSize;
    }

    static {
        $assertionsDisabled = !AsmMethodData.class.desiredAssertionStatus();
    }
}

