/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage.analysis;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.IOUtility;
import com.agitar.common.util.ReflectionCacheRegistry;
import com.agitar.common.util.StringUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class AsmInstrumenterHelperBase {
    public static final String CLASS_EXTENSION = ".class";

    public static byte[] getBytesForClass(String className, boolean useInstrumented) {
        try {
            URLConnection classUrlConnection = AsmInstrumenterHelperBase.getClassURLConnection(className, useInstrumented);
            if (classUrlConnection != null) {
                return AsmInstrumenterHelperBase.loadBytesFromURL(classUrlConnection);
            }
        }
        catch (Throwable t) {
            AgitarLogger.getDiagnosticLogger().severe("TBEInstrumenterHelper-->" + StringUtility.trace((Throwable)t));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytesFromURL(URLConnection con) throws IOException {
        InputStream in = null;
        try {
            int count;
            in = con.getInputStream();
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((count = in.read(buf)) > 0) {
                bo.write(buf, 0, count);
            }
            byte[] byArray = bo.toByteArray();
            return byArray;
        }
        finally {
            IOUtility.close((InputStream)in, (boolean)false);
        }
    }

    public static URLConnection getClassURLConnection(String className, boolean useInstrumented) throws IOException, ClassNotFoundException {
        String classFileName = className.replace('.', '/') + CLASS_EXTENSION;
        URL url = null;
        url = useInstrumented ? ReflectionCacheRegistry.getContextClassLoader().getResource(classFileName) : ReflectionCacheRegistry.getContextClassLoader().getResource(classFileName);
        if (url == null) {
            AgitarLogger.getUserLogger((String)"TBEInstrumenterHelper-->").info("Could not instrument " + className + " (not in project classpath: " + "no path available" + ")");
            return null;
        }
        return url.openConnection();
    }
}

