/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage.analysis;

import com.agitar.coverage.analysis.AsmClassData;
import com.agitar.coverage.analysis.TrackFieldRequest;
import com.agitar.coverage.analysis.TrackRequestExecutor;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class AsmFieldData {
    private int flags;
    private String name;
    private String desc;
    private Object value;
    private String declaringClassName;
    private FieldNode fieldNode;
    private ClassNode ownerClassNode;
    private AsmClassData ownerClassData;
    private TrackFieldRequest tfr = null;

    public AsmFieldData(String declaringClassName, int access, String name, String desc, Object value, FieldNode fn, ClassNode classNode, AsmClassData ownerClassData) {
        this.declaringClassName = declaringClassName;
        this.flags = access;
        this.name = name;
        this.desc = desc;
        this.value = value;
        this.ownerClassNode = classNode;
        this.ownerClassData = ownerClassData;
        this.fieldNode = fn;
    }

    public static String getKey(String declaringClassName, String name, String desc) {
        return declaringClassName + name + ":" + desc;
    }

    public static String getKey(AsmFieldData fieldData) {
        return AsmFieldData.getKey(fieldData.getDeclaringClassName(), fieldData.getName(), fieldData.getDesc());
    }

    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Object getValue() {
        return this.value;
    }

    public FieldNode getFieldNode() {
        return this.fieldNode;
    }

    public ClassNode getClassNode() {
        return this.ownerClassNode;
    }

    public TrackFieldRequest getTrackFieldRequest(Set trackedSet) {
        if (this.tfr == null) {
            return this.tfr;
        }
        this.trackField(trackedSet);
        return this.tfr;
    }

    private void trackField(Set executed) {
        this.tfr = new TrackFieldRequest(this);
        TrackRequestExecutor.execute(this.tfr, executed);
    }

    public AsmClassData getOwnerClassData() {
        return this.ownerClassData;
    }
}

