/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage.analysis;

import com.agitar.coverage.analysis.AsmClassCache;
import com.agitar.coverage.analysis.AsmClassData;
import com.agitar.coverage.analysis.AsmMethodData;
import com.agitar.coverage.analysis.IntCompOperationIndex;
import com.agitar.coverage.analysis.TrackedInstruction;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class AsmConstantData {
    private final AsmClassCache classCache;
    private final AsmMethodData methodData;
    private final Set collected;
    private final List result;
    private final int depth;
    private final int paramIndex;
    private final String typeName;
    private final int currentDepth;
    private final Map paramsConstants;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AsmConstantData(AsmMethodData methodData, Map paramConstants, int depth, int paramIndex, String typeName, int currentDepth, Set collected, List result, AsmClassCache classCache) {
        this.methodData = methodData;
        this.paramsConstants = paramConstants;
        this.depth = depth;
        this.paramIndex = paramIndex;
        this.typeName = typeName;
        this.currentDepth = currentDepth;
        this.collected = collected;
        this.result = result;
        this.classCache = classCache;
    }

    public void getConstantsForParameter() {
        int flags = this.methodData.getFlags();
        if (Modifier.isAbstract(flags) || Modifier.isNative(flags)) {
            return;
        }
        int indexToLookFor = Modifier.isStatic(flags) ? this.paramIndex : this.paramIndex + 1;
        String paramKey = AsmMethodData.getKey(this.methodData) + indexToLookFor;
        if (this.collected.contains(paramKey)) {
            return;
        }
        this.collected.add(paramKey);
        List paramsConsts = (List)this.paramsConstants.get(paramKey);
        if (paramsConsts != null) {
            this.result.addAll(paramsConsts);
            return;
        }
        ArrayList newConstants = new ArrayList();
        this.paramsConstants.put(paramKey, newConstants);
        List instrList = this.methodData.getInstructionsList();
        if (this.typeName.equals("long")) {
            this.getLongConstants(instrList, indexToLookFor, newConstants);
        } else if (this.typeName.equals("float")) {
            this.getFloatConstants(instrList, indexToLookFor, newConstants);
        } else if (this.typeName.equals("double")) {
            this.getDoubleConstants(instrList, indexToLookFor, newConstants);
        } else {
            this.getIntConstants(instrList, newConstants, indexToLookFor);
        }
        this.result.addAll(newConstants);
    }

    public void getIntConstants(List instrList, List newConstants, int indexToLookFor) {
        for (int i = 0; i < instrList.size(); ++i) {
            Object instr = instrList.get(i);
            if (!(instr instanceof AbstractInsnNode)) continue;
            AbstractInsnNode instrAIN = (AbstractInsnNode)instr;
            IntCompOperationIndex varCompOperation = this.getIntVarComparisonOperation(instrAIN, i);
            if (varCompOperation != null && varCompOperation.varIndex != -1) {
                if (this.typeName.equals("byte")) {
                    newConstants.add(new Byte((byte)varCompOperation.constantValue));
                    continue;
                }
                if (this.typeName.equals("short")) {
                    newConstants.add(new Short((short)varCompOperation.constantValue));
                    continue;
                }
                if (this.typeName.equals("char")) {
                    newConstants.add(new Character((char)varCompOperation.constantValue));
                    continue;
                }
                if (!this.typeName.equals("int")) continue;
                newConstants.add(new Integer(varCompOperation.constantValue));
                continue;
            }
            if (!(instrAIN instanceof MethodInsnNode) || this.depth <= this.currentDepth) continue;
            List operatesOn = TrackedInstruction.get(this.methodData, instrAIN, i).getOperatesOn();
            for (int j = 0; j < operatesOn.size(); ++j) {
                this.collectConstants(operatesOn, j, indexToLookFor, this.classCache, instrAIN, this.depth, this.currentDepth, this.typeName, this.collected, this.result);
            }
        }
    }

    private void getDoubleConstants(List instrList, int indexToLookFor, List newConstants) {
        for (int i = 0; i < instrList.size(); ++i) {
            List operatesOn;
            Object instr = instrList.get(i);
            if (!(instr instanceof AbstractInsnNode)) continue;
            AbstractInsnNode instrAIN = (AbstractInsnNode)instr;
            if (instrAIN.getOpcode() == 151 || instrAIN.getOpcode() == 152) {
                Number constant;
                operatesOn = TrackedInstruction.get(this.methodData, instrAIN, i).getOperatesOn();
                if (!$assertionsDisabled && operatesOn.size() != 2) {
                    throw new AssertionError((Object)"Invalid operatesOn");
                }
                if (!(operatesOn.get(0) instanceof VarInsnNode) || ((VarInsnNode)operatesOn.get((int)0)).var != indexToLookFor || (constant = this.getConstant(operatesOn.get(1))) == null) continue;
                newConstants.add(new Double(constant.doubleValue()));
                continue;
            }
            if (!(instrAIN instanceof MethodInsnNode) || this.depth <= this.currentDepth) continue;
            operatesOn = TrackedInstruction.get(this.methodData, instrAIN, i).getOperatesOn();
            for (int j = 0; j < operatesOn.size(); ++j) {
                this.collectConstants(operatesOn, j, indexToLookFor, this.classCache, instrAIN, this.depth, this.currentDepth, this.typeName, this.collected, this.result);
            }
        }
    }

    private void getFloatConstants(List instrList, int indexToLookFor, List newConstants) {
        for (int i = 0; i < instrList.size(); ++i) {
            List operatesOn;
            Object instr = instrList.get(i);
            if (!(instr instanceof AbstractInsnNode)) continue;
            AbstractInsnNode instrAIN = (AbstractInsnNode)instr;
            if (instrAIN.getOpcode() == 149 || instrAIN.getOpcode() == 150) {
                Number constant;
                operatesOn = TrackedInstruction.get(this.methodData, instrAIN, i).getOperatesOn();
                if (!$assertionsDisabled && operatesOn.size() != 2) {
                    throw new AssertionError((Object)"Invalid operatesOn");
                }
                if (!(operatesOn.get(0) instanceof VarInsnNode) || ((VarInsnNode)operatesOn.get((int)0)).var != indexToLookFor || (constant = this.getConstant(operatesOn.get(1))) == null) continue;
                newConstants.add(new Float(constant.floatValue()));
                continue;
            }
            if (!(instrAIN instanceof MethodInsnNode) || this.depth <= this.currentDepth) continue;
            operatesOn = TrackedInstruction.get(this.methodData, instrAIN, i).getOperatesOn();
            for (int j = 0; j < operatesOn.size(); ++j) {
                this.collectConstants(operatesOn, j, indexToLookFor, this.classCache, instrAIN, this.depth, this.currentDepth, this.typeName, this.collected, this.result);
            }
        }
    }

    private void collectConstants(List operatesOn, int index, int indexToLookFor, AsmClassCache classCache, AbstractInsnNode instrAIN, int depth, int currentDepth, String name2, Set collected, List result) {
        Object node = operatesOn.get(index);
        if (node instanceof VarInsnNode && ((VarInsnNode)node).var == indexToLookFor) {
            AsmMethodData methodData;
            MethodInsnNode methodInsnNode = (MethodInsnNode)instrAIN;
            AsmClassData classData = classCache.getClassDataForClassKey(AsmClassData.getKey(methodInsnNode.owner.replace('/', '.')));
            if (classData != null && (methodData = classData.getMethodDataForMethodKey(AsmMethodData.getKey(classData.getName(), methodInsnNode.name, methodInsnNode.desc))) != null) {
                methodData.getConstantsForParameter(depth, index - 1, name2, currentDepth + 1, collected, result, classCache);
            }
        }
    }

    private void getLongConstants(List instrList, int indexToLookFor, List newConstants) {
        for (int i = 0; i < instrList.size(); ++i) {
            List operatesOn;
            Object instr = instrList.get(i);
            if (!(instr instanceof AbstractInsnNode)) continue;
            AbstractInsnNode instrAIN = (AbstractInsnNode)instr;
            if (instrAIN.getOpcode() == 148) {
                Number constant;
                operatesOn = TrackedInstruction.get(this.methodData, instrAIN, i).getOperatesOn();
                if (!$assertionsDisabled && operatesOn.size() != 2) {
                    throw new AssertionError((Object)"Invalid operatesOn");
                }
                if (!(operatesOn.get(0) instanceof VarInsnNode) || ((VarInsnNode)operatesOn.get((int)0)).var != indexToLookFor || (constant = this.getConstant(operatesOn.get(1))) == null) continue;
                newConstants.add(new Long(constant.longValue()));
                continue;
            }
            if (!(instrAIN instanceof MethodInsnNode) || this.depth <= this.currentDepth) continue;
            operatesOn = TrackedInstruction.get(this.methodData, instrAIN, i).getOperatesOn();
            for (int j = 0; j < operatesOn.size(); ++j) {
                this.collectConstants(operatesOn, j, indexToLookFor, this.classCache, instrAIN, this.depth, this.currentDepth, this.typeName, this.collected, this.result);
            }
        }
    }

    private IntCompOperationIndex getIntVarComparisonOperation(AbstractInsnNode instrAIN, int i) {
        IntCompOperationIndex ret = new IntCompOperationIndex();
        switch (instrAIN.getOpcode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                List operatesOn = TrackedInstruction.get(this.methodData, instrAIN, i).getOperatesOn();
                if (!$assertionsDisabled && operatesOn.size() != 1) {
                    throw new AssertionError((Object)"Illegal operatesOn list size!");
                }
                if (!(operatesOn.get(0) instanceof AbstractInsnNode)) {
                    return ret;
                }
                AbstractInsnNode op = (AbstractInsnNode)operatesOn.get(0);
                if (!(op instanceof VarInsnNode)) break;
                ret.varIndex = ((VarInsnNode)op).var;
                ret.constantValue = 0;
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                List operatesOn1 = TrackedInstruction.get(this.methodData, instrAIN, i).getOperatesOn();
                if (!$assertionsDisabled && operatesOn1.size() != 2) {
                    throw new AssertionError((Object)"Illegal operatesOn1 list size!");
                }
                if (!(operatesOn1.get(0) instanceof AbstractInsnNode)) {
                    return ret;
                }
                AbstractInsnNode op1 = (AbstractInsnNode)operatesOn1.get(0);
                if (!(op1 instanceof VarInsnNode)) break;
                ret.varIndex = ((VarInsnNode)op1).var;
                Number num = this.getConstant(operatesOn1.get(1));
                if (num == null) {
                    ret.varIndex = -1;
                    ret.constantValue = -1;
                    break;
                }
                ret.constantValue = num.intValue();
                break;
            }
            default: {
                ret.varIndex = -1;
                ret.constantValue = -1;
            }
        }
        return ret;
    }

    public Number getConstant(Object operation) {
        Number ret = null;
        if (operation instanceof AbstractInsnNode) {
            AbstractInsnNode op = (AbstractInsnNode)operation;
            if (op.getOpcode() >= 18 && op.getOpcode() < 21) {
                if (((LdcInsnNode)operation).cst instanceof Number) {
                    ret = (Number)((LdcInsnNode)operation).cst;
                }
            } else if (op.getOpcode() >= 16 && op.getOpcode() <= 17) {
                ret = new Integer(((IntInsnNode)operation).operand);
            } else {
                switch (op.getOpcode()) {
                    case 2: {
                        ret = new Integer(-1);
                        break;
                    }
                    case 3: {
                        ret = new Integer(0);
                        break;
                    }
                    case 4: {
                        ret = new Integer(1);
                        break;
                    }
                    case 5: {
                        ret = new Integer(2);
                        break;
                    }
                    case 6: {
                        ret = new Integer(3);
                        break;
                    }
                    case 7: {
                        ret = new Integer(4);
                        break;
                    }
                    case 8: {
                        ret = new Integer(5);
                        break;
                    }
                    case 9: {
                        ret = new Long(0L);
                        break;
                    }
                    case 10: {
                        ret = new Long(1L);
                        break;
                    }
                    case 11: {
                        ret = new Float(0.0f);
                        break;
                    }
                    case 12: {
                        ret = new Float(1.0f);
                        break;
                    }
                    case 13: {
                        ret = new Float(2.0f);
                        break;
                    }
                    case 14: {
                        ret = new Double(0.0);
                        break;
                    }
                    case 15: {
                        ret = new Double(1.0);
                        break;
                    }
                }
            }
            return ret;
        }
        return ret;
    }

    static {
        $assertionsDisabled = !AsmConstantData.class.desiredAssertionStatus();
    }
}

