/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage.analysis;

import com.agitar.coverage.analysis.AsmFieldData;
import com.agitar.coverage.analysis.AsmInstrumenterHelperBase;
import com.agitar.coverage.analysis.AsmMethodData;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class AsmClassData {
    private final int version;
    private final int flags;
    private final String name;
    private final String superName;
    private final String[] interfaces;
    private final String sourceName;
    private final ClassNode classNode;
    private SoftReference bytes;
    private final List methodList = new ArrayList();
    private final Map methodKey2MethodDataMap = new HashMap();
    private final List fieldList = new ArrayList();
    private final Map fieldKey2FieldDataMap = new HashMap();
    private final Set instrumentedMethodsSet = new HashSet();
    private final List instrumentedMethodsList = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String getKey(String name) {
        return name.replace('/', '.');
    }

    public static String getKey(AsmClassData classData) {
        return AsmClassData.getKey(classData.getName());
    }

    public AsmClassData(int version, int access, String name, String superName, List interfaces, String sourceFile, ClassNode classNode, byte[] bytes) {
        this.version = version;
        this.flags = access;
        this.name = name.replace('/', '.');
        if (superName != null) {
            this.superName = superName.replace('/', '.');
        } else {
            if (!$assertionsDisabled && !this.name.equals("java.lang.Object")) {
                throw new AssertionError((Object)"Invalid state!!!");
            }
            this.superName = null;
        }
        this.interfaces = new String[interfaces == null ? 0 : interfaces.size()];
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.interfaces[i] = interfaces.get(i).toString().replace('/', '.');
        }
        this.sourceName = sourceFile;
        this.classNode = classNode;
        this.bytes = new SoftReference<byte[]>(bytes);
    }

    public void addMethodData(AsmMethodData methodData) {
        Object md = this.methodKey2MethodDataMap.get(AsmMethodData.getKey(methodData));
        if (md == null) {
            this.methodList.add(methodData);
            this.methodKey2MethodDataMap.put(AsmMethodData.getKey(methodData), methodData);
        }
    }

    public AsmFieldData addFieldData(AsmFieldData fieldData) {
        AsmFieldData fd = (AsmFieldData)this.fieldKey2FieldDataMap.get(AsmFieldData.getKey(fieldData));
        if (fd == null) {
            this.fieldList.add(fieldData);
            this.fieldKey2FieldDataMap.put(AsmFieldData.getKey(fieldData), fieldData);
            return fieldData;
        }
        return fd;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getSuperName() {
        return this.superName;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public AsmFieldData getFieldDataForFieldKey(String key) {
        this.fillFields();
        return (AsmFieldData)this.fieldKey2FieldDataMap.get(key);
    }

    private void fillFields() {
        for (int i = 0; i < this.classNode.fields.size(); ++i) {
            FieldNode fn = (FieldNode)this.classNode.fields.get(i);
            if (fn == null) continue;
            this.addFieldData(new AsmFieldData(this.name, fn.access, fn.name, fn.desc, fn.value, fn, this.classNode, this));
        }
    }

    public AsmMethodData getMethodDataForMethodKey(String key) {
        this.fillMethods();
        return (AsmMethodData)this.methodKey2MethodDataMap.get(key);
    }

    public void fillMethods() {
        if (this.methodList.isEmpty()) {
            for (int i = 0; i < this.classNode.methods.size(); ++i) {
                MethodNode mn = (MethodNode)this.classNode.methods.get(i);
                if (mn == null) continue;
                this.addMethodData(new AsmMethodData(this.name, mn.access, mn.name, mn.desc, mn.exceptions, mn, this.classNode, this));
            }
        }
    }

    public List getMethodList() {
        return this.methodList;
    }

    public List getInstrumentMethodsList() {
        return this.instrumentedMethodsList;
    }

    public boolean getInstrumentMethod(AsmMethodData md) {
        return this.instrumentedMethodsSet.contains(AsmMethodData.getKey(md));
    }

    public void addMethodToInstrument(AsmMethodData md) {
        if (!$assertionsDisabled && md == null) {
            throw new AssertionError((Object)"MD must not be null!");
        }
        String methodKey = AsmMethodData.getKey(md);
        if (!this.instrumentedMethodsSet.contains(methodKey)) {
            this.instrumentedMethodsSet.add(methodKey);
            this.instrumentedMethodsList.add(md);
        }
    }

    public void setBytes(byte[] bytes) {
        if (this.bytes.get() == null) {
            this.bytes = new SoftReference<byte[]>(bytes);
        }
    }

    public byte[] getBytes(boolean useInstrumented) {
        byte[] bytes = (byte[])this.bytes.get();
        if (bytes == null) {
            bytes = AsmInstrumenterHelperBase.getBytesForClass(this.getName(), useInstrumented);
            if (!$assertionsDisabled && bytes == null) {
                throw new AssertionError((Object)"Class bytes must not be null!");
            }
            this.setBytes(bytes);
        }
        return bytes;
    }

    static {
        $assertionsDisabled = !AsmClassData.class.desiredAssertionStatus();
    }
}

