/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage.analysis;

import com.agitar.common.asm.GettersAndSetters;
import com.agitar.common.asm.SimpleGetterSetterDetector;
import com.agitar.coverage.analysis.AsmClassData;
import com.agitar.coverage.analysis.AsmMethodData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.TreeClassAdapter;

public class AsmClassCache {
    private final Map classKey2ClassDataMap = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void parseClass(byte[] classBytes) {
        if (!$assertionsDisabled && classBytes == null) {
            throw new AssertionError((Object)"classBytes must be a valid class file.");
        }
        ClassReader cr = new ClassReader(classBytes);
        TreeClassAdapter tca = new TreeClassAdapter(null);
        cr.accept((ClassVisitor)new SimpleGetterSetterDetector((ClassVisitor)tca, GettersAndSetters.getInstance()), false);
        AsmClassData cd = new AsmClassData(tca.classNode.version, tca.classNode.access, tca.classNode.name, tca.classNode.superName, tca.classNode.interfaces, tca.classNode.sourceFile, tca.classNode, classBytes);
        this.addClassData(cd);
    }

    private void addClassData(AsmClassData cd) {
        if (!$assertionsDisabled && cd == null) {
            throw new AssertionError((Object)"cd should not be null");
        }
        AsmClassData oldClassData = this.classKey2ClassDataMap.put(AsmClassData.getKey(cd), cd);
        if (oldClassData != null) {
            cd.fillMethods();
            List oldMethods = oldClassData.getMethodList();
            Iterator iterator = oldMethods.iterator();
            while (iterator.hasNext()) {
                AsmMethodData oldMethodData = (AsmMethodData)iterator.next();
                AsmMethodData newMethodData = cd.getMethodDataForMethodKey(AsmMethodData.getKey(oldMethodData));
                if (newMethodData == null) continue;
                newMethodData.setCodeSize(oldMethodData.getCodeSize());
            }
        }
    }

    public AsmClassData getClassDataForClassKey(String key) {
        return (AsmClassData)this.classKey2ClassDataMap.get(key);
    }

    static {
        $assertionsDisabled = !AsmClassCache.class.desiredAssertionStatus();
    }
}

