/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.CoveragePoint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SourceLine {
    private String source;
    private List coveragePoints = Collections.EMPTY_LIST;
    private Set methods = Collections.EMPTY_SET;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SourceLine(String source) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(CoveragePoint point) {
        if (point != null) {
            SourceLine sourceLine = this;
            synchronized (sourceLine) {
                if (this.coveragePoints == Collections.EMPTY_LIST) {
                    this.coveragePoints = new ArrayList();
                }
                this.coveragePoints.add(point);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethod(String methodKey) {
        if (methodKey != null) {
            SourceLine sourceLine = this;
            synchronized (sourceLine) {
                if (this.methods == Collections.EMPTY_SET) {
                    this.methods = new HashSet();
                }
                this.methods.add(methodKey);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public String getSource() {
        return this.source;
    }

    public List getCoveragePoints() {
        return this.coveragePoints;
    }

    public synchronized void clearPoints() {
        this.coveragePoints.clear();
    }

    public synchronized void postProcess(SourceLine next) {
        char and = '&';
        char or = '|';
        String trimmed = this.source.trim();
        if (trimmed.startsWith("assert") && trimmed.length() >= 7 && !Character.isJavaIdentifierPart(trimmed.charAt(6))) {
            for (int i = 0; i < this.coveragePoints.size(); ++i) {
                this.reverseCondition(i);
            }
            and = '|';
            or = '&';
        }
        int condition = 0;
        if (this.coveragePoints.size() >= 2) {
            char[] ca = this.source.trim().toCharArray();
            for (int j = 2; j < ca.length; ++j) {
                if (ca[j] == and && ca[j - 1] == and) {
                    ++condition;
                    continue;
                }
                if (ca[j] != or || ca[j - 1] != or) continue;
                this.reverseCondition(condition);
                ++condition;
            }
            if (next.source.trim().startsWith("" + or + or)) {
                this.reverseCondition(condition);
            }
        }
    }

    private synchronized void reverseCondition(int condition) {
        CoveragePoint truePoint = null;
        CoveragePoint falsePoint = null;
        int trueCount = 0;
        int falseCount = 0;
        Iterator iterator = this.coveragePoints.iterator();
        while (iterator.hasNext()) {
            CoveragePoint point = (CoveragePoint)iterator.next();
            if (point.getType() == 2 && trueCount <= condition) {
                ++trueCount;
                truePoint = point;
            } else if (point.getType() == 1 && falseCount <= condition) {
                ++falseCount;
                falsePoint = point;
            }
            if (trueCount != condition + 1 || falseCount != condition + 1) continue;
            int tmp = truePoint.getTimesReached();
            truePoint.setTimesReached(falsePoint.getTimesReached());
            falsePoint.setTimesReached(tmp);
        }
    }

    public synchronized String getCounterText() {
        if (!this.coveragePoints.isEmpty()) {
            int total = SourceLine.sumLine(this.coveragePoints);
            StringBuffer buf = new StringBuffer();
            if (this.coveragePoints.size() > 1) {
                int conditions = 0;
                int coveredConditions = 0;
                Iterator iterator = this.coveragePoints.iterator();
                while (iterator.hasNext()) {
                    CoveragePoint point = (CoveragePoint)iterator.next();
                    switch (point.getType()) {
                        case 1: 
                        case 2: {
                            ++conditions;
                            if (point.getTimesReached() <= 0) break;
                            ++coveredConditions;
                        }
                    }
                }
                if (conditions > 0) {
                    buf.append(coveredConditions).append('/').append(conditions).append(' ');
                }
            }
            buf.append(total == Integer.MAX_VALUE ? "MAX" : String.valueOf(total)).append('x');
            return buf.toString();
        }
        return "";
    }

    private static int sumLine(List points) {
        if (points.size() == 0) {
            return 0;
        }
        if (points.size() == 1) {
            CoveragePoint point = (CoveragePoint)points.get(0);
            return point.getTimesReached();
        }
        int tfTotal = 0;
        int max = 0;
        Iterator iterator = points.iterator();
        boolean t = false;
        boolean f = false;
        while (iterator.hasNext()) {
            CoveragePoint point = (CoveragePoint)iterator.next();
            switch (point.getType()) {
                case 1: {
                    tfTotal += point.getTimesReached();
                    f = true;
                    break;
                }
                case 2: {
                    tfTotal += point.getTimesReached();
                    t = true;
                    break;
                }
            }
            max = Math.max(max, point.getTimesReached());
            if (!t || !f) continue;
            max = Math.max(max, tfTotal);
            t = false;
            f = false;
            tfTotal = 0;
        }
        return max;
    }

    public static void mergeWithCoverage(ClassCoverage coverage, SourceLine[] classSource) {
        if (coverage == null || coverage.getPoints() == null) {
            return;
        }
        Iterator pointIter = coverage.getPoints().iterator();
        while (pointIter.hasNext()) {
            CoveragePoint point = (CoveragePoint)pointIter.next();
            int ln = point.getLineNumber() - 1;
            if (ln < 0 || ln >= classSource.length) continue;
            classSource[ln].addPoint(point);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SourceLine[] getSourceLines(File sourceFile, Charset cs) throws IOException {
        SourceLine[] sourceLineArray;
        InputStreamReader istr;
        block5: {
            ArrayList<SourceLine> lines = new ArrayList<SourceLine>();
            istr = null;
            BufferedReader reader = null;
            try {
                istr = cs == null ? new InputStreamReader(new FileInputStream(sourceFile)) : new InputStreamReader((InputStream)new FileInputStream(sourceFile), cs);
                reader = new BufferedReader(istr);
                String line = reader.readLine();
                while (line != null) {
                    lines.add(new SourceLine(line));
                    line = reader.readLine();
                }
                sourceLineArray = lines.toArray(new SourceLine[lines.size()]);
                Object var8_7 = null;
                if (reader == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (reader != null) {
                        reader.close();
                    }
                    if (istr == null) break block6;
                    istr.close();
                }
                throw throwable;
            }
            reader.close();
        }
        if (istr != null) {
            istr.close();
        }
        return sourceLineArray;
    }

    static {
        $assertionsDisabled = !SourceLine.class.desiredAssertionStatus();
    }
}

