/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.common.asm.AbstractClassInstrumenter;
import com.agitar.common.util.AgitarProperties;
import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.CoveragePoint;
import com.agitar.coverage.LineConditionCodeVisitor;
import com.agitar.coverage.analysis.AsmClassData;
import com.agitar.coverage.analysis.AsmMethodData;
import java.lang.reflect.Modifier;
import java.util.List;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;

public class LineConditionInstrumenter2
extends AbstractClassInstrumenter {
    private final ClassCoverage cvg;
    private final AsmClassData classData;
    private int methodNumber;

    public LineConditionInstrumenter2(ClassCoverage cvg, AsmClassData classData) {
        this.cvg = cvg;
        this.classData = classData;
    }

    public void visitEnd() {
        super.visitEnd();
        this.fillInLineNumbers();
        this.methodNumber = 0;
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        Object next = super.visitMethod(access, name, desc, exceptions, attrs);
        if (this.isInstrumentable(access, name)) {
            int coverageLocal = AgitarProperties.BREAKPOINTFILE_IS_SET ? -1 : this.countArgs(access, desc);
            AsmMethodData methodData = this.classData.getMethodDataForMethodKey(AsmMethodData.getKey(this.getDottedClassName(), name, desc));
            next = new LineConditionCodeVisitor(this.cvg, this.methodNumber, coverageLocal, (CodeVisitor)next, methodData);
            ++this.methodNumber;
        }
        return next;
    }

    private int countArgs(int access, String desc) {
        int argCount = Modifier.isStatic(access) ? 0 : 1;
        Type[] argumentTypes = Type.getArgumentTypes((String)desc);
        for (int i = 0; i < argumentTypes.length; ++i) {
            argCount += argumentTypes[i].getSize();
        }
        return argCount;
    }

    private void fillInLineNumbers() {
        List points = this.cvg.getRawPoints();
        CoveragePoint[] aPoints = points.toArray(new CoveragePoint[points.size()]);
        int lineNumber = 0;
        for (int i = 0; i < aPoints.length; ++i) {
            CoveragePoint point = aPoints[i];
            int pointLine = point.getLineNumber();
            if (pointLine != 0) {
                lineNumber = pointLine;
                continue;
            }
            point.setLineNumber(lineNumber);
        }
    }
}

