/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.common.asm.AsmUtil;
import com.agitar.common.asm.CodeInstrumenter;
import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.CoveragePoint;
import com.agitar.coverage.analysis.AsmMethodData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.CodeWriter;
import org.objectweb.asm.Label;

class LineConditionCodeVisitor
extends CodeInstrumenter {
    private int bang = 0;
    private IndexedPoint bangTrue;
    private IndexedPoint bangFalse;
    private final Map labelToPoint = new HashMap();
    private int instructionNumber;
    private int ignoreNextIf = 0;
    private boolean ignoreNextLine;
    private boolean cmpIf;
    private Label labelToMark;
    private final List visitedLabels = new ArrayList();
    private final List targetedLabels = new ArrayList();
    private final List ignoredLabels = new ArrayList();
    private final ClassCoverage classCoverage;
    private final int methodNumber;
    private final AsmMethodData methodData;
    private final int coverageLocal;
    private final Label beginMethod = new Label();
    private final Label endMethod = new Label();
    private static final int BANG_START = 0;
    private static final int BANG_NE_IFNE = 1;
    private static final int BANG_NE_ICONST1 = 2;
    private static final int BANG_NE_GOTO = 3;
    private static final int BANG_EQ_IFEQ = 4;
    private static final int BANG_EQ_ICONST0 = 5;
    private static final int BANG_EQ_GOTO = 6;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected LineConditionCodeVisitor(ClassCoverage classCoverage, int methodNumber, int coverageLocal, CodeVisitor next, AsmMethodData methodData) {
        super(next);
        this.classCoverage = classCoverage;
        this.methodNumber = methodNumber;
        this.coverageLocal = coverageLocal;
        this.methodData = methodData;
        super.visitLabel(this.beginMethod);
        if (coverageLocal >= 0) {
            this.getNext().visitMethodInsn(184, classCoverage.getClassName().replace('.', '/'), "$agitar_inc", "()[I");
            this.getNext().visitVarInsn(58, coverageLocal);
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.targetedLabels.add(handler);
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitInsn(int opcode) {
        this.markIfLabeled();
        this.watchForBang(opcode);
        if (opcode >= 148 && opcode <= 152) {
            this.ignoreNextIf = 0;
            this.bangFalse = this.getPoint(new Label());
            this.bangFalse.point.setType(1);
            this.mark(this.bangFalse);
            this.cmpIf = true;
        }
        if (opcode >= 172 && opcode <= 177) {
            this.ignoreNextLine = true;
        }
        super.visitInsn(opcode);
        ++this.instructionNumber;
    }

    public void visitIntInsn(int opcode, int operand) {
        this.markIfLabeled();
        this.watchForBang(opcode);
        super.visitIntInsn(opcode, operand);
        ++this.instructionNumber;
    }

    public void visitVarInsn(int opcode, int var) {
        this.markIfLabeled();
        this.watchForBang(opcode);
        super.visitVarInsn(opcode, this.adjustIndex(var));
        ++this.instructionNumber;
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.markIfLabeled();
        this.watchForBang(opcode);
        super.visitTypeInsn(opcode, desc);
        ++this.instructionNumber;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.markIfLabeled();
        this.watchForBang(opcode);
        super.visitFieldInsn(opcode, owner, name, desc);
        if (opcode == 178 && name.startsWith("class$")) {
            this.ignoreNextIf = 199;
        } else if (opcode == 178 && name.equals("$assertionsDisabled")) {
            this.ignoreNextIf = 154;
        }
        ++this.instructionNumber;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.markIfLabeled();
        this.watchForBang(opcode);
        super.visitMethodInsn(opcode, owner, name, desc);
        ++this.instructionNumber;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.markIfLabeled();
        this.targetedLabels.add(dflt);
        for (int i = 0; i < labels.length; ++i) {
            this.targetedLabels.add(labels[i]);
        }
        this.watchForBang(171);
        super.visitLookupSwitchInsn(dflt, keys, labels);
        ++this.instructionNumber;
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.markIfLabeled();
        this.watchForBang(197);
        super.visitMultiANewArrayInsn(desc, dims);
        ++this.instructionNumber;
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.markIfLabeled();
        this.targetedLabels.add(dflt);
        for (int i = 0; i < labels.length; ++i) {
            this.targetedLabels.add(labels[i]);
        }
        this.watchForBang(170);
        super.visitTableSwitchInsn(min, max, dflt, labels);
        ++this.instructionNumber;
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.watchForBang(opcode);
        this.markIfLabeled();
        this.targetedLabels.add(label);
        if (opcode == 168) {
            super.visitJumpInsn(opcode, label);
        } else if (opcode == 167) {
            this.ignoreNextLine = true;
            super.visitJumpInsn(opcode, label);
        } else if (opcode == this.ignoreNextIf) {
            this.ignoreNextIf = 0;
            super.visitJumpInsn(opcode, label);
        } else {
            boolean loop = this.visitedLabels.contains(label);
            if (!this.cmpIf) {
                this.ignoreNextIf = 0;
                this.bangFalse = this.getPoint(new Label());
                this.bangFalse.point.setType(loop ? 2 : 1);
                this.mark(this.bangFalse);
            }
            super.visitJumpInsn(opcode, label);
            this.bangTrue = this.getPoint(new Label());
            this.bangTrue.point.setType(loop ? 1 : 2);
            this.mark(this.bangTrue);
        }
        ++this.instructionNumber;
        this.cmpIf = false;
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        if (this.ignoreNextLine) {
            this.ignoredLabels.add(label);
            this.ignoreNextLine = false;
        }
        this.labelToMark = label;
        this.visitedLabels.add(label);
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        super.visitLocalVariable(name, desc, start, end, this.adjustIndex(index));
    }

    private int adjustIndex(int index) {
        return this.coverageLocal < 0 || index < this.coverageLocal ? index : index + 1;
    }

    public void visitLdcInsn(Object cst) {
        this.watchForBang(18);
        this.markIfLabeled();
        super.visitLdcInsn(cst);
        ++this.instructionNumber;
    }

    public void visitIincInsn(int var, int increment) {
        this.watchForBang(132);
        this.markIfLabeled();
        super.visitIincInsn(this.adjustIndex(var), increment);
        ++this.instructionNumber;
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        IndexedPoint ipoint = (IndexedPoint)this.labelToPoint.get(start);
        if (ipoint != null) {
            CoveragePoint point = ipoint.point;
            point.setType(0);
            point.setLineNumber(line);
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitLabel(this.endMethod);
        if (this.coverageLocal >= 0) {
            super.visitLocalVariable("$agitar_cvg", "[I", this.beginMethod, this.endMethod, this.coverageLocal);
        }
        super.visitMaxs(maxStack, this.coverageLocal < 0 ? maxLocals : maxLocals + 1);
        this.ignoredLabels.removeAll(this.targetedLabels);
        Iterator iter = this.ignoredLabels.iterator();
        while (iter.hasNext()) {
            Label label = (Label)iter.next();
            IndexedPoint ipoint = (IndexedPoint)this.labelToPoint.get(label);
            if (ipoint == null) continue;
            ipoint.point.setType(-1);
        }
        this.ignoreNextLine = false;
        this.instructionNumber = 0;
        this.labelToPoint.clear();
        if (this.getNext() instanceof CodeWriter && this.methodData != null) {
            CodeWriter cw = (CodeWriter)this.getNext();
            this.methodData.setCodeSize(cw.getCodeSize());
        }
    }

    private void markIfLabeled() {
        this.ignoreNextLine = false;
        if (this.labelToMark != null) {
            this.mark(this.getPoint(this.labelToMark));
            this.labelToMark = null;
        }
    }

    private void watchForBang(int opcode) {
        switch (this.bang) {
            case 0: {
                if (opcode == 154) {
                    this.bang = 1;
                    break;
                }
                if (opcode != 153) break;
                this.bang = 4;
                break;
            }
            case 1: {
                if (opcode == 4) {
                    this.bang = 2;
                    break;
                }
                this.bang = 0;
                break;
            }
            case 2: {
                if (opcode == 167) {
                    this.bang = 3;
                    break;
                }
                this.bang = 0;
                break;
            }
            case 3: {
                if (opcode == 3) {
                    this.bangTrue.point.setType(-1);
                    this.bangFalse.point.setType(-1);
                }
                this.bang = 0;
                break;
            }
            case 4: {
                if (opcode == 3) {
                    this.bang = 5;
                    break;
                }
                this.bang = 0;
                break;
            }
            case 5: {
                if (opcode == 167) {
                    this.bang = 6;
                    break;
                }
                this.bang = 0;
                break;
            }
            case 6: {
                if (opcode == 4) {
                    this.bangTrue.point.setType(-1);
                    this.bangFalse.point.setType(-1);
                }
                this.bang = 0;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    private void mark(IndexedPoint ipoint) {
        if (this.coverageLocal >= 0) {
            this.getNext().visitVarInsn(25, this.coverageLocal);
        } else {
            this.getNext().visitMethodInsn(184, this.classCoverage.getClassName().replace('.', '/'), "$agitar_inc", "()[I");
        }
        AsmUtil.visitShortestInt((CodeVisitor)this.getNext(), (int)ipoint.index);
        this.getNext().visitMethodInsn(184, "com/agitar/coverage/CoverageManager", "increment", "([II)V");
    }

    private IndexedPoint getPoint(Label label) {
        IndexedPoint ipoint = (IndexedPoint)this.labelToPoint.get(label);
        if (ipoint == null) {
            CoveragePoint point = new CoveragePoint();
            point.setMethodNumber(this.methodNumber);
            point.setByteOffset(this.instructionNumber);
            ipoint = new IndexedPoint(this.classCoverage.getRawPoints().size(), point);
            this.labelToPoint.put(label, ipoint);
            this.classCoverage.addPoint(point);
        }
        return ipoint;
    }

    static {
        $assertionsDisabled = !LineConditionCodeVisitor.class.desiredAssertionStatus();
    }

    private static class IndexedPoint {
        public final int index;
        public final CoveragePoint point;

        public IndexedPoint(int index, CoveragePoint point) {
            this.index = index;
            this.point = point;
        }
    }
}

