/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.common.asm.AbstractClassInstrumenter;
import com.agitar.common.asm.CodeInstrumenter;
import com.agitar.coverage.InterposeMethodGenerator;
import com.agitar.coverage.SynthMethodData;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class InterposingInstrumenter
extends AbstractClassInstrumenter {
    private final Set testClasses;
    private final Set targetClasses;
    private final Set synthMethods = new HashSet();

    public InterposingInstrumenter(Set testClasses, Set targetClasses) {
        this.testClasses = testClasses;
        this.targetClasses = targetClasses;
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        if (this.testClasses.contains(this.getDottedClassName()) && this.isInstrumentable(access, name)) {
            return new MyCodeVisitor(super.visitMethod(access, name, desc, exceptions, attrs));
        }
        return super.visitMethod(access, name, desc, exceptions, attrs);
    }

    public void visitEnd() {
        Iterator iterator = this.synthMethods.iterator();
        while (iterator.hasNext()) {
            SynthMethodData synthMethod = (SynthMethodData)iterator.next();
            CodeVisitor visitor = super.visitMethod(10, synthMethod.getSynthMethodName(), synthMethod.getSynthMethodDesc(), null, null);
            new InterposeMethodGenerator().generate(visitor, synthMethod.getTargetClass(), synthMethod.getTargetMethod(), synthMethod.getTargetDesc(), synthMethod.getSynthMethodDesc());
        }
        this.synthMethods.clear();
        super.visitEnd();
    }

    private class MyCodeVisitor
    extends CodeInstrumenter {
        private int newsOnStack;
        private int lastOpcode;
        private boolean eatDup;
        private int popConstructor;

        protected MyCodeVisitor(CodeVisitor next) {
            super(next);
        }

        public void visitIntInsn(int opcode, int operand) {
            super.visitIntInsn(opcode, operand);
            this.setLastOpcode(opcode);
        }

        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            this.setLastOpcode(opcode);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            super.visitFieldInsn(opcode, owner, name, desc);
            this.setLastOpcode(opcode);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            this.setLastOpcode(opcode);
        }

        public void visitLdcInsn(Object cst) {
            super.visitLdcInsn(cst);
            this.setLastOpcode(18);
        }

        public void visitIincInsn(int var, int increment) {
            super.visitIincInsn(var, increment);
            this.setLastOpcode(132);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            super.visitTableSwitchInsn(min, max, dflt, labels);
            this.setLastOpcode(170);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            super.visitLookupSwitchInsn(dflt, keys, labels);
            this.setLastOpcode(171);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            super.visitMultiANewArrayInsn(desc, dims);
            this.setLastOpcode(197);
        }

        public void visitInsn(int opcode) {
            if (opcode != 89 || this.lastOpcode != 187 || !this.eatDup) {
                super.visitInsn(opcode);
            }
            this.setLastOpcode(opcode);
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (opcode == 187 && InterposingInstrumenter.this.targetClasses.contains(desc.replace('/', '.'))) {
                ++this.newsOnStack;
                this.setLastOpcode(opcode);
                this.eatDup = true;
            } else {
                super.visitTypeInsn(opcode, desc);
                this.setLastOpcode(opcode);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (InterposingInstrumenter.this.targetClasses.contains(owner.replace('/', '.'))) {
                if (opcode == 183 && this.newsOnStack > 0) {
                    --this.newsOnStack;
                    this.interpose(owner, name, desc, false);
                    if (this.lastOpcode == 187) {
                        super.visitInsn(87);
                    }
                } else if (opcode != 183) {
                    this.interpose(owner, name, desc, opcode != 184);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc);
                }
            } else {
                super.visitMethodInsn(opcode, owner, name, desc);
            }
            this.setLastOpcode(opcode);
        }

        private void interpose(String owner, String name, String desc, boolean needsThis) {
            Type returnType;
            String synthMethName;
            boolean isConstructor = "<init>".equals(name);
            if (isConstructor) {
                synthMethName = "catTwoSynth$" + owner.replace('/', '_');
                returnType = Type.getType((String)('L' + owner + ';'));
            } else {
                synthMethName = "catTwoSynth$" + owner.replace('/', '_') + '_' + name;
                returnType = Type.getReturnType((String)desc);
            }
            Type[] argTypes = this.getSynthMethodArgTypes(owner, desc, needsThis);
            String synthMethDesc = Type.getMethodDescriptor((Type)returnType, (Type[])argTypes);
            super.visitMethodInsn(184, InterposingInstrumenter.this.getSlashedClassName(), synthMethName, synthMethDesc);
            if (this.popConstructor > 0 && isConstructor) {
                super.visitInsn(87);
                --this.popConstructor;
            }
            SynthMethodData data = new SynthMethodData();
            data.setSynthMethodName(synthMethName);
            data.setSynthMethodDesc(synthMethDesc);
            data.setTargetClass(owner);
            data.setTargetMethod(name);
            data.setTargetDesc(desc);
            InterposingInstrumenter.this.synthMethods.add(data);
        }

        private Type[] getSynthMethodArgTypes(String owner, String desc, boolean needsThis) {
            Type[] argTypes;
            if (needsThis) {
                Type[] origArgTypes = Type.getArgumentTypes((String)desc);
                argTypes = new Type[origArgTypes.length + 1];
                argTypes[0] = Type.getType((String)('L' + owner + ';'));
                System.arraycopy(origArgTypes, 0, argTypes, 1, origArgTypes.length);
            } else {
                argTypes = Type.getArgumentTypes((String)desc);
            }
            return argTypes;
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(maxStack, maxLocals);
            this.newsOnStack = 0;
        }

        private void setLastOpcode(int opcode) {
            if (this.eatDup && opcode != 89) {
                ++this.popConstructor;
            }
            this.lastOpcode = opcode;
            this.eatDup = false;
        }
    }
}

