/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.common.asm.AbstractClassInstrumenter;
import com.agitar.common.asm.AsmUtil;
import com.agitar.common.asm.ClassInstrumenter;
import com.agitar.common.asm.SerialIDInstrumenter;
import com.agitar.common.logging.AgProcessTimer;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.Checksum;
import com.agitar.common.util.IOUtility;
import com.agitar.coverage.AlreadyInstrumentedException;
import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.ClassIncrementerInstrumenter;
import com.agitar.coverage.ClassInfoCollector;
import com.agitar.coverage.CoverageManager;
import com.agitar.coverage.InterposingInstrumenter;
import com.agitar.coverage.LineConditionInstrumenter2;
import com.agitar.coverage.analysis.AsmClassCache;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Instrumenter2 {
    private final Set testClasses;
    private final Set targetClasses;
    private final ClassLoader loader;
    private final AsmClassCache classCache;
    private boolean tbs;
    public static final int RESULT_INSTRUMENTED = 0;
    public static final int RESULT_INTERFACE = 1;
    public static final int RESULT_UP_TO_DATE = 2;
    public static final int RESULT_NOT_IN_PROJECT = 3;
    protected static final boolean LOGGING = AgitarProperties.LOG_INSTRUMENTATION;
    private static AgProcessTimer timer = new AgProcessTimer(false);

    public Instrumenter2(Set testClasses, Set targetClasses, ClassLoader loader, boolean tbs, AsmClassCache classCache) {
        this.testClasses = testClasses;
        this.targetClasses = targetClasses;
        this.loader = loader;
        this.tbs = tbs;
        this.classCache = classCache;
    }

    public int instrumentClass(String className) throws IOException, ClassNotFoundException {
        String classFileName = className.replace('.', '/') + ".class";
        URL url = this.loader.getResource(classFileName);
        if (url == null) {
            AgitarLogger.getUserLogger((String)"coverage").info("Could not instrument " + className + " for coverage (not in project classpath)");
            return 3;
        }
        URLConnection con = url.openConnection();
        byte[] classBytes = IOUtility.loadBytesFromURL((URLConnection)con);
        this.classCache.parseClass(classBytes);
        ClassCoverage classCoverage = new ClassCoverage(className, CoverageManager.getCoverageDir());
        classCoverage.setOriginalChecksum(new Checksum().get(classBytes));
        this.instrument(classCoverage, classBytes);
        return classCoverage.getMethodCount() > 0 ? 0 : 1;
    }

    private void instrument(ClassCoverage classCoverage, byte[] classBytes) throws IOException {
        try {
            classCoverage.setInstrClassName(this.getClass().getName());
            AgProcessTimer processTimer = timer.createSubProcess("Process").start();
            List instrumenters = this.createInstrumenterChain(classCoverage);
            ClassReader reader = new ClassReader(classBytes);
            ClassWriter writer = new ClassWriter(true, true);
            ((ClassInstrumenter)instrumenters.get(instrumenters.size() - 1)).setNext((ClassVisitor)writer);
            reader.accept((ClassVisitor)((ClassInstrumenter)instrumenters.get(0)), AsmUtil.getDefaultAttributes(), false);
            byte[] instrumentedBytes = writer.toByteArray();
            File classFile = classCoverage.locateInstrClassFile(CoverageManager.getInstrumentedClassDir());
            classFile.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(classFile);
            fos.write(instrumentedBytes);
            fos.close();
            this.mergePreviousCoverage(classCoverage);
            classCoverage.write();
            processTimer.stop();
        }
        catch (AlreadyInstrumentedException e) {
            AgitarLogger.getDiagnosticLogger().log(Level.WARNING, "already instrumented: " + classCoverage.getClassName(), e);
        }
    }

    private void mergePreviousCoverage(ClassCoverage classCoverage) {
        if (classCoverage.locateCoverageFile().exists()) {
            ClassCoverage previousCoverage = new ClassCoverage(classCoverage.getClassName(), CoverageManager.getCoverageDir());
            try {
                previousCoverage.read();
                classCoverage.merge(previousCoverage);
            }
            catch (IllegalArgumentException x) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected List createInstrumenterChain(ClassCoverage classCoverage) {
        List instrumenters = this.createInstrumenters(classCoverage);
        ClassInstrumenter previous = null;
        Iterator iterator = instrumenters.iterator();
        while (iterator.hasNext()) {
            ClassInstrumenter instrumenter = (ClassInstrumenter)iterator.next();
            if (previous != null) {
                previous.setNext((ClassVisitor)instrumenter);
            }
            previous = instrumenter;
        }
        return instrumenters;
    }

    protected List createInstrumenters(ClassCoverage classCoverage) {
        ArrayList<AbstractClassInstrumenter> instrumenters = new ArrayList<AbstractClassInstrumenter>();
        instrumenters.add(new ClassInfoCollector(classCoverage, AgitarLogger.getUserLogger((String)"coverage")));
        instrumenters.add((AbstractClassInstrumenter)new SerialIDInstrumenter());
        instrumenters.add(new LineConditionInstrumenter2(classCoverage, this.classCache.getClassDataForClassKey(classCoverage.getClassName())));
        if (!this.tbs) {
            instrumenters.add(new InterposingInstrumenter(this.testClasses, this.targetClasses));
        }
        instrumenters.add(new ClassIncrementerInstrumenter(classCoverage));
        return instrumenters;
    }

    protected static void log(String message) {
        AgitarLogger.getUserLogger().info(message);
    }

    public static void main(String[] args) throws IOException {
        new Instrumenter2(Collections.EMPTY_SET, Collections.EMPTY_SET, ClassLoader.getSystemClassLoader(), false, new AsmClassCache()).instanceMain(args);
    }

    private void instanceMain(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            String filename = args[i];
            byte[] classBytes = IOUtility.whole((File)new File(filename));
            ClassCoverage classCoverage = new ClassCoverage(filename, CoverageManager.getCoverageDir());
            classCoverage.setOriginalChecksum(new Checksum().get(classBytes));
            classCoverage.setInstrClassName("test");
            List instrumenters = this.createInstrumenterChain(classCoverage);
            ClassReader reader = new ClassReader(classBytes);
            ClassWriter writer = new ClassWriter(true, true);
            ((ClassInstrumenter)instrumenters.get(instrumenters.size() - 1)).setNext((ClassVisitor)writer);
            reader.accept((ClassVisitor)((ClassInstrumenter)instrumenters.get(0)), false);
            byte[] instrumentedBytes = writer.toByteArray();
            FileOutputStream fos = new FileOutputStream(filename + ".out");
            fos.write(instrumentedBytes);
            fos.close();
            FileOutputStream acov = new FileOutputStream(filename + ".acov");
            classCoverage.write(new DataOutputStream(acov));
            acov.close();
        }
    }

    public static void setTimer(AgProcessTimer timer) {
        Instrumenter2.timer = timer;
    }
}

