/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.common.util.IOUtility;
import com.agitar.coverage.CoverageManager;
import java.io.File;
import java.io.FileFilter;

public class InstrumentUtil {
    public static final String CLASS_EXTENSION = ".class";
    public static final String BACKUP_EXTENSION = ".bak";

    public static void clearInstrumentedClasses() {
        File dataDir = CoverageManager.getInstrumentedClassDir();
        if (dataDir.exists()) {
            InstrumentedClassFilter filter = new InstrumentedClassFilter();
            File[] classFiles = IOUtility.getAllFiles((File)dataDir, (FileFilter)filter, (boolean)true);
            for (int i = 0; i < classFiles.length; ++i) {
                classFiles[i].delete();
            }
        } else {
            dataDir.mkdirs();
        }
    }

    private static class InstrumentedClassFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.toString().endsWith(InstrumentUtil.CLASS_EXTENSION);
        }
    }
}

