/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.common.types.MethodSignature;
import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.CoverageManager;
import com.agitar.coverage.CoveragePoint;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.List;

public class DumpAcov {
    public static void main(String[] args) {
        try {
            CoverageManager.setCoverageDir(new File("."));
            for (int i = 0; i < args.length; ++i) {
                if (new File(args[i]).exists()) {
                    ClassCoverage cc = new ClassCoverage("unknown", CoverageManager.getCoverageDir());
                    cc.read(new DataInputStream(new FileInputStream(args[i])));
                    DumpAcov.dumpCC(cc.getClassName(), cc);
                    continue;
                }
                String className = args[i];
                ClassCoverage cc = new ClassCoverage(className, CoverageManager.getCoverageDir());
                cc.read();
                DumpAcov.dumpCC(className, cc);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        System.exit(0);
    }

    private static void dumpCC(String className, ClassCoverage cc) {
        System.out.println("Name:     " + className);
        System.out.println("Checksum: " + Long.toHexString(cc.getOriginalChecksum()).toUpperCase());
        System.out.println("Instr-By: " + cc.getInstrClassName());
        MethodSignature[] sigs = cc.getMethodSignatures();
        DumpAcov.showPoints("Raw points:", sigs, cc.getRawPoints());
        DumpAcov.showPoints("Filtered points:", sigs, cc.getPoints());
        System.out.println();
        for (int j = 0; j < cc.getMethodCount(); ++j) {
            int[] methodCoverage = cc.getTotalMethodCoverage(j);
            System.out.println(sigs[j].getShortestForm() + " coverage: " + methodCoverage[1] + "/" + methodCoverage[0]);
        }
        int[] totalCoverage = cc.getTotalCoverage();
        System.out.println("Total coverage: " + totalCoverage[1] + "/" + totalCoverage[0]);
    }

    private static void showPoints(String label, MethodSignature[] sigs, List points) {
        System.out.println();
        System.out.println(label);
        Iterator iter = points.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String typeName;
            CoveragePoint point = (CoveragePoint)iter.next();
            switch (point.getType()) {
                case 1: {
                    typeName = "F-cond";
                    break;
                }
                case 2: {
                    typeName = "T-cond";
                    break;
                }
                case 0: {
                    typeName = "start-line";
                    break;
                }
                default: {
                    typeName = "unknown";
                }
            }
            System.out.println("[" + i + "] " + sigs[point.getMethodNumber()].getShortestForm() + " I#" + point.getByteOffset() + " " + typeName + " L" + point.getLineNumber() + " " + point.getTimesReached() + "x");
            ++i;
        }
    }
}

