/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CoveragePoint {
    public static final int T_UNKNOWN = -1;
    public static final int T_LINE = 0;
    public static final int T_IF_FALSE = 1;
    public static final int T_IF_TRUE = 2;
    private int type = -1;
    private int byteOffset;
    private int methodNumber;
    private int lineNumber;
    private int timesReached;

    public CoveragePoint() {
    }

    public CoveragePoint(int type, int byteOffset, int methodNumber, int lineNumber) {
        this.type = type;
        this.byteOffset = byteOffset;
        this.methodNumber = methodNumber;
        this.lineNumber = lineNumber;
    }

    public CoveragePoint(DataInput in, int fileVersion) throws IOException {
        if (fileVersion <= 2) {
            this.readOld(in);
        } else {
            this.read(in);
        }
    }

    public int getType() {
        return this.type;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public int getMethodNumber() {
        return this.methodNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    void setType(int type) {
        this.type = type;
    }

    void setByteOffset(int byteOffset) {
        this.byteOffset = byteOffset;
    }

    void setMethodNumber(int methodNumber) {
        this.methodNumber = methodNumber;
    }

    void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getTimesReached() {
        return this.timesReached;
    }

    public boolean setTimesReached(int timesReached) {
        if (this.timesReached != timesReached) {
            this.timesReached = timesReached;
            return true;
        }
        return false;
    }

    public void read(DataInput in) throws IOException {
        this.type = in.readInt();
        this.byteOffset = in.readInt();
        this.methodNumber = in.readInt();
        this.lineNumber = in.readInt();
        this.timesReached = in.readInt();
    }

    public void readOld(DataInput in) throws IOException {
        this.type = in.readInt();
        String deprecatedDescription = in.readUTF();
        this.byteOffset = in.readInt();
        this.methodNumber = in.readInt();
        this.lineNumber = in.readInt();
        int deprecatedStartColumn = in.readInt();
        int deprecatedEndLine = in.readInt();
        int deprecatedEndColumn = in.readInt();
        this.timesReached = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeInt(this.byteOffset);
        out.writeInt(this.methodNumber);
        out.writeInt(this.lineNumber);
        out.writeInt(this.timesReached);
    }

    public String toString() {
        return "[" + this.lineNumber + "/" + this.timesReached + "/" + this.type + "]";
    }
}

