/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.common.asm.AbstractClassInstrumenter;
import com.agitar.common.asm.ClassInstrumenter;
import com.agitar.common.asm.SerialIDInstrumenter;
import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.IOUtility;
import com.agitar.common.util.StringUtility;
import com.agitar.common.util.TimingStats;
import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.ClassIncrementerInstrumenter;
import com.agitar.coverage.ClassInfoCollector;
import com.agitar.coverage.CoverageInducedDeath;
import com.agitar.coverage.LineConditionInstrumenter2;
import com.agitar.coverage.analysis.AsmClassCache;
import com.agitar.lib.NoObfuscation;
import com.agitar.security.AgPolicy;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;

public class CoverageManager
implements NoObfuscation {
    public static boolean LOG_COVERAGE = false;
    public static final TimingStats.Kind COVERAGE_PERCENTAGE_TITLE = new TimingStats.Kind("Cov%");
    private static final Map classNameToCounters = new HashMap();
    private static boolean washerMode;
    private static volatile boolean enabled;
    private static final Object KILL_REQUESTED;
    private static final Object KILLED;
    private static final Object REKILLED;
    private static File coverageDir;
    private static File instrumentedClassDir;
    private static final Map classNameToClassCoverage;
    private static final Map threadToKillState;
    private static Thread lastThread;
    private static final Map threadInClinit;
    private static boolean logErrorAnnounced;
    private static File lastModifiedFile;
    private static long lastModifiedTime;

    public static void writeClassFille(final String className, final byte[] classBytes) {
        if (AgitarProperties.TBS_DEBUG_MODE) {
            AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    File instrumentedClassDir = CoverageManager.getInstrumentedClassDir();
                    File f = new File((instrumentedClassDir == null ? new File("./agitar/.classes") : instrumentedClassDir) + "/" + className.replace('.', '/') + ".class");
                    try {
                        f.getParentFile().mkdirs();
                        FileOutputStream fos = new FileOutputStream(f);
                        fos.write(classBytes);
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
    }

    private CoverageManager() {
    }

    public static void setWasherMode(boolean washerMode) {
        CoverageManager.washerMode = washerMode;
    }

    public static boolean isWasherMode() {
        return washerMode;
    }

    public static synchronized int[] registerClass(final String className, final int size) {
        return (int[])AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                String name = className.replace('/', '.');
                CoverageManager.logMessage("registering " + name + " at size " + size);
                int[] coverage = (int[])classNameToCounters.get(name);
                if (coverage == null) {
                    coverage = new int[size];
                    classNameToCounters.put(name, coverage);
                } else if (coverage.length != size) {
                    CoverageManager.logMessage("class was reloaded at a different size: " + name);
                    coverage = new int[size];
                    classNameToCounters.put(name, coverage);
                }
                return coverage;
            }
        });
    }

    public static synchronized Map getCoverageSnapshot() {
        HashMap<String, Object> snapshot = new HashMap<String, Object>();
        Iterator iterator = classNameToCounters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String className = (String)entry.getKey();
            int[] coverage = (int[])entry.getValue();
            snapshot.put(className, coverage.clone());
        }
        return snapshot;
    }

    public static synchronized void restoreCoverageSnapshot(Map snapshot) {
        Iterator iterator = snapshot.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String className = (String)entry.getKey();
            int[] snappedCoverage = (int[])entry.getValue();
            int[] liveCoverage = (int[])classNameToCounters.get(className);
            if (liveCoverage == null || liveCoverage.length != snappedCoverage.length) continue;
            System.arraycopy(snappedCoverage, 0, liveCoverage, 0, snappedCoverage.length);
        }
    }

    public static synchronized Set getRegisteredClasses() {
        return classNameToCounters.keySet();
    }

    public static ClassCoverage getCoverage(String className, boolean unregistered) throws IOException {
        return CoverageManager.getCoverage(className, CoverageManager.getCoverageDir(), unregistered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassCoverage getCoverage(String className, File coverageDir, boolean unregistered) throws IOException {
        ClassCoverage cc;
        int[] cvg;
        Class clazz = CoverageManager.class;
        synchronized (clazz) {
            cvg = (int[])classNameToCounters.get(className);
        }
        if (cvg != null) {
            cc = (ClassCoverage)classNameToClassCoverage.get(className);
            if (cc == null) {
                cc = new ClassCoverage(className, coverageDir);
                cc.read();
                classNameToClassCoverage.put(className, cc);
            }
            cc.updateReached(cvg);
            return cc;
        }
        if (unregistered) {
            cc = new ClassCoverage(className, coverageDir);
            File coverageFile = cc.locateCoverageFile();
            if (coverageFile.exists() && coverageFile.lastModified() >= CoverageManager.getLastModified()) {
                cc.read();
                return cc;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int[] getCounters(String className, int size) {
        int[] cvg;
        Class clazz = CoverageManager.class;
        synchronized (clazz) {
            cvg = (int[])classNameToCounters.get(className);
        }
        if (cvg != null) {
            return cvg;
        }
        ClassCoverage cc = new ClassCoverage(className, CoverageManager.getCoverageDir());
        try {
            cc.read();
            return cc.getCounters();
        }
        catch (IOException x) {
            return new int[size];
        }
    }

    public static synchronized int[] getCounters(String className) {
        return (int[])classNameToCounters.get(className);
    }

    public static synchronized void saveAllCoverage(boolean accumulate, File coverageDir) {
        CoverageManager.logMessage("saving coverage for " + classNameToCounters.keySet().size() + " classes");
        if (!accumulate) {
            CoverageManager.setLastModified();
        }
        Iterator iter = classNameToCounters.keySet().iterator();
        while (iter.hasNext()) {
            String className = (String)iter.next();
            try {
                CoverageManager.saveCoverage(className, accumulate);
            }
            catch (IOException x) {
                CoverageManager.logMessage("IOException: " + x.getMessage());
                AgitarLogger.getDiagnosticLogger().warning(StringUtility.trace((Throwable)x));
                ClassCoverage cc = new ClassCoverage(className, coverageDir);
                cc.deleteAllDataFiles();
            }
            catch (IllegalStateException x) {
                AgitarLogger.getDiagnosticLogger().warning(StringUtility.trace((Throwable)x));
                CoverageManager.logMessage("IllegalStateException: " + x.getMessage());
            }
        }
    }

    public static boolean saveCoverage(String className, boolean accumulate) throws IOException {
        int[] cvg = (int[])classNameToCounters.get(className);
        if (cvg == null) {
            CoverageManager.logMessage("no coverage for " + className);
            return false;
        }
        if (!CoverageManager.canWrite()) {
            AgitarLogger.getDiagnosticLogger((String)"CoverageManager").warning("Last modified file is not set to our starttime of: " + lastModifiedTime + ", cannot write coverage");
            CoverageManager.logMessage("cannot write coverage for " + className + ", don't own the last modified timestamp file");
            return false;
        }
        ClassCoverage cc = new ClassCoverage(className, CoverageManager.getCoverageDir());
        cc.read();
        try {
            if (accumulate) {
                cc.addToReached(cvg);
            } else {
                cc.updateReached(cvg);
            }
            CoverageManager.logCoverage(cc);
            cc.write();
            int[] total = cc.getTotalCoverage();
            CoverageManager.logMessage("writing (" + (accumulate ? "cumulative" : "current") + ") coverage for " + className + " (" + total[1] + "/" + total[0] + ")");
            TimingStats.addTimingStats((TimingStats.Kind)COVERAGE_PERCENTAGE_TITLE, (String)("" + (total[0] == 0 ? 0 : Math.round((float)total[1] / (float)total[0]) * 100)));
            return true;
        }
        catch (IllegalArgumentException x) {
            CoverageManager.logMessage("IllegalArgumentException: " + x.getMessage());
            AgitarLogger.getDiagnosticLogger().severe(StringUtility.trace((Throwable)x));
            throw new IllegalStateException();
        }
    }

    private static void logCoverage(ClassCoverage coverage) {
        if (LOG_COVERAGE) {
            String[] methods = coverage.getMethodNames();
            for (int j = 0; j < methods.length; ++j) {
                String signature = MethodSignature.fromFullKey((String)(coverage.getClassName().replace('.', '/') + "." + methods[j])).getLongFormNoNames();
                int[] covFraction = coverage.getTotalMethodCoverage(j);
                int p = covFraction[1] * 100 / covFraction[0];
                AgitarLogger.getDiagnosticLogger().info("Coverage of " + signature + " = " + p + "%");
            }
        }
    }

    public static synchronized void resetAllCoverage() {
        Iterator iter = classNameToCounters.values().iterator();
        while (iter.hasNext()) {
            int[] cvg = (int[])iter.next();
            int cvglen = cvg.length;
            for (int i = 0; i < cvglen; ++i) {
                cvg[i] = 0;
            }
        }
    }

    public static synchronized void forgetEverything() {
        classNameToCounters.clear();
    }

    public static synchronized void unregister(String className) {
        className = className.replace('/', '.');
        CoverageManager.logMessage("unregistering " + className);
        classNameToCounters.remove(className);
        classNameToClassCoverage.remove(className);
    }

    public static synchronized void dumpCoverage(OutputStream os) {
        PrintStream ps = new PrintStream(os);
        Iterator iter = classNameToCounters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ps.println((String)entry.getKey());
            int[] cvg = (int[])entry.getValue();
            int cvglen = cvg.length;
            for (int i = 0; i < cvglen; ++i) {
                ps.println("    " + cvg[i]);
            }
        }
    }

    public static File getCoverageDir() {
        return coverageDir;
    }

    public static void setCoverageDir(File coverageDir) {
        if (coverageDir == null) {
            throw new NullPointerException();
        }
        if (!coverageDir.equals(CoverageManager.coverageDir)) {
            CoverageManager.logMessage("set coverage dir to " + coverageDir);
            CoverageManager.coverageDir = coverageDir;
        }
    }

    public static File getInstrumentedClassDir() {
        return instrumentedClassDir;
    }

    public static void setInstrumentedClassDir(File instrumentedClassDir) {
        if (instrumentedClassDir == null) {
            throw new NullPointerException();
        }
        if (!instrumentedClassDir.equals(CoverageManager.instrumentedClassDir)) {
            CoverageManager.logMessage("set instrumented class dir to " + instrumentedClassDir);
            CoverageManager.instrumentedClassDir = instrumentedClassDir;
        }
    }

    private static void logMessage(String message) {
        String logFileName = System.getProperty("coveragelog");
        if (logFileName != null) {
            try {
                PrintStream log = new PrintStream(new FileOutputStream(logFileName, true));
                log.print(CoverageManager.class.getName().substring(0, 3));
                log.print(' ');
                log.println(message);
                log.flush();
                log.close();
            }
            catch (Throwable e) {
                if (!logErrorAnnounced) {
                    logErrorAnnounced = true;
                }
                System.out.println("couldn't open log: " + logFileName);
            }
        }
    }

    private static void logException(Throwable x) {
        CoverageManager.logMessage(StringUtility.trace((Throwable)x));
    }

    public static void clearCoverage(String className) throws IOException {
        ClassCoverage cc = new ClassCoverage(className, CoverageManager.getCoverageDir());
        cc.read();
        cc.clearReached();
        cc.write();
    }

    public static void clearCoverage(Collection classNames) throws IOException {
        boolean failed = false;
        Iterator iterator = classNames.iterator();
        while (iterator.hasNext()) {
            String className = (String)iterator.next();
            try {
                CoverageManager.clearCoverage(className);
            }
            catch (IOException x) {
                AgitarLogger.getDiagnosticLogger().warning(StringUtility.trace((Throwable)x));
                CoverageManager.logException(x);
                failed = true;
            }
        }
        if (failed) {
            throw new IOException("failed to clear one or more coverage files");
        }
    }

    public static void removeAllCoverage() {
        if (coverageDir.exists()) {
            FileFilter filter = new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getName().endsWith(".acov");
                }
            };
            File[] classFiles = IOUtility.getAllFiles((File)coverageDir, (FileFilter)filter, (boolean)true);
            for (int i = 0; i < classFiles.length; ++i) {
                classFiles[i].delete();
            }
        }
    }

    public static void removeCoverage(String className) {
        ClassCoverage cc = new ClassCoverage(className, CoverageManager.getCoverageDir());
        File coverageFile = cc.locateCoverageFile();
        coverageFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stopThread(Thread thread) {
        Map map = threadToKillState;
        synchronized (map) {
            threadToKillState.put(thread, KILL_REQUESTED);
            lastThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allowThread(Thread thread) {
        Map map = threadToKillState;
        synchronized (map) {
            threadToKillState.remove(thread);
            lastThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean killUnneededThread() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != lastThread) {
            Map map = threadToKillState;
            synchronized (map) {
                CoverageInducedDeath death;
                lastThread = currentThread;
                Object threadState = threadToKillState.get(currentThread);
                if (threadState == null) {
                    return false;
                }
                Map map2 = threadInClinit;
                synchronized (map2) {
                    Long time = (Long)threadInClinit.get(currentThread);
                    if (time != null) {
                        return true;
                    }
                }
                if (threadState == REKILLED) {
                    throw new CoverageInducedDeath();
                }
                if (threadState == KILLED) {
                    threadToKillState.put(currentThread, REKILLED);
                    death = new CoverageInducedDeath();
                    AgitarLogger.getDiagnosticLogger((String)"coverage").log(AgitarLevel.INFO, "reterminated thread: " + currentThread);
                    throw death;
                }
                if (threadState == KILL_REQUESTED) {
                    threadToKillState.put(currentThread, KILLED);
                    death = new CoverageInducedDeath();
                    AgitarLogger.getDiagnosticLogger((String)"coverage").log(AgitarLevel.INFO, "terminated thread: " + currentThread);
                    throw death;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enterClinit(Thread thread) {
        Map map = threadInClinit;
        synchronized (map) {
            threadInClinit.put(thread, new Long(System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exitClinit(Thread thread) {
        Map map = threadInClinit;
        synchronized (map) {
            threadInClinit.remove(thread);
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        CoverageManager.enabled = enabled;
    }

    public static void increment(int[] counters, int n) {
        if (enabled) {
            if (washerMode && CoverageManager.killUnneededThread()) {
                return;
            }
            int next = counters[n] + 1;
            if (next > 0) {
                counters[n] = next;
            }
        }
    }

    public static long getLastModified(File coverageDirectory) {
        return new File(coverageDirectory, "-master-.acov").lastModified();
    }

    public static long getLastModified() {
        return CoverageManager.getLastModified(coverageDir);
    }

    public static void setLastModified() {
        AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                File masterAcov = new File(coverageDir, "-master-.acov");
                if (!masterAcov.exists()) {
                    try {
                        masterAcov.createNewFile();
                    }
                    catch (IOException x) {
                        CoverageManager.logException(x);
                    }
                } else {
                    masterAcov.setLastModified(System.currentTimeMillis());
                }
                return null;
            }
        });
    }

    public static void recordStartTime(final File f, final long startTime) {
        AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    lastModifiedFile = f;
                    f.createNewFile();
                    f.setLastModified(startTime);
                    lastModifiedTime = f.lastModified();
                }
                catch (Exception ex) {
                    AgitarLogger.getDiagnosticLogger().warning("Could not write coverage start time: " + StringUtility.trace((Throwable)ex));
                }
                return null;
            }
        });
    }

    public static boolean canWrite() {
        return lastModifiedFile == null || lastModifiedFile.lastModified() / 1000L == lastModifiedTime / 1000L;
    }

    public static List createInstrumenterChain(AsmClassCache classCache, ClassCoverage classCoverage, Logger logger) {
        ArrayList<AbstractClassInstrumenter> instrumenters = new ArrayList<AbstractClassInstrumenter>();
        instrumenters.add(new ClassInfoCollector(classCoverage, logger));
        instrumenters.add((AbstractClassInstrumenter)new SerialIDInstrumenter());
        instrumenters.add(new LineConditionInstrumenter2(classCoverage, classCache.getClassDataForClassKey(classCoverage.getClassName())));
        instrumenters.add(new ClassIncrementerInstrumenter(classCoverage));
        ClassInstrumenter prev = null;
        Iterator i = instrumenters.iterator();
        while (i.hasNext()) {
            ClassInstrumenter ins = (ClassInstrumenter)i.next();
            if (prev != null) {
                prev.setNext((ClassVisitor)ins);
            }
            prev = ins;
        }
        return instrumenters;
    }

    static {
        enabled = true;
        KILL_REQUESTED = new Object();
        KILLED = new Object();
        REKILLED = new Object();
        classNameToClassCoverage = new HashMap();
        threadToKillState = new IdentityHashMap();
        threadInClinit = new IdentityHashMap();
        lastModifiedFile = null;
        lastModifiedTime = -1L;
    }
}

