/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.common.asm.AsmUtil;
import com.agitar.common.asm.ClassInstrumenter;
import com.agitar.common.asm.SerialIDInstrumenter;
import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.ClassIncrementerInstrumenter;
import com.agitar.coverage.ClassInfoCollector;
import com.agitar.coverage.LineConditionInstrumenter2;
import com.agitar.coverage.analysis.AsmClassCache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class CoverageInstrumenterChain {
    private final ClassInfoCollector classInfoCollector;
    private final List instrumenters = new ArrayList();

    public static CoverageInstrumenterChain getInstance(AsmClassCache classCache, ClassCoverage classCoverage, Logger logger) {
        return new CoverageInstrumenterChain(classCache, classCoverage, logger);
    }

    private CoverageInstrumenterChain(AsmClassCache classCache, ClassCoverage classCoverage, Logger logger) {
        this.classInfoCollector = new ClassInfoCollector(classCoverage, logger);
        this.instrumenters.add(this.classInfoCollector);
        this.instrumenters.add(new SerialIDInstrumenter());
        this.instrumenters.add(new LineConditionInstrumenter2(classCoverage, classCache.getClassDataForClassKey(classCoverage.getClassName())));
        this.instrumenters.add(new ClassIncrementerInstrumenter(classCoverage));
        ClassInstrumenter prev = null;
        Iterator i = this.instrumenters.iterator();
        while (i.hasNext()) {
            ClassInstrumenter ins = (ClassInstrumenter)i.next();
            if (prev != null) {
                prev.setNext((ClassVisitor)ins);
            }
            prev = ins;
        }
    }

    public ClassInfoCollector getClassInfoCollector() {
        return this.classInfoCollector;
    }

    public List getList() {
        return this.instrumenters;
    }

    public ClassWriter instrument(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(true, true);
        ((ClassInstrumenter)this.instrumenters.get(this.instrumenters.size() - 1)).setNext((ClassVisitor)cw);
        cr.accept((ClassVisitor)((ClassInstrumenter)this.instrumenters.get(0)), AsmUtil.getDefaultAttributes(), false);
        return cw;
    }
}

