/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.common.asm.AbstractClassInstrumenter;
import com.agitar.common.asm.BytecodeSizeChecker;
import com.agitar.common.asm.CodeInstrumenter;
import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.util.AgitarProperties;
import com.agitar.coverage.AlreadyInstrumentedException;
import com.agitar.coverage.ClassCoverage;
import java.util.logging.Logger;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.CodeWriter;
import org.objectweb.asm.Label;

public class ClassInfoCollector
extends AbstractClassInstrumenter {
    public static final String CONCRETE_MOCK = "com.agitar.lib.ConcreteMock";
    private boolean concreteMock;
    private boolean hasLineNumbers;
    private boolean hasLocalVariables;
    private boolean hasLocalVariableInfo;
    private final ClassCoverage cvg;
    private final Logger log;

    public ClassInfoCollector(ClassCoverage cvg, Logger log) {
        this.cvg = cvg;
        this.log = log;
    }

    public boolean hasLineNumbers() {
        return this.hasLineNumbers;
    }

    public boolean hasLocalVariables() {
        return this.hasLocalVariables;
    }

    public boolean hasLocalVariableInfo() {
        return this.hasLocalVariableInfo;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        super.visit(version, access, name, superName, interfaces, sourceFile);
        if (!AgitarProperties.javaVersion((int)1, (int)((version & 0xFFFF) - 44), (int)0)) {
            Diagnostics.getKey((String)"version.mismatch").add(this.cvg.getClassName());
            this.log.warning(this.cvg.getClassName() + " was compiled for a newer version of Java than the selected JRE. (" + version + ")");
        }
        this.hasLineNumbers = false;
        this.hasLocalVariables = false;
        this.hasLocalVariableInfo = false;
        this.concreteMock = false;
        for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
            if (!interfaces[i].replace('/', '.').equals(CONCRETE_MOCK)) continue;
            this.concreteMock = true;
        }
        if (sourceFile == null && !this.concreteMock) {
            Diagnostics.getKey((String)"missing.source.name").add(this.cvg.getClassName());
            this.log.warning("Source filename information was missing from " + this.cvg.getClassName() + "; your coverage may not appear in the Dashboard. (To correct, recompile with debug enabled and re-agitate.)");
        } else {
            this.cvg.setSourceFile(sourceFile);
        }
    }

    public CodeVisitor visitMethod(int access, final String name, final String desc, String[] exceptions, Attribute attrs) {
        if (this.isInstrumentable(access, name)) {
            this.cvg.addMethod(name + '.' + desc, (access & 2) != 0);
            CodeVisitor superVisitor = super.visitMethod(access, name, desc, exceptions, attrs);
            return new CodeInstrumenter(superVisitor){

                public void visitVarInsn(int opcode, int var) {
                    super.visitVarInsn(opcode, var);
                    ClassInfoCollector.this.hasLocalVariables = true;
                }

                public void visitLineNumber(int line, Label start) {
                    super.visitLineNumber(line, start);
                    ClassInfoCollector.this.hasLineNumbers = true;
                }

                public void visitLocalVariable(String name2, String desc2, Label start, Label end, int index) {
                    super.visitLocalVariable(name2, desc2, start, end, index);
                    ClassInfoCollector.this.hasLocalVariableInfo = true;
                }

                public void visitMaxs(int maxStack, int maxLocals) {
                    super.visitMaxs(maxStack, maxLocals);
                    if (this.getNext() instanceof CodeWriter) {
                        BytecodeSizeChecker.check((CodeVisitor)((CodeWriter)this.getNext()), (String)ClassInfoCollector.this.getSlashedClassName(), (String)name, (String)desc, (boolean)false, (boolean)false);
                    }
                }
            };
        }
        return super.visitMethod(access, name, desc, exceptions, attrs);
    }

    public void visitEnd() {
        if (this.cvg.getMethodCount() > 0 && !this.hasLineNumbers && !this.concreteMock) {
            Diagnostics.getKey((String)"missing.line.numbers").add(this.cvg.getClassName());
            this.log.warning("Line number information was missing from " + this.cvg.getClassName() + "; some coverage data will be lost. (To correct, recompile with debug enabled and re-agitate.)");
        }
        if (this.cvg.getMethodCount() > 0 && this.hasLocalVariables && !this.hasLocalVariableInfo && !this.concreteMock) {
            Diagnostics.getKey((String)"missing.local.variables").add(this.cvg.getClassName());
            this.log.warning("Local variable information was missing from " + this.cvg.getClassName() + "; some data will be lost. (To correct, recompile with debug enabled and re-agitate.)");
        }
        super.visitEnd();
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        if (name.equals("$agitar_cvg")) {
            throw new AlreadyInstrumentedException();
        }
        super.visitField(access, name, desc, value, attrs);
    }

    public boolean getHasLineNumbers() {
        return this.hasLineNumbers;
    }

    public boolean getHasLocalVariables() {
        return this.hasLocalVariables;
    }

    public boolean getHasLocalVariableInfo() {
        return this.hasLocalVariableInfo;
    }

    public boolean isConcreteMock() {
        return this.concreteMock;
    }
}

