/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.common.asm.AsmUtil;
import com.agitar.common.asm.ClassInstrumenter;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.types.ClassName;
import com.agitar.common.util.IOUtility;
import com.agitar.common.util.StringUtility;
import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.CoverageManager;
import com.agitar.coverage.analysis.AsmClassCache;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public abstract class ClassCoverageUtils {
    public static CoverageInfo getClassCoverages(String[] outerClassNames, File coverageDirectory, FileLocator locator) {
        long start = System.currentTimeMillis();
        CoverageInfo info = new CoverageInfo();
        long lastModified = CoverageManager.getLastModified(coverageDirectory);
        File newCoverageDir = new File(coverageDirectory, "" + start);
        for (int j = 0; j < outerClassNames.length; ++j) {
            String outerClassName = outerClassNames[j];
            ClassName outer = ClassName.get((String)outerClassName);
            String simpleName = outer.getSimpleName();
            String simpleAcov = simpleName + ".acov";
            String innerPrefix = simpleName + "$";
            String packageName = outer.getPackageName();
            File packageDir = new File(coverageDirectory, packageName.replace('.', File.separatorChar));
            File[] acovs = IOUtility.getAllFilesWithExtension((File)packageDir, (String)".acov", (boolean)false);
            for (int i = 0; i < acovs.length; ++i) {
                File acov = acovs[i];
                String name = acov.getName();
                if (acov.lastModified() < lastModified || !name.startsWith(innerPrefix) && !name.equals(simpleAcov)) continue;
                String simpleClassName = name.substring(0, name.length() - ".acov".length());
                ClassCoverage cov = new ClassCoverage(simpleClassName, coverageDirectory);
                try {
                    File sourceFile;
                    String fullClassName = StringUtility.nullOrEmpty((String)packageName) ? simpleClassName : packageName + "." + simpleClassName;
                    File classFile = locator.getClassFile(fullClassName);
                    if (classFile == null || !classFile.exists() || !classFile.isFile() || acov.lastModified() < classFile.lastModified() || (sourceFile = locator.getSourceFile(fullClassName)) == null || !sourceFile.exists() || !sourceFile.isFile()) continue;
                    if (!locator.isAutoBuildOn() && sourceFile.lastModified() > classFile.lastModified()) {
                        info.add(fullClassName, null);
                        continue;
                    }
                    DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(acov)));
                    cov.read(in);
                    in.close();
                    try {
                        ClassCoverage current = new ClassCoverage(fullClassName, newCoverageDir);
                        ClassCoverageUtils.load(classFile, current);
                        cov.checkCompatibility(current);
                        info.add(fullClassName, cov);
                    }
                    catch (Throwable th) {
                        info.add(fullClassName, null);
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            IOUtility.recursiveDelete((File)newCoverageDir);
        }
        catch (Throwable e) {
            // empty catch block
        }
        AgitarLogger.getDiagnosticLogger().info(ClassCoverageUtils.class.getName() + ": " + (System.currentTimeMillis() - start) + " ms");
        return info;
    }

    public static ClassWriter instrument(byte[] classBytes, List instrumenters) {
        ClassReader cr = new ClassReader(classBytes);
        ClassWriter cw = new ClassWriter(true, true);
        ((ClassInstrumenter)instrumenters.get(instrumenters.size() - 1)).setNext((ClassVisitor)cw);
        cr.accept((ClassVisitor)((ClassInstrumenter)instrumenters.get(0)), AsmUtil.getDefaultAttributes(), false);
        return cw;
    }

    private static void load(File classFile, ClassCoverage current) throws IOException {
        byte[] classBytes = IOUtility.readFileAsBytes((File)classFile);
        AsmClassCache classCache = new AsmClassCache();
        classCache.parseClass(classBytes);
        List instrumenters = CoverageManager.createInstrumenterChain(classCache, current, AgitarLogger.getDiagnosticLogger((String)"coverage"));
        ClassCoverageUtils.instrument(classBytes, instrumenters);
    }

    private ClassCoverageUtils() {
    }

    public static interface FileLocator {
        public File getClassFile(String var1);

        public File getSourceFile(String var1);

        public boolean isAutoBuildOn();
    }

    public static class CoverageInfo {
        private final Map coverageMap = new HashMap();
        private boolean isCoverageValid = true;

        private CoverageInfo() {
        }

        public Map getCoverageMap() {
            return this.coverageMap;
        }

        public boolean isCoverageValid() {
            return this.isCoverageValid;
        }

        private void add(String className, ClassCoverage coverage) {
            if (coverage == null) {
                this.isCoverageValid = false;
            }
            this.coverageMap.put(className, coverage);
        }
    }
}

