/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.coverage;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.types.MethodSignature;
import com.agitar.common.types.TypeName;
import com.agitar.common.util.Counter;
import com.agitar.coverage.CoverageManager;
import com.agitar.coverage.CoveragePoint;
import com.agitar.security.AgPolicy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ClassCoverage {
    protected String className = "(--)";
    private boolean washerMode;
    protected String sourceFile = "(--)";
    protected long originalChecksum;
    protected String instrClassName = "(--)";
    protected long originalTimeStamp;
    protected static final String UNKNOWN = "(--)";
    private ArrayList points = new ArrayList();
    private List methodNames = new ArrayList();
    private List methodPrivates = new ArrayList();
    public static final String COVERAGE_EXTENSION = ".acov";
    private List filteredPoints;
    public static final int CURRENT_FILE_VERSION = 4;
    private final File coverageDir;
    private final File coverageFile;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassCoverage(String className, File coverageDir) {
        if (className == null) {
            throw new NullPointerException();
        }
        this.className = className;
        this.coverageDir = coverageDir;
        String filename = className.replace('.', File.separatorChar) + COVERAGE_EXTENSION;
        this.coverageFile = new File(coverageDir, filename);
    }

    public String getClassName() {
        return this.className;
    }

    public File locateInstrClassFile(File instrumentedClassDir) {
        String filename = this.className.replace('.', File.separatorChar) + ".class";
        return new File(instrumentedClassDir, filename);
    }

    public File locateCoverageFile() {
        return this.coverageFile;
    }

    public boolean isUpToDate(File instrumentedClassDir, File sourceFile) {
        File instrumentedClassFile = this.locateInstrClassFile(instrumentedClassDir);
        File coverageFile = this.locateCoverageFile();
        if (!coverageFile.exists()) {
            return false;
        }
        if (!instrumentedClassFile.exists() && !sourceFile.exists()) {
            return true;
        }
        if (sourceFile.exists()) {
            return sourceFile.lastModified() <= coverageFile.lastModified();
        }
        return instrumentedClassFile.lastModified() <= coverageFile.lastModified();
    }

    public void deleteAllDataFiles() {
        this.locateCoverageFile().delete();
        this.locateInstrClassFile(CoverageManager.getInstrumentedClassDir()).delete();
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile == null || "<Unknown>".equals(sourceFile) ? UNKNOWN : sourceFile;
    }

    public long getOriginalChecksum() {
        return this.originalChecksum;
    }

    public void setOriginalChecksum(long originalChecksum) {
        this.originalChecksum = originalChecksum;
    }

    public String getInstrClassName() {
        return this.instrClassName;
    }

    public void setInstrClassName(String instrClassName) {
        this.instrClassName = instrClassName;
    }

    public boolean wasSavedByWasher() {
        return this.washerMode;
    }

    public void read() throws IOException {
        File coverageFile = this.locateCoverageFile();
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(coverageFile)));
        this.read(in);
        in.close();
        if (coverageFile.lastModified() < CoverageManager.getLastModified(this.coverageDir)) {
            this.clearReached();
        }
    }

    public void write() throws IOException {
        try {
            AgPolicy.doPrivilegedAction((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    if (!CoverageManager.canWrite()) {
                        AgitarLogger.getDiagnosticLogger((String)"ClassCoverage").warning("Cannot write coverage for " + ClassCoverage.this.className + ", don't own the lastModifiedFile");
                        return null;
                    }
                    if (ClassCoverage.this.className.equals(ClassCoverage.UNKNOWN)) {
                        AgitarLogger.getDiagnosticLogger((String)"ClassCoverage").log(AgitarLevel.WARNING, "attempting to save invalid coverage file", new Exception());
                        return null;
                    }
                    File coverageFile = ClassCoverage.this.locateCoverageFile();
                    File coverageFileDir = coverageFile.getParentFile();
                    if (coverageFileDir != null && !coverageFileDir.exists()) {
                        coverageFileDir.mkdirs();
                    }
                    FilterOutputStream out = null;
                    try {
                        out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(coverageFile)));
                        ClassCoverage.this.write((DataOutput)((Object)out));
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof PrivilegedActionException) {
                throw (IOException)ex.getCause();
            }
            AgitarLogger.getDiagnosticLogger((String)"ClassCoverage").log(AgitarLevel.WARNING, "Unchecked exception", ex);
        }
    }

    public static File replaceExtension(File file, String extension) {
        return new File(ClassCoverage.replaceExtension(file.toString(), extension));
    }

    public static String replaceExtension(String name, String extension) {
        int slash;
        int dot = name.lastIndexOf(46);
        String basePath = dot <= (slash = Math.max(name.lastIndexOf(47), name.lastIndexOf(File.separatorChar))) ? name : name.substring(0, dot);
        return basePath + extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPoints() {
        ClassCoverage classCoverage = this;
        synchronized (classCoverage) {
            this.points.clear();
        }
    }

    public synchronized void addPoint(CoveragePoint point) {
        if (point == null) {
            throw new NullPointerException();
        }
        if (point.getMethodNumber() >= this.methodNames.size()) {
            throw new IllegalArgumentException("method number out of range: " + point.getMethodNumber() + "/" + this.methodNames.size());
        }
        this.points.add(point);
    }

    public List getRawPoints() {
        return this.points;
    }

    public List getPoints() {
        if (this.filteredPoints == null) {
            this.filteredPoints = new ArrayList();
            HashMap<Integer, CoveragePoint> lineToPoint = new HashMap<Integer, CoveragePoint>();
            Iterator iter = this.points.iterator();
            while (iter.hasNext()) {
                CoveragePoint point = (CoveragePoint)iter.next();
                if (point.getType() == 2 && iter.hasNext()) {
                    CoveragePoint falsePoint = (CoveragePoint)iter.next();
                    CoveragePoint truePoint = new CoveragePoint(point.getType(), point.getByteOffset(), point.getMethodNumber(), point.getLineNumber());
                    truePoint.setTimesReached(point.getTimesReached() - falsePoint.getTimesReached());
                    this.filteredPoints.add(truePoint);
                    this.filteredPoints.add(falsePoint);
                    continue;
                }
                if (point.getType() == 1 && iter.hasNext()) {
                    CoveragePoint truePoint = (CoveragePoint)iter.next();
                    CoveragePoint falsePoint = new CoveragePoint(point.getType(), point.getByteOffset(), point.getMethodNumber(), point.getLineNumber());
                    falsePoint.setTimesReached(point.getTimesReached() - truePoint.getTimesReached());
                    this.filteredPoints.add(falsePoint);
                    this.filteredPoints.add(truePoint);
                    continue;
                }
                if (point.getType() == 0) {
                    CoveragePoint oldPoint = (CoveragePoint)lineToPoint.get(new Integer(point.getLineNumber()));
                    if (oldPoint == null) {
                        lineToPoint.put(new Integer(point.getLineNumber()), point);
                        this.filteredPoints.add(point);
                        continue;
                    }
                    oldPoint.setTimesReached(Math.max(oldPoint.getTimesReached(), point.getTimesReached()));
                    continue;
                }
                if (point.getType() == -1) continue;
                this.filteredPoints.add(point);
            }
        }
        return this.filteredPoints;
    }

    public synchronized int[] getCounters() {
        int[] counters = new int[this.points.size()];
        Iterator iterator = this.points.iterator();
        for (int i = 0; i < counters.length; ++i) {
            CoveragePoint point = (CoveragePoint)iterator.next();
            counters[i] = point.getTimesReached();
        }
        return counters;
    }

    public int getPointForLine(int line) {
        for (int i = 0; i < this.points.size(); ++i) {
            CoveragePoint point = (CoveragePoint)this.points.get(i);
            if (point.getLineNumber() != line) continue;
            return i;
        }
        return -1;
    }

    public int[] getTotalCoverage() {
        return this.getTotalCoverage(new String[0]);
    }

    public int getCoveragePercent() {
        int[] cov = this.getTotalCoverage();
        return this.calcCoverage(cov);
    }

    private int calcCoverage(int[] cov) {
        if (cov == null || cov.length != 2) {
            return 0;
        }
        if (cov[0] == 0) {
            return 0;
        }
        float f = (float)cov[1] / (float)cov[0];
        return Math.round(f * 100.0f);
    }

    public int[] getTotalCoverage(String[] privateInners) {
        Counter totalCount = new Counter();
        Counter coveredCount = new Counter();
        this.countLinesAndConditions(totalCount, coveredCount);
        if (privateInners != null && privateInners.length > 0) {
            this.countPrivateInners(totalCount, coveredCount, privateInners);
        }
        return new int[]{(int)totalCount.getCount(), (int)coveredCount.getCount()};
    }

    private void countLinesAndConditions(Counter totalCount, Counter coveredCount) {
        List filteredPoints = this.getPoints();
        HashSet<Integer> lines = new HashSet<Integer>(filteredPoints.size());
        Iterator iterator1 = filteredPoints.iterator();
        while (iterator1.hasNext()) {
            CoveragePoint point = (CoveragePoint)iterator1.next();
            if (point.getType() == 0) continue;
            lines.add(new Integer(point.getLineNumber()));
            totalCount.add();
            if (point.getTimesReached() <= 0) continue;
            coveredCount.add();
        }
        Iterator iterator2 = filteredPoints.iterator();
        while (iterator2.hasNext()) {
            CoveragePoint point = (CoveragePoint)iterator2.next();
            if (point.getType() != 0 || lines.contains(new Integer(point.getLineNumber()))) continue;
            totalCount.add();
            if (point.getTimesReached() <= 0) continue;
            coveredCount.add();
        }
    }

    private void countPrivateInners(Counter totalCount, Counter coveredCount, String[] classNames) {
        for (int i = 0; i < classNames.length; ++i) {
            TypeName cn = TypeName.get((String)classNames[i]);
            if (!cn.isInnerClass() || !cn.getContainingClass().getName(7).equals(this.className)) continue;
            try {
                Class<?> jc = Class.forName(classNames[i]);
                if (!Modifier.isPrivate(jc.getModifiers())) continue;
                try {
                    ClassCoverage subCoverage = CoverageManager.getCoverage(classNames[i], true);
                    if (subCoverage == null) continue;
                    int[] subCount = subCoverage.getTotalCoverage();
                    totalCount.add(subCount[0]);
                    coveredCount.add(subCount[1]);
                }
                catch (IOException e) {}
                continue;
            }
            catch (ClassNotFoundException x) {
                // empty catch block
            }
        }
    }

    public int getMethodCount() {
        return this.methodNames.size();
    }

    public int getMethodIndex(String key) {
        if (key != null && this.methodNames != null) {
            for (int i = 0; i < this.methodNames.size(); ++i) {
                if (!key.equals(this.methodNames.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public int[] getTotalMethodCoverage(String key) {
        return this.getTotalMethodCoverage(this.getMethodIndex(key));
    }

    public int getMethodCoveragePercent(String key) {
        int[] cov = this.getTotalMethodCoverage(key);
        return this.calcCoverage(cov);
    }

    public int[] getTotalMethodCoverage(int index) {
        int totalCount = 0;
        int coveredCount = 0;
        List filteredPoints = this.getPoints();
        HashSet<Integer> lines = new HashSet<Integer>(filteredPoints.size());
        Iterator iterator1 = filteredPoints.iterator();
        while (iterator1.hasNext()) {
            CoveragePoint point = (CoveragePoint)iterator1.next();
            if (point.getMethodNumber() != index || point.getType() == 0) continue;
            lines.add(new Integer(point.getLineNumber()));
            ++totalCount;
            if (point.getTimesReached() <= 0) continue;
            ++coveredCount;
        }
        Iterator iterator2 = filteredPoints.iterator();
        while (iterator2.hasNext()) {
            CoveragePoint point = (CoveragePoint)iterator2.next();
            if (point.getMethodNumber() != index || point.getType() != 0 || lines.contains(new Integer(point.getLineNumber()))) continue;
            ++totalCount;
            if (point.getTimesReached() <= 0) continue;
            ++coveredCount;
        }
        return new int[]{totalCount, coveredCount};
    }

    public void addMethod(String name, boolean pvt) {
        this.methodNames.add(name);
        this.methodPrivates.add(pvt);
    }

    public void setMethods(String[] methodNames) {
        this.methodNames.clear();
        this.methodPrivates.clear();
        for (int i = 0; methodNames != null && i < methodNames.length; ++i) {
            if (methodNames[i] == null) {
                this.methodNames.add(UNKNOWN);
            } else {
                this.methodNames.add(methodNames[i]);
            }
            this.methodPrivates.add(Boolean.FALSE);
        }
    }

    public String getMethodName(int n) {
        return (String)this.methodNames.get(n);
    }

    public String[] getMethodNames() {
        return this.methodNames.toArray(new String[this.methodNames.size()]);
    }

    public MethodSignature[] getMethodSignatures() {
        MethodSignature[] sigs = new MethodSignature[this.methodNames.size()];
        for (int i = 0; i < sigs.length; ++i) {
            String methodName = (String)this.methodNames.get(i);
            int dot = methodName.indexOf(46);
            sigs[i] = MethodSignature.fromRawForm((String)this.className, (String)methodName.substring(0, dot), (String)methodName.substring(dot + 1));
        }
        return sigs;
    }

    public void read(DataInput in) throws IOException {
        int i;
        int fileVersion = in.readInt();
        this.washerMode = fileVersion < 4 || in.readBoolean();
        this.className = in.readUTF();
        this.sourceFile = in.readUTF();
        this.originalChecksum = in.readLong();
        this.instrClassName = in.readUTF();
        this.originalTimeStamp = fileVersion >= 1 ? in.readLong() : 0L;
        int methodCount = in.readInt();
        this.methodNames.clear();
        this.methodPrivates.clear();
        for (i = 0; i < methodCount; ++i) {
            this.methodNames.add(UNKNOWN);
            this.methodPrivates.add(Boolean.FALSE);
        }
        for (i = 0; i < methodCount; ++i) {
            this.methodNames.set(i, in.readUTF());
            if (fileVersion < 2) continue;
            this.methodPrivates.set(i, in.readBoolean());
        }
        int pointCount = in.readInt();
        this.points.clear();
        this.points.ensureCapacity(pointCount);
        for (int i2 = 0; i2 < pointCount; ++i2) {
            CoveragePoint point = new CoveragePoint(in, fileVersion);
            this.points.add(point);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(4);
        out.writeBoolean(CoverageManager.isWasherMode());
        out.writeUTF(this.className);
        out.writeUTF(this.sourceFile);
        out.writeLong(this.originalChecksum);
        out.writeUTF(this.instrClassName);
        out.writeLong(this.originalTimeStamp);
        int methodCount = this.methodNames.size();
        out.writeInt(methodCount);
        for (int i = 0; i < methodCount; ++i) {
            out.writeUTF((String)this.methodNames.get(i));
            out.writeBoolean((Boolean)this.methodPrivates.get(i));
        }
        int pointCount = this.points.size();
        out.writeInt(pointCount);
        Iterator iter = this.points.iterator();
        while (iter.hasNext()) {
            CoveragePoint point = (CoveragePoint)iter.next();
            point.write(out);
        }
    }

    public void clearReached() {
        Iterator iter = this.points.iterator();
        while (iter.hasNext()) {
            CoveragePoint point = (CoveragePoint)iter.next();
            point.setTimesReached(0);
        }
        this.filteredPoints = null;
    }

    public void updateReached() {
        int[] counters = CoverageManager.getCounters(this.className);
        if (counters != null && counters.length == this.points.size()) {
            this.updateReached(counters);
        }
        this.filteredPoints = null;
    }

    public synchronized void addToReached(int[] cvg) throws IllegalArgumentException {
        if (cvg.length != this.points.size()) {
            throw new IllegalArgumentException("update data (" + cvg.length + ") has different size than file data (" + this.points.size() + ")");
        }
        Iterator iter = this.points.iterator();
        for (int i = 0; i < cvg.length; ++i) {
            CoveragePoint point = (CoveragePoint)iter.next();
            point.setTimesReached(cvg[i] + point.getTimesReached());
        }
        this.filteredPoints = null;
    }

    public synchronized void updateReached(int[] cvg) throws IllegalArgumentException {
        if (cvg.length != this.points.size()) {
            throw new IllegalArgumentException("update data (" + cvg.length + ") has different size than file data (" + this.points.size() + ")");
        }
        Iterator iter = this.points.iterator();
        for (int i = 0; i < cvg.length; ++i) {
            CoveragePoint point = (CoveragePoint)iter.next();
            point.setTimesReached(cvg[i]);
        }
        this.filteredPoints = null;
    }

    public void merge(ClassCoverage that) {
        this.checkCompatibility(that);
        for (int i = 0; i < this.points.size(); ++i) {
            CoveragePoint point = (CoveragePoint)this.points.get(i);
            CoveragePoint thatPoint = (CoveragePoint)that.points.get(i);
            point.setTimesReached(point.getTimesReached() + thatPoint.getTimesReached());
        }
        this.filteredPoints = null;
    }

    public void checkCompatibility(ClassCoverage that) {
        if (this.points.size() != that.points.size()) {
            throw new IllegalArgumentException("coverage size mismatch: " + this.points.size() + " != " + that.points.size() + " [" + this.className + "]");
        }
        for (int i = 0; i < this.points.size(); ++i) {
            CoveragePoint point = (CoveragePoint)this.points.get(i);
            CoveragePoint thatPoint = (CoveragePoint)that.points.get(i);
            if (point.getType() == thatPoint.getType() && point.getLineNumber() == thatPoint.getLineNumber() && point.getMethodNumber() == thatPoint.getMethodNumber() && point.getByteOffset() == thatPoint.getByteOffset()) continue;
            throw new IllegalArgumentException("coverage point mismatch, offset " + i);
        }
    }

    public CoveragePoint[] getCoveragePointsForMethod(MethodSignature ms, boolean includePrivateCoverage) {
        if (this.points == null || this.points.size() == 0) {
            return new CoveragePoint[0];
        }
        ArrayList<CoveragePoint> ret = new ArrayList<CoveragePoint>();
        int methodIndex = this.getMethodIndex(ms.getKey());
        for (int i = 0; i < this.points.size(); ++i) {
            CoveragePoint cp = (CoveragePoint)this.points.get(i);
            if (cp.getType() == -1) continue;
            int cpMethod = cp.getMethodNumber();
            boolean pvt = (Boolean)this.methodPrivates.get(cpMethod);
            if (cpMethod != methodIndex && (!includePrivateCoverage || !pvt)) continue;
            ret.add(cp);
        }
        return ret.toArray(new CoveragePoint[ret.size()]);
    }

    public int[] getCountersForMethod(MethodSignature ms, int[] cov, boolean includePrivateCoverage) {
        if (this.points == null || this.points.size() == 0) {
            return new int[0];
        }
        if (cov != null && !$assertionsDisabled && cov.length != this.points.size()) {
            throw new AssertionError();
        }
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int methodIndex = this.getMethodIndex(ms.getKey());
        for (int i = 0; i < this.points.size(); ++i) {
            int timesReached;
            CoveragePoint cp = (CoveragePoint)this.points.get(i);
            if (cp.getType() == -1) continue;
            int cpMethod = cp.getMethodNumber();
            boolean pvt = (Boolean)this.methodPrivates.get(cpMethod);
            int n = timesReached = cov == null ? cp.getTimesReached() : cov[i];
            if (cpMethod != methodIndex && (!includePrivateCoverage || !pvt)) continue;
            ret.add(new Integer(timesReached));
        }
        int[] retArray = new int[ret.size()];
        for (int i = 0; i < retArray.length; ++i) {
            retArray[i] = (Integer)ret.get(i);
        }
        return retArray;
    }

    public int[] getCountersForMethod(MethodSignature methodSignature, boolean includePrivateCoverage) {
        return this.getCountersForMethod(methodSignature, null, includePrivateCoverage);
    }

    public String getSourceFile() {
        return UNKNOWN.equals(this.sourceFile) ? null : this.sourceFile;
    }

    public int getComplexity() {
        int complexity = this.getMethodCount();
        Iterator iter = this.getPoints().iterator();
        while (iter.hasNext()) {
            CoveragePoint point = (CoveragePoint)iter.next();
            if (point.getType() != 2) continue;
            ++complexity;
        }
        return complexity;
    }

    public int getComplexity(int methodNumber) {
        int complexity = 1;
        Iterator iter = this.getPoints().iterator();
        while (iter.hasNext()) {
            CoveragePoint point = (CoveragePoint)iter.next();
            if (point.getType() != 2 || point.getMethodNumber() != methodNumber) continue;
            ++complexity;
        }
        return complexity;
    }

    public File getCoverageDir() {
        return this.coverageDir;
    }

    static {
        $assertionsDisabled = !ClassCoverage.class.desiredAssertionStatus();
    }
}

