/*
 * Decompiled with CFR 0.152.
 */
package net.ffxml.swtforms.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import net.ffxml.swtforms.util.AbstractUnitConverter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class DefaultUnitConverter
extends AbstractUnitConverter {
    private static DefaultUnitConverter instance;
    private FontMetrics defaultDialogFontMetrics;
    private PropertyChangeSupport changeSupport;
    private DialogBaseUnits cachedGlobalDialogBaseUnits = this.computeGlobalDialogBaseUnits();
    private Map cachedDialogBaseUnits = new HashMap();

    public static DefaultUnitConverter getInstance() {
        if (instance == null) {
            instance = new DefaultUnitConverter();
        }
        return instance;
    }

    public FontMetrics getDefaultDialogFontMetrics() {
        if (this.defaultDialogFontMetrics == null) {
            this.defaultDialogFontMetrics = this.lookupDefaultDialogFontMetrics();
        }
        return this.defaultDialogFontMetrics;
    }

    public void setDefaultDialogFontMetrics(FontMetrics newFontMetrics) {
        FontMetrics oldFontMetrics = this.defaultDialogFontMetrics;
        this.defaultDialogFontMetrics = newFontMetrics;
        this.changeSupport.firePropertyChange("defaultDialogFontMetrics", oldFontMetrics, newFontMetrics);
    }

    protected double getDialogBaseUnitsX(Control control) {
        return this.getDialogBaseUnits((Control)control).x;
    }

    protected double getDialogBaseUnitsY(Control control) {
        return this.getDialogBaseUnits((Control)control).y;
    }

    private DialogBaseUnits getGlobalDialogBaseUnits() {
        if (this.cachedGlobalDialogBaseUnits == null) {
            this.cachedGlobalDialogBaseUnits = this.computeGlobalDialogBaseUnits();
        }
        return this.cachedGlobalDialogBaseUnits;
    }

    private DialogBaseUnits getDialogBaseUnits(Control c) {
        if (c == null) {
            return this.getGlobalDialogBaseUnits();
        }
        DialogBaseUnits dialogBaseUnits = (DialogBaseUnits)this.cachedDialogBaseUnits.get(c.getFont());
        if (dialogBaseUnits == null) {
            GC gc = new GC((Drawable)c);
            FontMetrics fm = gc.getFontMetrics();
            dialogBaseUnits = this.computeDialogBaseUnits(fm);
            this.cachedDialogBaseUnits.put(c.getFont(), dialogBaseUnits);
            gc.dispose();
        }
        return dialogBaseUnits;
    }

    private DialogBaseUnits computeDialogBaseUnits(FontMetrics metrics) {
        double averageCharWidth = this.computeAverageCharWidth(metrics);
        double height = metrics.getHeight();
        DialogBaseUnits dialogBaseUnits = new DialogBaseUnits(averageCharWidth, height);
        this.logInfo("Computed dialog base units " + dialogBaseUnits + " for: " + metrics.toString());
        return dialogBaseUnits;
    }

    private DialogBaseUnits computeGlobalDialogBaseUnits() {
        this.logInfo("Computing global dialog base units...");
        FontMetrics fm = this.getDefaultDialogFontMetrics();
        DialogBaseUnits result = this.computeDialogBaseUnits(fm);
        return result;
    }

    private FontMetrics lookupDefaultDialogFontMetrics() {
        GC gc = new GC((Drawable)Display.getCurrent());
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        return fm;
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public final synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public final synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public final synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    private void logInfo(String message) {
    }

    private static class DialogBaseUnits {
        final double x;
        final double y;

        DialogBaseUnits(double dialogBaseUnitsX, double dialogBaseUnitsY) {
            this.x = dialogBaseUnitsX;
            this.y = dialogBaseUnitsY;
        }

        public String toString() {
            return "DBU(x=" + this.x + "; y=" + this.y + ")";
        }
    }
}

