/*
 * Decompiled with CFR 0.152.
 */
package net.ffxml.swtforms.util;

import net.ffxml.swtforms.util.UnitConverter;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractUnitConverter
implements UnitConverter {
    private static final int DTP_RESOLUTION = 72;
    private static int defaultScreenResolution = -1;

    public int inchAsPixel(double in) {
        return this.inchAsPixel(in, this.getScreenResolution());
    }

    public int millimeterAsPixel(double mm) {
        return this.millimeterAsPixel(mm, this.getScreenResolution());
    }

    public int centimeterAsPixel(double cm) {
        return this.centimeterAsPixel(cm, this.getScreenResolution());
    }

    public int pointAsPixel(int pt) {
        return this.pointAsPixel(pt, this.getScreenResolution());
    }

    public int dialogUnitXAsPixel(int dluX, Control c) {
        return this.dialogUnitXAsPixel(dluX, this.getDialogBaseUnitsX(c));
    }

    public int dialogUnitYAsPixel(int dluY, Control c) {
        return this.dialogUnitYAsPixel(dluY, this.getDialogBaseUnitsY(c));
    }

    protected abstract double getDialogBaseUnitsX(Control var1);

    protected abstract double getDialogBaseUnitsY(Control var1);

    protected final int inchAsPixel(double in, int dpi) {
        return (int)Math.round((double)dpi * in);
    }

    protected final int millimeterAsPixel(double mm, int dpi) {
        return (int)Math.round((double)dpi * mm * 10.0 / 254.0);
    }

    protected final int centimeterAsPixel(double cm, int dpi) {
        return (int)Math.round((double)dpi * cm * 100.0 / 254.0);
    }

    protected final int pointAsPixel(int pt, int dpi) {
        return Math.round(dpi * pt / 72);
    }

    protected int dialogUnitXAsPixel(int dluX, double dialogBaseUnitsX) {
        return (int)Math.round((double)dluX * dialogBaseUnitsX / 4.0);
    }

    protected int dialogUnitYAsPixel(int dluY, double dialogBaseUnitsY) {
        return (int)Math.round((double)dluY * dialogBaseUnitsY / 8.0);
    }

    protected double computeAverageCharWidth(FontMetrics metrics) {
        return metrics.getAverageCharWidth();
    }

    protected int getScreenResolution() {
        return this.getDefaultScreenResolution();
    }

    protected int getDefaultScreenResolution() {
        if (defaultScreenResolution == -1) {
            defaultScreenResolution = Display.getCurrent().getDPI().x;
        }
        return defaultScreenResolution;
    }
}

