/*
 * Decompiled with CFR 0.152.
 */
package net.ffxml.swtforms.layout;

import java.util.Iterator;
import java.util.List;
import net.ffxml.swtforms.layout.BoundedSize;
import net.ffxml.swtforms.layout.ConstantSize;
import net.ffxml.swtforms.layout.FormLayout;
import net.ffxml.swtforms.layout.Size;
import net.ffxml.swtforms.util.DefaultUnitConverter;
import net.ffxml.swtforms.util.UnitConverter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class Sizes {
    public static final ConstantSize ZERO = Sizes.pixel(0);
    public static final ConstantSize DLUX1 = Sizes.dluX(1);
    public static final ConstantSize DLUX2 = Sizes.dluX(2);
    public static final ConstantSize DLUX3 = Sizes.dluX(3);
    public static final ConstantSize DLUX4 = Sizes.dluX(4);
    public static final ConstantSize DLUX7 = Sizes.dluX(7);
    public static final ConstantSize DLUX9 = Sizes.dluX(9);
    public static final ConstantSize DLUX11 = Sizes.dluX(11);
    public static final ConstantSize DLUX14 = Sizes.dluX(14);
    public static final ConstantSize DLUY1 = Sizes.dluY(1);
    public static final ConstantSize DLUY2 = Sizes.dluY(2);
    public static final ConstantSize DLUY3 = Sizes.dluY(3);
    public static final ConstantSize DLUY4 = Sizes.dluY(4);
    public static final ConstantSize DLUY6 = Sizes.dluY(6);
    public static final ConstantSize DLUY7 = Sizes.dluY(7);
    public static final ConstantSize DLUY9 = Sizes.dluY(9);
    public static final ConstantSize DLUY11 = Sizes.dluY(11);
    public static final ConstantSize DLUY14 = Sizes.dluY(14);
    public static final ComponentSize MINIMUM = new ComponentSize("minimum");
    public static final ComponentSize PREFERRED = new ComponentSize("preferred");
    public static final ComponentSize DEFAULT = new ComponentSize("default");
    private static UnitConverter unitConverter;

    private Sizes() {
    }

    public static ConstantSize constant(String encodedValueAndUnit, boolean horizontal) {
        return ConstantSize.valueOf(encodedValueAndUnit, horizontal);
    }

    public static ConstantSize dluX(int value) {
        return ConstantSize.dluX(value);
    }

    public static ConstantSize dluY(int value) {
        return ConstantSize.dluY(value);
    }

    public static ConstantSize pixel(int value) {
        return new ConstantSize(value, ConstantSize.PIXEL);
    }

    public static Size bounded(Size basis, Size lowerBound, Size upperBound) {
        return new BoundedSize(basis, lowerBound, upperBound);
    }

    public static int inchAsPixel(double in) {
        return Sizes.getUnitConverter().inchAsPixel(in);
    }

    public static int millimeterAsPixel(double mm) {
        return Sizes.getUnitConverter().millimeterAsPixel(mm);
    }

    public static int centimeterAsPixel(double cm) {
        return Sizes.getUnitConverter().centimeterAsPixel(cm);
    }

    public static int pointAsPixel(int pt) {
        return Sizes.getUnitConverter().pointAsPixel(pt);
    }

    public static int dialogUnitXAsPixel(int dluX, Control component) {
        return Sizes.getUnitConverter().dialogUnitXAsPixel(dluX, component);
    }

    public static int dialogUnitYAsPixel(int dluY, Control component) {
        return Sizes.getUnitConverter().dialogUnitYAsPixel(dluY, component);
    }

    public static UnitConverter getUnitConverter() {
        if (unitConverter == null) {
            unitConverter = DefaultUnitConverter.getInstance();
        }
        return unitConverter;
    }

    public static void setUnitConverter(UnitConverter newUnitConverter) {
        unitConverter = newUnitConverter;
    }

    static final class ComponentSize
    implements Size {
        private final String name;

        private ComponentSize(String name) {
            this.name = name;
        }

        static ComponentSize valueOf(String str) {
            if (str.equals("m") || str.equals("min")) {
                return MINIMUM;
            }
            if (str.equals("p") || str.equals("pref")) {
                return PREFERRED;
            }
            if (str.equals("d") || str.equals("default")) {
                return DEFAULT;
            }
            return null;
        }

        public int maximumSize(Composite composite, List controls, FormLayout.Measure minMeasure, FormLayout.Measure prefMeasure, FormLayout.Measure defaultMeasure) {
            FormLayout.Measure measure = this == MINIMUM ? minMeasure : (this == PREFERRED ? prefMeasure : defaultMeasure);
            int maximum = 0;
            Iterator i = controls.iterator();
            while (i.hasNext()) {
                Control c = (Control)i.next();
                maximum = Math.max(maximum, measure.sizeOf(c));
            }
            return maximum;
        }

        public String toString() {
            return this.name.substring(0, 1);
        }
    }
}

