/*
 * Decompiled with CFR 0.152.
 */
package net.ffxml.swtforms.factories;

import net.ffxml.swtforms.factories.ComponentFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DefaultComponentFactory
implements ComponentFactory {
    private static final DefaultComponentFactory INSTANCE = new DefaultComponentFactory();

    private DefaultComponentFactory() {
    }

    public static DefaultComponentFactory getInstance() {
        return INSTANCE;
    }

    public Label createLabel(Composite parent, String textWithMnemonic) {
        Label label = new Label(parent, 0);
        label.setText(textWithMnemonic);
        return label;
    }

    public Label createTitle(Composite parent, String textWithMnemonic) {
        return this.createTitle(parent, textWithMnemonic, 0);
    }

    private Label createTitle(Composite parent, String textWithMnemonic, int gap) {
        Label label = new Label(parent, 0);
        label.setText(textWithMnemonic);
        label.setForeground(Display.getCurrent().getSystemColor(31));
        try {
            Font currentFont = label.getFont();
            FontData fd = currentFont.getFontData()[0];
            if ((fd.getStyle() & 1) == 0) {
                Font newFont = new Font((Device)Display.getCurrent(), fd.getName(), fd.getHeight(), 1);
                label.setFont(newFont);
                label.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent arg0) {
                        ((Label)arg0.widget).getFont().dispose();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return label;
    }

    public Control createSeparator(Composite parent, String text) {
        return this.createSeparator(parent, text, 2);
    }

    public Control createSeparator(Composite parent, String text, int alignment) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label label = this.createTitle(composite, text);
        GridData gd = new GridData(256);
        label.setLayoutData((Object)gd);
        Label separator = new Label(composite, 258);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        separator.setLayoutData((Object)gd);
        return composite;
    }
}

