/*
 * Decompiled with CFR 0.152.
 */
package net.ffxml.swtforms.extras;

import java.util.ResourceBundle;
import net.ffxml.swtforms.extras.I15dPanelBuilder;
import net.ffxml.swtforms.factories.FormFactory;
import net.ffxml.swtforms.layout.ConstantSize;
import net.ffxml.swtforms.layout.FormLayout;
import net.ffxml.swtforms.layout.RowSpec;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class DefaultFormBuilder
extends I15dPanelBuilder {
    private RowSpec lineGapSpec = FormFactory.LINE_GAP_ROWSPEC;
    private RowSpec paragraphGapSpec = FormFactory.PARAGRAPH_GAP_ROWSPEC;
    private int leadingColumnOffset = 0;
    private boolean rowGroupingEnabled = false;
    private Composite panel;

    public DefaultFormBuilder(Composite panel, FormLayout layout) {
        this(panel, layout, null);
        this.panel = panel;
    }

    public DefaultFormBuilder(Composite panel, FormLayout layout, ResourceBundle bundle) {
        super(panel, layout, bundle);
    }

    public void setLineGapSize(ConstantSize lineGapSize) {
        RowSpec rowSpec = FormFactory.createGapRowSpec(lineGapSize);
        this.lineGapSpec = rowSpec.asUnmodifyable();
    }

    public RowSpec getLineGapSpec() {
        return this.lineGapSpec;
    }

    public void setParagraphGapSize(ConstantSize paragraphGapSize) {
        RowSpec rowSpec = FormFactory.createGapRowSpec(paragraphGapSize);
        this.paragraphGapSpec = rowSpec.asUnmodifyable();
    }

    public int getLeadingColumnOffset() {
        return this.leadingColumnOffset;
    }

    public void setLeadingColumnOffset(int columnOffset) {
        this.leadingColumnOffset = columnOffset;
    }

    public boolean isRowGroupingEnabled() {
        return this.rowGroupingEnabled;
    }

    public void setRowGroupingEnabled(boolean enabled) {
        this.rowGroupingEnabled = enabled;
    }

    public void append(Control component) {
        this.append(component, 1);
    }

    public void append(Control component, int columnSpan) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.lineGapSpec);
        this.ensureHasComponentLine();
        this.setColumnSpan(columnSpan);
        this.add(component);
        this.setColumnSpan(1);
        this.nextColumn(columnSpan + 1);
    }

    public void append(Control c1, Control c2) {
        this.append(c1);
        this.append(c2);
    }

    public void append(Control c1, Control c2, Control c3) {
        this.append(c1);
        this.append(c2);
        this.append(c3);
    }

    public Label append(String textWithMnemonic) {
        Label label = this.getComponentFactory().createLabel(this.panel, textWithMnemonic);
        this.append((Control)label);
        return label;
    }

    public Label append(String textWithMnemonic, Control component) {
        return this.append(textWithMnemonic, component, 1);
    }

    public Label append(String textWithMnemonic, Control c, int columnSpan) {
        Label label = this.append(textWithMnemonic);
        this.append(c, columnSpan);
        return label;
    }

    public Label append(String textWithMnemonic, Control c1, Control c2) {
        Label label = this.append(textWithMnemonic, c1);
        this.append(c2);
        return label;
    }

    public void append(String textWithMnemonic, Control c1, Control c2, int colSpan) {
        this.append(textWithMnemonic, c1);
        this.append(c2, colSpan);
    }

    public Label append(String textWithMnemonic, Control c1, Control c2, Control c3) {
        Label label = this.append(textWithMnemonic, c1, c2);
        this.append(c3);
        return label;
    }

    public Label append(String textWithMnemonic, Control c1, Control c2, Control c3, Control c4) {
        Label label = this.append(textWithMnemonic, c1, c2, c3);
        this.append(c4);
        return label;
    }

    public Label appendI15d(String resourceKey) {
        return this.append(this.getI15dString(resourceKey));
    }

    public Label appendI15d(String resourceKey, Control c, int columnSpan) {
        Label label = this.appendI15d(resourceKey);
        this.append(c, columnSpan);
        return label;
    }

    public Label appendI15d(String resourceKey, Control component) {
        return this.appendI15d(resourceKey, component, 1);
    }

    public Label appendI15d(String resourceKey, Control component, boolean nextLine) {
        Label label = this.appendI15d(resourceKey, component, 1);
        if (nextLine) {
            this.nextLine();
        }
        return label;
    }

    public Label appendI15d(String resourceKey, Control c1, Control c2) {
        Label label = this.appendI15d(resourceKey, c1);
        this.append(c2);
        return label;
    }

    public Label appendI15d(String resourceKey, Control c1, Control c2, int colSpan) {
        Label label = this.appendI15d(resourceKey, c1);
        this.append(c2, colSpan);
        return label;
    }

    public Label appendI15d(String resourceKey, Control c1, Control c2, Control c3) {
        Label label = this.appendI15d(resourceKey, c1, c2);
        this.append(c3);
        return label;
    }

    public Label appendI15d(String resourceKey, Control c1, Control c2, Control c3, Control c4) {
        Label label = this.appendI15d(resourceKey, c1, c2, c3);
        this.append(c4);
        return label;
    }

    public Label appendTitle(String textWithMnemonic) {
        Label titleLabel = this.getComponentFactory().createTitle(this.panel, textWithMnemonic);
        this.append((Control)titleLabel);
        return titleLabel;
    }

    public Label appendI15dTitle(String resourceKey) {
        return this.appendTitle(this.getI15dString(resourceKey));
    }

    public Control appendSeparator() {
        return this.appendSeparator("");
    }

    public Control appendSeparator(String text) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.paragraphGapSpec);
        this.ensureHasComponentLine();
        this.setColumn(super.getLeadingColumn());
        int columnSpan = this.getColumnCount();
        this.setColumnSpan(this.getColumnCount());
        Control titledSeparator = this.addSeparator(text);
        this.setColumnSpan(1);
        this.nextColumn(columnSpan);
        return titledSeparator;
    }

    public void appendI15dSeparator(String resourceKey) {
        this.appendSeparator(this.getI15dString(resourceKey));
    }

    protected int getLeadingColumn() {
        int column = super.getLeadingColumn();
        return column + this.getLeadingColumnOffset() * this.getColumnIncrementSign();
    }

    private void ensureCursorColumnInGrid() {
        if (this.getColumn() > this.getColumnCount()) {
            this.nextLine();
        }
    }

    private void ensureHasGapRow(RowSpec gapRowSpec) {
        RowSpec rowSpec;
        if (this.getRow() == 1 || this.getRow() <= this.getRowCount()) {
            return;
        }
        if (this.getRow() <= this.getRowCount() && (rowSpec = this.getCursorRowSpec()) == gapRowSpec) {
            return;
        }
        this.appendRow(gapRowSpec);
        this.nextLine();
    }

    private void ensureHasComponentLine() {
        if (this.getRow() <= this.getRowCount()) {
            return;
        }
        this.appendRow(FormFactory.PREF_ROWSPEC);
        if (this.isRowGroupingEnabled()) {
            this.getLayout().addGroupedRow(this.getRow());
        }
    }

    private RowSpec getCursorRowSpec() {
        return this.getLayout().getRowSpec(this.getRow());
    }
}

